GENERIC

  TYPE ValueType IS PRIVATE;
  TYPE IndexType IS (<>);

  WITH FUNCTION "+"(L,R: ValueType) RETURN ValueType;
  WITH FUNCTION "*"(L,R: ValueType) RETURN ValueType;

  Zero: ValueType;

PACKAGE Vectors_Generic IS
------------------------------------------------------------------
--| Generic specification for vector arithmetic package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------
 
  TYPE Vector IS ARRAY(IndexType RANGE <>) OF ValueType;
 
  -- exported exception, raised if two vectors are not conformable
  -- (i.e., have different bounds)

  Bounds_Error : EXCEPTION;
 
  FUNCTION "+" (K : ValueType; Right : Vector) RETURN Vector;
  -- Pre: K and Right are defined
  -- Post: returns the sum of the vector and the scalar
  --   Result(i) := K + Right(i)
 
  FUNCTION "*" (K : ValueType; Right : Vector) RETURN Vector;
  -- Pre: K and Right are defined
  -- Post: returns the product of the vector and the scalar
  --   Result(i) := K * Right(i)
 
  FUNCTION "*" (Left, Right : Vector) RETURN ValueType;
  -- Pre: Left and Right are defined and have the same bounds
  -- Post: returns the inner product of Left and Right
 
  FUNCTION "+" (Left, Right : Vector) RETURN Vector;
  -- Pre: Left and Right are defined and have the same bounds
  -- Post: returns the sum of Left and Right
  --    Result(i) := Left(i) + Right(i)
 
END Vectors_Generic;
