WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Numerics.Discrete_Random;
WITH Hash_Division_Letter;
PROCEDURE Random_Strings IS
------------------------------------------------------------------
--| Generates 100 random hash codes in the range 0..997
--| Keys are in the range a .. zzzzzz
--| Uses the random number generator from Ada.Numerics
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: February 1996
------------------------------------------------------------------

  SUBTYPE LengthRange IS Positive RANGE 1..6;
  SUBTYPE LetterRange IS Character RANGE 'a'..'z';
  SUBTYPE HashRange IS Natural RANGE 0..996;

  KeyString: String(1..6); -- to hold string form of key
  HashValue: HashRange;
  KeyLength: LengthRange;

  PACKAGE RandomLength IS NEW Ada.Numerics.Discrete_Random
    (Result_Subtype => LengthRange);

  G1: RandomLength.Generator;     

  PACKAGE RandomLetter IS NEW Ada.Numerics.Discrete_Random
    (Result_Subtype => LetterRange);

  G2: RandomLetter.Generator;     

BEGIN -- Random_Strings

  RandomLength.Reset (Gen => G1);  -- starts G from time of day clock
  RandomLetter.Reset (Gen => G2);  -- starts G from time of day clock

  FOR Row IN 1..20 LOOP        -- displays 20 rows of 5 pairs <k, h(k)>

    FOR Num IN 1..5 LOOP

      KeyString := "      ";
      KeyLength := RandomLength.Random(Gen => G1); -- length 

      FOR Count IN 1..KeyLength LOOP
        KeyString(Count) := RandomLetter.Random(Gen => G2);
      END LOOP;

      HashValue := Hash_Division_Letter (KeyString(1..KeyLength), 997);

      Ada.Text_IO.Put(Item => KeyString);
      Ada.Integer_Text_IO.Put(Item => HashValue, Width => 4);
      Ada.Text_IO.Put(Item => "   ");

    END LOOP;

    Ada.Text_IO.New_Line;

  END LOOP;

END Random_Strings;
