WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Dates; USE Dates;
WITH VStrings; 
WITH VStrings.IO; 
PACKAGE BODY Persons IS
------------------------------------------------------------------
--| Body of Persons package 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  PACKAGE Gender_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Genders);

  FUNCTION NameOf(Whom: Person) RETURN NameType IS
  BEGIN
    RETURN Whom.Name;
  END NameOf; 

  FUNCTION GenderOf(Whom: Person) RETURN Genders IS
  BEGIN
    RETURN Whom.Gender;
  END GenderOf;

  FUNCTION DOBOf(Whom: Person) RETURN Date IS
  BEGIN
    RETURN Whom.BirthDate;  
  END DOBOf; 
 
  PROCEDURE Put(Item: Person) IS
  BEGIN
    Ada.Text_IO.Put(Item => "Name: ");
    VStrings.IO.Put(Item => Item.Name);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Gender: ");
    Gender_IO.Put(Item => Item.Gender, Set => Ada.Text_IO.Lower_Case);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Birth Date: ");
    Ada.Integer_Text_IO.Put(Item => Month(Item.BirthDate), Width => 1);
    Ada.Text_IO.Put('/');
    Ada.Integer_Text_IO.Put(Item => DayOfMonth(Item.BirthDate), Width => 1);
    Ada.Text_IO.Put('/');
    Ada.Integer_Text_IO.Put(Item => Year(Item.BirthDate) REM 100, Width => 1);
    Ada.Text_IO.New_Line;
  END Put;

  PACKAGE BODY Constructors IS
  
    FUNCTION MakePerson(Name     : String;
                        Gender   : Genders; 
                        BirthDate: Date) RETURN Person IS
      Result: Person;
    BEGIN
      RETURN (Name      => VStrings.MakeVString(Name, MaxName),
              Gender    => Gender,
              BirthDate => BirthDate);
    END MakePerson;
  
  END Constructors;  

END Persons;   
