WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO; 
WITH Trees_Xref_Generic; 
WITH English_Lexer;
WITH VStrings, VStrings.IO;
PROCEDURE English_Xref IS
------------------------------------------------------------------------
--| Cross-Reference Builder for Simple English
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE DisplayKey(Item : IN English_Lexer.WordType);    -- forward
  PROCEDURE DisplayRef(Item : IN Positive);             -- forward

  PACKAGE XrefTrees IS 
    NEW Trees_Xref_Generic (KeyType => English_Lexer.WordType, 
                            NonKeyInfoType => Positive,
                            "<" => VStrings."<",
                            DisplayKey => DisplayKey,
                            DisplayRef => DisplayRef);

  FileName : VStrings.VString(80);
  F        : Ada.Text_IO.File_Type;
  T          : XrefTrees.Tree;
  LineNumber : Positive := 1;
  ThisWord   : English_Lexer.WordType;
  EOF    : Boolean := False;
  EOL    : Boolean := False;
  Success: Boolean;

  PROCEDURE DisplayKey(Item : IN English_Lexer.WordType) IS
  BEGIN
    Ada.Text_IO.New_Line;
    VStrings.IO.Put(Item => Item);
    Ada.Text_IO.Set_Col(Ada.Text_IO.Positive_Count(22));
  END DisplayKey;

  PROCEDURE DisplayRef(Item : IN Positive) IS
  BEGIN
    Ada.Integer_Text_IO.Put(Item => Item, Width => 4);
  END DisplayRef;

BEGIN -- English_Xref

  Ada.Text_IO.Put_Line ("Please enter name of data file");
  VStrings.IO.Get_Line(FileName, 80);
  Ada.Text_IO.Open(F, Ada.Text_IO.In_File, VStrings.Value(FileName));
  Ada.Text_IO.New_Line;
  Ada.Integer_Text_IO.Put(Item => LineNumber, Width => 4);
  Ada.Text_IO.Put(Item => ' ');
  LOOP
    English_Lexer.GetWord (F, ThisWord, Success, EOL, EOF);
    IF Success THEN
      XRefTrees.Insert (T, ThisWord, LineNumber);
    END IF;
    IF EOL THEN
      LineNumber := LineNumber + 1;
      Ada.Text_IO.New_Line;
      Ada.Integer_Text_IO.Put(Item => LineNumber, Width => 4);
      Ada.Text_IO.Put(Item => ' ');
    END IF;
    EXIT WHEN EOF;
  END LOOP;

  Ada.Text_IO.New_Line(Spacing => 2);
  Ada.Text_IO.Put ("Cross Reference Listing for ");
  VStrings.IO.Put (FileName);
  Ada.Text_IO.New_Line;
  XrefTrees.Display(T);

END English_Xref;
