WITH Ada.Text_IO;
WITH Ada.Command_Line;
PROCEDURE Command_Arguments IS
------------------------------------------------------------------
--| demonstrate Ada 95 command-line parameters
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  HowMany: Natural;  -- how many command-line arguments were there?

BEGIN -- Command_Arguments

  Ada.Text_IO.Put(Item => Ada.Command_Line.Command_Name);

  HowMany := Ada.Command_Line.Argument_Count;

  IF HowMany = 0 THEN
    Ada.Text_IO.Put_Line(Item => ": No command-line arguments today.");
  ELSE  
    Ada.Text_IO.Put_Line(Item => ": The command-line arguments are: ");
  
    FOR Count IN 1..HowMany LOOP
      Ada.Text_IO.Put_Line
        (Item => Ada.Command_Line.Argument(Number => Count));
    END LOOP;
  END IF;
  
END Command_Arguments;
