SEPARATE (AVL_Trees_Generic)
PROCEDURE Rotate_R (T: IN OUT Tree) IS
------------------------------------------------------------------------
--| Right rotation of a node in an AVL tree
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------
  Temp: Tree := T.Right;
BEGIN -- Rotate_R

  T.Right := Temp.Left;
  Temp.Left := T;
  T.Height := Max(Height(T.Right),Height(T.Left)) + 1;
  Temp.Height := Max(Height(Temp.Right), T.Height) + 1;
  T := Temp;

END Rotate_R;
