SEPARATE (Spiders)
PROTECTED BODY Room_Type IS
------------------------------------------------------------------
--| Body of protected type for the spider's room.
--| The room array is protected from concurrent access by 
--| requiring all access to be via the protected procedure Move.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: December 1995                                     
------------------------------------------------------------------

  PROCEDURE Move (Which: IN OUT Spider; HowMany: IN Natural) IS
    Row:    RoomHeight;
    Column: RoomWidth;
  BEGIN -- Move

    -- If out of bounds raise exception.
    IF NearWall (Which, HowMany) THEN
      RAISE Hit_the_Wall;
    END IF;

    Row    := Which.CurrentRow;
    Column := Which.CurrentColumn;

    -- Compute new proposed location
    CASE Which.Heading IS
      WHEN North =>
        Row := Which.CurrentRow - HowMany;
      WHEN East  =>
        Column := Which.CurrentColumn + HowMany;
      WHEN South =>
        Row := Which.CurrentRow + HowMany;
      WHEN West  =>
        Column := Which.CurrentColumn - HowMany;
    END CASE;

    -- Is this space occupied?
    IF RoomBoard(Row, Column) = Occupied THEN
      RAISE Hit_a_Spider;
    ELSE

      -- put a block down where spider is standing; vacate space
      DrawSymbol(Which => Which, WhichChar => ColorSymbols(Which.Ink));
      RoomBoard(Which.CurrentRow, Which.CurrentColumn) := Unoccupied;

      -- occupy new space
      RoomBoard(Row, Column) := Occupied;
      Which.CurrentRow    := Row;
      Which.CurrentColumn := Column;
      ShowSpider (Which);

    END IF;

  END Move;

END Room_Type;
