WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Show_Differences IS
------------------------------------------------------------------
--| Computes the average value of an array of data and
--| prints the difference between each value and the average.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
  
  MaxItems : CONSTANT Positive := 8;    -- number of data items   

  SUBTYPE Index IS Positive RANGE 1..MaxItems; 
  TYPE FloatArray IS ARRAY (Index) OF Float;

  X        : FloatArray;             -- array of data   
  Average  : Float;                  -- average value of data   
  Sum      : Float;                  -- sum of the data   

BEGIN -- Show_Differences   

  -- Enter the data.   
  Ada.Text_IO.Put(Item => "Please enter ");
  Ada.Integer_Text_IO.Put(Item => MaxItems, Width=>0);
  Ada.Text_IO.Put(Item => " floating-point numbers > ");
  Ada.Text_IO.New_Line;

  FOR I IN Index LOOP
    Ada.Float_Text_IO.Get(Item => X(I));
  END LOOP;
  Ada.Text_IO.New_Line;

  -- Compute the average value.   
  Sum := 0.0;                        -- Initialize SUM   
  FOR I IN Index LOOP
    Sum := Sum + X(I);               -- Add each element to Sum   
  END LOOP;

  Average := Sum / FLOAT(MaxItems);  -- Find average value   
  Ada.Text_IO.Put(Item => "Average value is ");
  Ada.Float_Text_IO.Put(Item=>Average, Fore=>5, Aft=>2, Exp=>0);  
  Ada.Text_IO.New_Line;

  -- Display the difference between each item and the average.   
  Ada.Text_IO.Put(Item => "Table of differences between X(I) and average");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "   I        X(I)     Difference");  
  Ada.Text_IO.New_Line;

  FOR I IN Index LOOP
    Ada.Integer_Text_IO.Put(Item => I, Width=>4);  
    Ada.Text_IO.Put(Item => "    ");
    Ada.Float_Text_IO.Put(Item=>X(I), Fore=>5, Aft=>2, Exp=>0);  
    Ada.Text_IO.Put(Item => "    ");
    Ada.Float_Text_IO.Put(Item=>X(I)-Average, Fore=>5, Aft=>2, Exp=>0);  
    Ada.Text_IO.New_Line;
  END LOOP;

END Show_Differences;
