WITH Ada.Text_IO; USE Ada.Text_IO;
WITH Currency; USE Currency;
WITH Dates; USE Dates;
WITH Persons; USE Persons;
WITH Personnel; USE Personnel;
WITH Payroll; USE Payroll;
WITH Lists_Generic;
PROCEDURE Payroll_List IS
------------------------------------------------------------------
--| Demonstrates the use of a heterogeneous list.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
    
  TYPE PayrollPointer IS ACCESS ALL Person'Class;
  -- as before, this can designate a Person or anything
  -- derived from Person
  
  PROCEDURE PutPerson (Item: IN PayrollPointer) IS
  BEGIN
    Put(Item => Item.ALL);  -- dispatch to the appropriate Put
    Ada.Text_IO.Put_Line(Item => "------------------------");
  END PutPerson;

  PACKAGE PayrollLists IS NEW Lists_Generic
    (ElementType => PayrollPointer, DisplayElement => PutPerson);
  USE PayrollLists;
  -- The list element type is now a classwide pointer
  
  Company: List;
  Temp   : PayrollPointer;
  
BEGIN -- Payroll_List

  -- Construct all the people dynamically, and add each one
  -- to the end of the list as it is constructed. We no longer
  -- need an explicit variable for each person.
  
  Temp := NEW Person'(Persons.Constructors.MakePerson(
              Name      => "George",
              Gender    => Male,
              BirthDate => Date_Of(1971,Nov,2)));
  AddToEnd(Company, Temp);
  
  Temp := NEW Employee'(Personnel.Constructors.MakeEmployee(
                Name      => "Mary",  
                Gender    => Female,
                BirthDate => Date_Of(1950,Oct,21),
                ID        => 1234,
                StartDate => Date_Of(1989,Jul,1)));
  AddToEnd(Company, Temp);
  
  Temp := NEW Professional'(Payroll.Constructors.MakeProfessional(
             Name        => "Martha",
             Gender      => Female,
             BirthDate   => Date_Of(1947,Jul,8),
             ID          => 2222,
             StartDate   => Date_Of(1985,Jun,6),
             MonthSalary => MakeCurrency(50000.00)));
  AddToEnd(Company, Temp);
  
  Temp := NEW Sales'(Payroll.Constructors.MakeSales(
             Name       => "Virginia",
             Gender     => Female,
             BirthDate  => Date_Of(1955,Feb,1),
             ID         => 3456,
             StartDate  => Date_Of(1990,Jan,1),
             WeekSalary => MakeCurrency(2500.00),
             CommRate   => 0.25)); 
  AddToEnd(Company, Temp);
  
  Temp := NEW Clerical'(Payroll.Constructors.MakeClerical(
             Name       => "Herman",
             Gender     => Male,
             BirthDate  => Date_Of(1975,May,13),
             ID         => 1557,
             StartDate  => Date_Of(1991,Jul,1),
             HourlyWage => MakeCurrency(7.50)));
  AddToEnd(Company, Temp);
  
  -- Now we can display the list. 

  Display (Company);

END Payroll_List; 
