WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Command_Line;
PROCEDURE Line_Length IS
------------------------------------------------------------------
--| Compute maximum line length in a file
--| First command line parameter gives the desired max number
--| of characters; second parameter gives input file.
--| Program displays lines longer than the desired max,
--| and finds the length of the longest line in the file.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995 
------------------------------------------------------------------

  DesiredMax: Natural;        -- input  - desired maximum length
  MaxLength : Natural;        -- output - maximum line length

  LineNumber: Natural;        -- counts the lines in the file
  Line      : String(1..120); -- holder for input line read from file
  Length    : Natural;        -- holds length of current line

  InputText : Ada.Text_IO.File_Type;

BEGIN -- Line_Length;

  -- Get command parameters and open input file
  Ada.Integer_Text_IO.Get (From => Ada.Command_Line.Argument(1),
                           Item => DesiredMax,
                           Last => Length);

  Ada.Text_IO.Put 
    (Item => "Reading from " & Ada.Command_Line.Argument(2));    
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Open (File => InputText, Mode => Ada.Text_IO.In_File,
                    Name => Ada.Command_Line.Argument(2));

  -- loop through file reading lines
  MaxLength := 0;
  LineNumber := 0;
  WHILE NOT Ada.Text_IO.End_of_File (File => InputText) LOOP

    Ada.Text_IO.Get_Line
      (File => InputText, Item => Line, Last => Length);

    -- keep track of number of lines in the file
    LineNumber := LineNumber + 1;

    -- is line too long?
    IF Length > DesiredMax THEN
      Ada.Integer_Text_IO.Put(Item => LineNumber, Width => 3);
      Ada.Text_IO.Put(Item => " " & Line(1..Length));
      Ada.Text_IO.New_Line;
    END IF;

    -- is line longer than longest so far?
    IF Length > MaxLength THEN
      MaxLength := Length;
    END IF;

  END LOOP;

  -- display results
  Ada.Text_IO.Put(Item => "The longest line length in " &
                          Ada.Command_Line.Argument(2) & " is ");
  Ada.Integer_Text_IO.Put(Item => MaxLength, Width => 1);
  Ada.Text_IO.New_Line;

END Line_Length;
