WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Grow_Money IS
------------------------------------------------------------------
--| Displays a table of interest earned and account balance for each
--| investment year for fixed or varying rate certificates.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
 
  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
 
  FixedOrVar : Character;   -- input - indicates fixed or varying rate
  Deposit :    NonNegFloat; -- input - initial amount of deposit   
  Rate :       NonNegFloat; -- input - annual rate of interest   
  TargetBal :  NonNegFloat; -- input - the target certificate amount   
  Balance :    NonNegFloat; -- output - current certificate amount   
  Interest :   NonNegFloat; -- output - amount of annual interest   
  Year :       Natural;     -- output - year of investment  
 
BEGIN -- Grow_Money  

  Ada.Text_IO.Put (Item => "Enter the deposit amount $");
  Ada.Float_Text_IO.Get (Item => Deposit);  
 
  Ada.Text_IO.Put (Item => "Enter the desired final balance $");
  Ada.Float_Text_IO.Get (Item => TargetBal);  
 
  Ada.Text_IO.Put (Item => "Is the interest rate fixed (F) or variable (V)? ");
  Ada.Text_IO.Get (Item => FixedOrVar);  

  IF FixedOrVar = 'F' THEN
    Ada.Text_IO.Put (Item => "Enter the interest rate as a decimal fraction > ");
    Ada.Float_Text_IO.Get (Item => Rate);  
  END IF;
 
  -- Display table heading   
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "Year       Interest        Balance");  
  Ada.Text_IO.New_Line;
 
  -- Display the certificate balance for each year.   
  Year := 0;
  Balance := Deposit;
  Interest := 0.0;
  WHILE Balance < TargetBal LOOP
     -- invariant:
     --   Balance < TargetBal + Interest and
     --   Balance is the sum of Deposit and all values of Interest

    Year := Year + 1;
    IF FixedOrVar = 'V' THEN
      Ada.Text_IO.Put (Item => "Enter rate for year ");
      Ada.Integer_Text_IO.Put (Item => Year, Width => 0);  
      Ada.Text_IO.Put (Item => " > ");
      Ada.Float_Text_IO.Get (Item => Rate);  
    END IF;
 
    Interest := Balance * Rate;
    Balance := Balance + Interest;
 
    Ada.Integer_Text_IO.Put (Item => Year, Width => 4);      
    Ada.Float_Text_IO.Put (Item => Interest, Fore => 12, Aft => 2, Exp => 0);
    Ada.Float_Text_IO.Put (Item => Balance, Fore => 12, Aft => 2, Exp => 0);  
    Ada.Text_IO.New_Line;
  END LOOP;
  -- assert: Balance >= TargetBal and
  --   Balance is the sum of Deposit and all values of Interest
     
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "Certificate amount reaches target after ");
  Ada.Integer_Text_IO.Put (Item => Year, Width => 2);
  Ada.Text_IO.Put (Item => " years");  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "Final balance is $");
  Ada.Float_Text_IO.Put (Item => Balance, Fore => 1, Aft => 2, Exp => 0);  
  Ada.Text_IO.New_Line;

END Grow_Money;
