WITH Ada.Text_IO;
WITH Screen;
PROCEDURE Four_Pieces IS
------------------------------------------------------------------
--| This program divides the screen into four pieces by drawing horizontal
--| and vertical lines. The Screen package is used to position the cursor.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

BEGIN -- Four_Pieces

  Screen.ClearScreen;
  
  FOR Count IN Screen.Depth LOOP
    Screen.MoveCursor (Row => Count, Column => 41);
    Ada.Text_IO.Put (Item => '|');
    Screen.MoveCursor (Row => (Screen.Screen_Depth - Count) + 1, Column => 42);
    Ada.Text_IO.Put (Item => '|');
  END LOOP;
  
  FOR Count IN Screen.Width LOOP
    Screen.MoveCursor (Row => 12, Column => Count);
    Ada.Text_IO.Put (Item => '-');
    Screen.MoveCursor (Row => 13, Column => (Screen.Screen_Width - Count) + 1);
    Ada.Text_IO.Put (Item => '-');
  END LOOP;

  Screen.MoveCursor (Row => 24, Column => 1);

END Four_Pieces;
