WITH Ada.Text_IO;
PACKAGE Dates.IO IS
------------------------------------------------------------------
--| Specification for child package to read and display dates   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: November 1995                                     
------------------------------------------------------------------

  TYPE Formats IS
    (Full,            -- February 7, 1991
     Short,           -- 07 FEB 91
     Numeric);        -- 2/7/91

  PROCEDURE Get(Item: OUT Date);
  PROCEDURE Get(File: IN Ada.Text_IO.File_Type; Item: OUT Date);
  -- Pre:  File is open
  -- Post: Reads a date in mmm dd yyyy form from standard or input
  --   or an external file, respectively

  PROCEDURE Put(Item: IN Date; Format: IN Formats);
  PROCEDURE Put(File: IN Ada.Text_IO.File_Type; 
                Item: IN Date; Format: IN Formats);
  -- Pre:  File is open; Item and Format are defined
  -- Post: Writes a date in the desired format to standard output 
  --   or an external file, respectively

END Dates.IO;
