
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: twiddle.adb 
--        Date: 12/25/95
-- Description: Generic package body of Ada-callable
--              bit-wise logical operations for integer-sized
--              types. Interfaces with C functions found in 
--              twid.c
------------------------------------------------------------

with ada.unchecked_conversion; use ada;
with c;
package body twiddle is

   function band    (left, right : c_int_type) return c_int_type;
   function bor     (left, right : c_int_type) return c_int_type;
   function bxor    (left, right : c_int_type) return c_int_type;
   function bnot    (num         : c_int_type) return c_int_type; 
   function blshift (num,  bits  : c_int_type) return c_int_type;
   function brshift (num,  bits  : c_int_type) return c_int_type;

   pragma import (C, band,    "and"   );
   pragma import (C, bor ,    "or"    );
   pragma import (C, bxor,    "xor"   );
   pragma import (C, bnot,    "not"   );
   pragma import (C, blshift, "lshift");
   pragma import (C, brshift, "rshift");


   function to_c is new unchecked_conversion (
			      source => ada_int_type,
			      target => c_int_type );


   function from_c is new unchecked_conversion (
			      source => c_int_type,
			      target => ada_int_type );


-- bitwise logical operators

   function "and" (left, right : ada_int_type) return ada_int_type is
      temp_left, temp_right : c_int_type;
   begin
      temp_left  := to_c (left);
      temp_right := to_c (right);
      return from_c ( band ( temp_left, temp_right ));
   end "and";


   function "or"  (left, right : ada_int_type) return ada_int_type is
      temp_left, temp_right : c_int_type;
   begin
      temp_left  := to_c (left);
      temp_right := to_c (right);
      return from_c ( bor ( temp_left, temp_right ));
   end "or";


   function "xor" (left, right : ada_int_type) return ada_int_type is
      temp_left, temp_right : c_int_type;
   begin
      temp_left  := to_c (left);
      temp_right := to_c (right);
      return from_c ( bxor ( temp_left, temp_right ));
   end "xor";


   function "not" (num : ada_int_type) return ada_int_type is
      temp_num: c_int_type;
   begin
      temp_num  := to_c (num);
      return from_c ( bnot ( temp_num ));
   end "not";


-- left/right shifting functions

   function lshift (num, bits : ada_int_type) return ada_int_type is
      temp_num, temp_bits : c_int_type;
   begin
      temp_num  := to_c (num);
      temp_bits := to_c (bits);
      return from_c ( blshift ( temp_num, temp_bits ));
   end lshift;


   function rshift (num, bits : ada_int_type) return ada_int_type is
      temp_num, temp_bits : c_int_type;
   begin
      temp_num  := to_c (num);
      temp_bits := to_c (bits);
      return from_c ( brshift ( temp_num, temp_bits ));
   end rshift;

end twiddle;
