
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adwiinbo.adb "adatui-win_input_box.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
function win_input_box (
   a_window  : pdcurses.A_WINDOW_T;
   num_lines : integer;
   num_cols  : integer )
   return pdcurses.A_WINDOW_T 
is
   current_y  : c.signed_int;
   current_x  : c.signed_int;
   begin_y    : c.signed_int;
   begin_x    : c.signed_int;
   start_y    : c.signed_int;
   start_x    : c.signed_int;
   winput     : pdcurses.A_WINDOW_T;
   temp_lines : c.signed_int;
   temp_cols  : c.signed_int;

begin
   pdcurses.getyx ( a_window, current_y, current_x );
   pdcurses.getbegyx ( a_window, begin_y, begin_x );

   start_y := begin_y + current_y;
   start_x := begin_x + current_x;
   
   temp_lines := c.signed_int ( num_lines );
   temp_cols  := c.signed_int ( num_cols  );
   winput := pdcurses.newwin ( temp_lines, temp_cols, start_y, start_x ); 

   color_box (  
      window => winput,
      color  => INPUTBOXCOLOR,
      hasbox => TRUE );

   return winput;
end win_input_box;

