-----------------------------------------------------------------------
--
--  File:        screen.adb
--  Description: HANGMAN screen saving
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
package body Screen is

   procedure Save (Screen : out A_Screen) is
      R    : Boolean;
      Info : Text_Info;
   begin
      Gettextinfo (Info);
      Screen.Width    := Info.Screen_Width;
      Screen.Height   := Info.Screen_Height;
      Screen.Cursor_X := Info.Curr_X;
      Screen.Cursor_Y := Info.Curr_Y;
      gettext (1, 1, Screen.Width, Screen.Height, Screen.Buffer, R);
   end Save;

   procedure Restore (Screen : in A_Screen) is
      R : Boolean;
   begin
      textmode (Last_Mode);
      Normvideo;
      setcursortype (Normal);
      R := puttext (1, 1, Screen.Width, Screen.Height, Screen.Buffer);
      Gotoxy (Screen.Cursor_X, Screen.Cursor_Y);
   end Restore;

end Screen;
