-----------------------------------------------------------------------
--
--  File:        letters.adb
--  Description: HANGMAN guessed character handling
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio;
use  Conio;

package body Letters is

   procedure Show (Set : in Letter_Set) is
   begin
      Gotoxy (11, 18);
      Textcolor (Green);
      Cputs ("Available:");
      for I in 1 .. 13 loop
         if Set (I).Used = True then
            Textcolor (Brown);
         else
            Textcolor (Yellow);
         end if;
         Gotoxy (20 + 2 * I, 18);
         Putch (Set (I).Value);
      end loop;
      for I in 14 .. 26 loop
         if Set (I).Used = True then
            Textcolor (Brown);
         else
            Textcolor (Yellow);
         end if;
         Gotoxy (20 + 2 * (I - 13), 19);
         Putch (Set (I).Value);
      end loop;
   end Show;

   function Is_Valid (Set : in Letter_Set; C : Character) return Boolean is
      Index  : Integer := Character'Pos (C) - Character'Pos ('@');
      Result : Boolean := False;
   begin
      if Index in Letter_Set'Range and then Set (Index).Used = False then
         Result := True;
      end if;
      return Result;
   end Is_Valid;

   procedure Set_Used (Set : in out Letter_Set; C : Character) is
      Index  : Integer := Character'Pos (C) - Character'Pos ('@');
   begin
      if Index in Letter_Set'Range then
         Set (Index).Used := True;
      else
         raise Program_Error;
      end if;
   end Set_Used;

end Letters;
