#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__gbiosky = "$Header: C:\CURSES\private\RCS\_gbiosky.c 2.1 1993/06/18 20:22:27 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_get_bios_key()	- Returns the next key available from the BIOS.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Returns the next key code struck at the keyboard. If the low 8
 	bits are 0, the upper bits contain the extended character
 	code. If bit 0-7 are non-zero, the upper bits = 0.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_get_bios_key( void );

**man-end**********************************************************************/

int	PDC_get_bios_key(void)
{
#ifdef	FLEXOS
unsigned ch	= 0;
#endif

#if	defined (DOS)
	int ascii,scan;
	static unsigned char keyboard_function=0xFF;
#endif

#if	defined (OS2)
	int ascii,scan;
	KBDKEYINFO keyInfo;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_bios_key() - called\n");
#endif

#ifdef	FLEXOS
	retcode = s_read(0x00, 0L, (char *) &ch, 2L, 0L);
	return( (retcode < 0L) ? ERR : ch );
#endif

#if	defined (DOS)
	if (keyboard_function == 0xFF)
		{
		regs.h.ah = 0x02;             /* get shift status for all keyboards */
		int86(0x16, &regs, &regs);
		scan = regs.h.al;
		regs.h.ah = 0x12;             /* get shift status for enhanced keyboards */
		int86(0x16, &regs, &regs);
		if (scan == regs.h.al
		&&  getdosmembyte(0x496) == 0x10)
			keyboard_function = 0x10;
		else
			keyboard_function = 0x0;
		}
	regs.h.ah = keyboard_function;
	int86(0x16, &regs, &regs);
	ascii = regs.h.al;
	scan = regs.h.ah;
#endif

#ifdef	OS2
	KbdCharIn(&keyInfo, IO_WAIT, 0);	/* get a character	*/
	ascii = keyInfo.chChar;
	scan = keyInfo.chScan;
#endif

#if	defined (DOS) || defined (OS2)
	if (scan == 0x1c && ascii == 0x0a)  /* ^Enter */
		return ((int) (0xfc00));
	if ((scan == 0x03 && ascii == 0x00)  /* ^@ - Null */
	||  (scan == 0xe0 && ascii == 0x0d)  /* PadEnter */
	||  (scan == 0xe0 && ascii == 0x0a)) /* ^PadEnter */
		return ((int) (ascii << 8));
	if ((scan == 0x37 && ascii == 0x2a)  /* Star */
	||  (scan == 0x4a && ascii == 0x2d)  /* Minus */
	||  (scan == 0x4e && ascii == 0x2b)  /* Plus */
	||  (scan == 0xe0 && ascii == 0x2f)) /* Slash */
		return ((int) ((ascii & 0x0f) | 0xf0) << 8);
	if (ascii == 0x00 || ascii == 0xe0)
		return ((int) (scan << 8));
	return ((int) (ascii));
#endif
}
