%
%  file : html.sl
%
%  Author : Raikanta Sahu, rsahu@mail.unm.edu
%  Modified by John E. Davis for incorporation into JED.
%
%  Html mode for jed
% 


%
% Start up stuff for a html file
%

define html_start()
{
   insert("<HTML>\n\n<HEAD>\n<TITLE></TITLE>\n</HEAD>\n") ;
   insert("\n<BODY>\n</BODY>\n\n</HTML>") ;
   go_up(6) ;
   go_left(8) ;
}

define html_insert_go_left (s, n)
{
   insert (s); go_left (n);
}

%
% Make title
%

define html_title ()
{
   html_insert_go_left ("<TITLE></TITLE>", 8);
}

%
% Make h1 heading
%

define html_h1 ()
{
   html_insert_go_left ("<H1></H1>", 5);
}

%
% Make h2 heading
%

define html_h2 ()
{
   html_insert_go_left ("<H2></H2>", 5);
}

%
% Make h3 heading
%

define html_h3 ()
{
   html_insert_go_left ("<H3></H3>", 5);
}

%
% Make a paragraph marker
%

define html_paragraph ()
{
   insert("<P>") ;
}

%
% Make a unordered list marker
%

define html_ul ()
{
   insert("<UL>\n\n</UL>") ;
   go_up(1) ;
}

%
% Make a ordered list marker
%

define html_ol ()
{
   insert("<OL>\n\n</OL>") ;
   go_up(1) ;
}

%
% Make a list item
%

define html_item ()
{
   insert("<LI>") ;
}

%
% Make an anchor marker
%

define html_anchor ()
{
   html_insert_go_left ("<A HREF=\"\"></A>", 6);
}

%
% Make an reference marker
%

define html_name ()
{
   html_insert_go_left ("<A NAME=\"\"></A>", 6);
}

%
% Make an address marker
%

define html_address ()
{
   html_insert_go_left ("<ADDRESS></ADDRESS>", 10);
}

%
% Make markers for preformatted text
%

define html_preformat ()
{
   insert("<PRE>\n\n</PRE>") ;
   go_up(1) ;
}

%
% Make markers for code
%

define html_code ()
{
   html_insert_go_left ("<CODE></CODE>", 7);
}

%
% Make markers for emphasis
%

define html_emphasis ()
{
   html_insert_go_left ("<EM></EM>", 5);
}

%
% Make markers for bold
%

define html_bold ()
{
   html_insert_go_left ("<B></B>", 4);
}

%
% Make markers for an image
%

define html_image ()
{
   html_insert_go_left ("<IMG SRC=\"\">", 2);
}

%
% main entry point into the html mode
% commands available to keystrokes in html mode
%

$1 = "HTML";
!if (keymap_p ($1)) make_keymap ($1);
definekey ("html_start",     "^Cs",  $1);
definekey ("html_title",     "^Ct",  $1);
definekey ("html_h1",	"^C1",  $1);
definekey ("html_h2",	"^C2",  $1);
definekey ("html_h3",	"^C3",	$1);
definekey ("html_ul",	"^Cu",  $1);
definekey ("html_ol",	"^Co",  $1);
definekey ("html_item",      "^Cl",  $1);
definekey ("html_paragraph",	"^Cp",	$1);
definekey ("html_anchor",    "^Ca",  $1);
definekey ("html_name",      "^Cn",  $1);
definekey ("html_address",   "^Cd",  $1);
definekey ("html_preformat", "^Cf",  $1);
definekey ("html_emphasis",  "^Ce",  $1);
definekey ("html_code",      "^Co",  $1);
definekey ("html_image",     "^Ci",  $1);


create_syntax_table ($1);

define_syntax ("<", ">", '(', $1);     %  make these guys blink match
define_syntax ("<>", '<', $1);
define_syntax ("<!", "->", '%', $1);
define_syntax ("A-Za-z&", 'w', $1);
() = define_keywords ($1, "&gt&lt", 3);
() = define_keywords ($1, "&ETH&amp&eth", 4);
() = define_keywords ($1, strcat (
				  "&Auml&Euml&Iuml&Ouml&Uuml",
				  "&auml&euml&iuml&nbsp&ouml&quot&uuml&yuml"
				  ), 
		      5);

() = define_keywords ($1, strcat (
  "&AElig&Acirc&Aring&Ecirc&Icirc&Ocirc&THORN&Ucirc&acirc",
  "&aelig&aring&ecirc&icirc&ocirc&szlig&thorn&ucirc"
				  ), 
		      6);

() = define_keywords ($1, strncat (
  "&Aacute&Agrave&Atilde&Ccedil&Eacute&Egrave&Iacute&Igrave",
  "&Ntilde&Oacute&Ograve&Oslash&Otilde&Uacute&Ugrave&Yacute",
  "&aacute&agrave&atilde&ccedil&eacute&egrave&iacute&igrave",
  "&ntilde&oacute&ograve&oslash&otilde&uacute&ugrave&yacute",
				   4),
		      7);

%!% Prototype: Void html_mode ();
%!% @html_mode@ is a mode designed for editing html files.  It is similar to
%!% @text_mode@ except it adds the following keybindings designed to 
%!% facilitate the entry of html files:
%!% @ Function        @Key
%!% @ html_start      ^Cs
%!% @ html_title      ^Ct
%!% @ html_h1         ^C1
%!% @ html_h2         ^C2
%!% @ html_h3         ^C3
%!% @ html_ul         ^Cu
%!% @ html_ol         ^Co
%!% @ html_item       ^Cl
%!% @ html_paragraph  ^Cp
%!% @ html_anchor     ^Ca
%!% @ html_name       ^Cn
%!% @ html_address    ^Cd
%!% @ html_preformat  ^Cf
%!% @ html_emphasis   ^Ce
%!% @ html_code       ^Co
%!% @ html_image      ^Ci
%!% This function calls @html_mode_hook@ if it exists.
define html_mode ()
{
   variable html = "HTML";
   setmode("html", 1);
   use_syntax_table (html);
   use_keymap (html);
   runhooks ("html_mode_hook");
}
