/* system-dependent definitions for fileutils programs.
   Copyright (C) 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Include sys/types.h before this file.  */

#include <sys/stat.h>
#ifndef S_ISREG			/* Doesn't have POSIX.1 stat stuff. */
#define mode_t unsigned short
#endif
#if !defined(S_ISBLK) && defined(S_IFBLK)
#define	S_ISBLK(m) (((m) & S_IFMT) == S_IFBLK)
#endif
#if !defined(S_ISCHR) && defined(S_IFCHR)
#define	S_ISCHR(m) (((m) & S_IFMT) == S_IFCHR)
#endif
#if !defined(S_ISDIR) && defined(S_IFDIR)
#define	S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)
#endif
#if !defined(S_ISREG) && defined(S_IFREG)
#define	S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif
#if !defined(S_ISFIFO) && defined(S_IFIFO)
#define	S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#endif
#if !defined(S_ISLNK) && defined(S_IFLNK)
#define	S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#endif
#if !defined(S_ISSOCK) && defined(S_IFSOCK)
#define	S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)
#endif
#if !defined(S_ISMPB) && defined(S_IFMPB) /* V7 */
#define S_ISMPB(m) (((m) & S_IFMT) == S_IFMPB)
#define S_ISMPC(m) (((m) & S_IFMT) == S_IFMPC)
#endif
#if !defined(S_ISNWK) && defined(S_IFNWK) /* HP/UX */
#define S_ISNWK(m) (((m) & S_IFMT) == S_IFNWK)
#endif

#ifdef POSIX
#include <unistd.h>
#include <limits.h>
#ifndef PATH_MAX
#define PATH_MAX pathconf ("/", _PC_PATH_MAX)
#endif
#else
#ifdef MSDOS
#include <time.h>
#else
#ifdef USG
#include <sys/times.h>
#else
#include <sys/time.h>
#endif
#endif
#endif

#ifndef MSDOS
#ifndef _POSIX_SOURCE
#include <sys/param.h>
#endif
#endif

#ifndef _POSIX_PATH_MAX
#define _POSIX_PATH_MAX 255
#endif

#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX MAXPATHLEN
#else
#define PATH_MAX _POSIX_PATH_MAX
#endif
#endif

#if defined(_POSIX_SOURCE) || defined(MSDOS)
#define major(dev)  (((dev) >> 8) & 0xff)
#define minor(dev)  ((dev) & 0xff)
#define makedev(maj, min)  (((maj) << 8) | (min))
#else
#ifdef USG
#include <sys/sysmacros.h>
#endif
#endif

#ifdef POSIX
#include <utime.h>
#else
#ifdef MSDOS
#include <sys/utime.h>
#else
struct utimbuf
{
  long actime;
  long modtime;
};
#endif /* MSDOS */
#endif

#if defined(USG) || defined(STDC_HEADERS)
#include <string.h>
#define index strchr
#define rindex strrchr
#define bcopy(from, to, len) memcpy ((to), (from), (len))
#define bzero(s, n) memset ((s), 0, (n))
#else
#include <strings.h>
#endif

#if defined(USG) || defined(POSIX)
#ifndef F_OK
/* Args for access. */
#define F_OK 0
#define X_OK 1
#define W_OK 2
#define R_OK 4

char *getcwd ();
#endif
#define getwd(buf) getcwd ((buf), PATH_MAX + 2)

/* Args for lseek. */
#define L_SET 0
#define L_INCR 1
#define L_XTND 2
#else
#include <sys/file.h>

char *getwd ();
#endif

#include <fcntl.h>

#ifdef DIRENT
#include <dirent.h>
#ifdef direct
#undef direct
#endif
#define direct dirent
#define NLENGTH(direct) (strlen((direct)->d_name))
#else
#define NLENGTH(direct) ((direct)->d_namlen)
#ifdef MSDOS
#include <sys/dir.h>
#else
#ifdef USG
#ifdef SYSNDIR
#include <sys/ndir.h>
#else
#include <ndir.h>
#endif
#else /* must be BSD */
#include <sys/dir.h>
#endif
#endif
#endif

/* Extract or fake data from a `struct stat'.
   ST_BLKSIZE: Optimal I/O blocksize for the file, in bytes.
   ST_NBLOCKS: Number of 512-byte blocks in the file
   (including indirect blocks). */
#ifdef MSDOS
#define DEV_BSIZE  512
#define ST_BLKSIZE(statbuf) 0x4000
#define ST_NBLOCKS(statbuf) (((statbuf).st_size + DEV_BSIZE - 1) / DEV_BSIZE)
#else
#ifdef _POSIX_SOURCE
#define ST_BLKSIZE(statbuf) 512
#define ST_NBLOCKS(statbuf) (((statbuf).st_size + 512 - 1) / 512)
#else
#ifdef ST_BLOCKS_MISSING
#define ST_BLKSIZE(statbuf) BSIZE
#define ST_NBLOCKS(statbuf) (st_blocks ((statbuf).st_size))
#else
/* Some systems, like Sequents, return st_blksize of 0 on pipes. */
#define ST_BLKSIZE(statbuf) ((statbuf).st_blksize > 0 \
			     ? (statbuf).st_blksize : DEV_BSIZE)
#if defined(hpux) || defined(__hpux__)
/* HP-UX, perhaps uniquely, counts st_blocks in 1024-byte units.
   This loses when mixing HP-UX and 4BSD filesystems, though. */
#define ST_NBLOCKS(statbuf) ((statbuf).st_blocks * 2)
#else
#define ST_NBLOCKS(statbuf) ((statbuf).st_blocks)
#endif
#endif
#endif
#endif

/* Convert B 512-byte blocks to kilobytes if K is nonzero,
   otherwise return it unchanged. */
#define convert_blocks(b, k) ((k) ? ((b) + 1) / 2 : (b))

#ifndef S_ISLNK
#define lstat stat
#endif

#ifndef SIGTYPE
#define SIGTYPE void
#endif

#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#ifdef sparc
#include <alloca.h>
#else
#ifdef _AIX
#pragma alloca
#else
#ifdef MSDOS
#include <malloc.h>
#else
char *alloca ();
#endif
#endif
#endif
#endif
