NAME
     rm - remove files

SYNOPSIS
     rm [-dfirvR] [+directory] [+force] [+interactive] [+recur-
     sive] [+verbose] path...

DESCRIPTION
     This manual page documents the GNU version of rm.  rm
     removes each given file.  By default, it does not remove
     directories.  If a file is unwritable, the standard input is
     a tty, and the -f or +force option is not given, rm prompts
     the user for whether to remove the file.  If the response
     does not begin with `y' or `Y', the file is skipped.

     GNU rm, like every program that uses the getopt function to
     parse its arguments, lets you use the -- option to indicate
     that all following arguments are non-options.  To remove a
     file called `-f' in the current directory, you could type
     either
          rm -- -f
     or
          rm ./-f
     The Unix rm program's use of a single `-' for this purpose
     predates the development of the getopt standard syntax.

     OPTIONS

     -d, +directory
          Remove directories with `unlink' instead of `rmdir',
          and don't require a directory to be empty before trying
          to unlink it.  Only works for the super-user.

     -f, +force
          Ignore nonexistent files and never prompt the user.

     -i, +interactive
          Prompt whether to remove each file.  If the response
          does not begin with `y' or `Y', the file is skipped.

     -r, -R, +recursive
          Remove the contents of directories recursively.

     -v, +verbose
          Print the name of each file before removing it.
