1 REM D. R. HICKS -- RCH38DB(HICKS) -- 456-5999
10 REM This is the skeleton of a program for searching a DOS library directory
20 REM to find a particular external name and locate the OBJ module that
30 REM defines it.  It could, for instance, be extended to extract the OBJ
40 REM module containing the external name.
50 REM
60 REM Note that BASIC must be invoked with the /S:512 option.
70 REM
80 INPUT "Enter library name: ", FILENAME$
90 OPEN FILENAME$ AS #1 LEN=512
100 FIELD #1, 4 AS DUMMY1$, 2 AS DIRADDR$, 1 AS DUMMY2$, 2 AS MAJCLASS$
110 GET #1, 1
120 DIRADDR = CVI(DIRADDR$)/2 + 1
130 MAJCLASS = CVI(MAJCLASS$)
140 PRINT "Directory sector address is " DIRADDR
150 PRINT "Number of major hash classes is " MAJCLASS
160 PRINT "Input name"
170 INPUT A$
180 NEWA$ = STRING$(LEN(A$)+1,LEN(A$) OR 32)
190 FOR I = 1 TO LEN(A$)
200   MID$(NEWA$,I+1, 1) = CHR$(ASC(MID$(A$,I,1)) OR 32)
210 NEXT I
220 BUCKET1A = 0
230 BUCKET1B = 0
240 BUCKET2A = 0
250 BUCKET2B = 0
260 BUCKET3A = 0
270 BUCKET3B = 0
280 BUCKET4A = 0
290 BUCKET4B = 0
300 FOR I = 1 TO LEN(A$)
310   WORK1 = BUCKET1A
320   WORK2 = BUCKET1B
330   GOSUB 1110 'left rotate 2
340   BUCKET1A = WORK1
350   BUCKET1B = WORK2 XOR ASC(MID$(NEWA$,I,1))
360   WORK1 = BUCKET2A
370   WORK2 = BUCKET2B
380   GOSUB 1110 'left rotate 2
390   BUCKET2A = WORK1
400   BUCKET2B = WORK2 XOR ASC(MID$(NEWA$,LEN(A$)+2-I,1))
410   WORK1 = BUCKET3A
420   WORK2 = BUCKET3B
430   GOSUB 1210 'right rotate 2
440   BUCKET3A = WORK1
450   BUCKET3B = WORK2 XOR ASC(MID$(NEWA$,I,1))
460   WORK1 = BUCKET4A
470   WORK2 = BUCKET4B
480   GOSUB 1210 'right rotate 2
490   BUCKET4A = WORK1
500   BUCKET4B = WORK2 XOR ASC(MID$(NEWA$,LEN(A$)+2-I,1))
510 NEXT I
520 PRINT "1 " HEX$(BUCKET1A) " " HEX$(BUCKET1B)
530 PRINT "2 " HEX$(BUCKET2A) " " HEX$(BUCKET2B)
540 PRINT "3 " HEX$(BUCKET3A) " " HEX$(BUCKET3B)
550 PRINT "4 " HEX$(BUCKET4A) " " HEX$(BUCKET4B)
560 WORK1 = BUCKET1A
570 WORK2 = BUCKET1B
580 WORK3 = MAJCLASS
590 GOSUB 1310 'divide & return remainder in work1
600 HASH1 = WORK1
610 WORK1 = BUCKET2A
620 WORK2 = BUCKET2B
630 WORK3 = MAJCLASS
640 GOSUB 1310 'divide & return remainder in work1
650 HASH2 = WORK1
660 IF HASH2 = 0 THEN HASH2 = 1
670 WORK1 = BUCKET3A
680 WORK2 = BUCKET3B
690 WORK3 = 37
700 GOSUB 1310 'divide & return remainder in work1
710 HASH3 = WORK1
720 IF HASH3 = 0 THEN HASH3 = 1
730 WORK1 = BUCKET4A
740 WORK2 = BUCKET4B
750 WORK3 = 37
760 GOSUB 1310 'integer divide & return remainder in work1
770 HASH4 = WORK1
780 PRINT "Major hash (1) " HASH1
790 PRINT "Minor hash (4) " HASH4
800 PRINT "Major adder (2) " HASH2
810 PRINT "Minor adder (3) " HASH3
820 PRINT ""
830 PRINT "Major hash (1) " HASH1
840 GET #1, DIRADDR+HASH1
850 FIELD #1, 38 AS TABLE$
860 FOR I = 1 TO 37
870 PRINT "Minor hash (4) " HASH4
880 POINTER = ASC(MID$(TABLE$,HASH4+1,1))
890 PRINT "Hash table entry is " POINTER
900 IF POINTER <> 0 THEN GOTO 940
910   IF ASC(MID$(TABLE$,38,1)) = 255 THEN GOTO 1040 'Sector overflow
920   PRINT "Name " A$ " not found"
930   STOP
940 FIELD #1, POINTER AS DUMMY3$, POINTER AS DUMMY4$, 1 AS NAMLEN$
950 PRINT "Name length is " ASC(NAMLEN$)
960 FIELD #1, POINTER AS DUMMY3$, POINTER AS DUMMY4$, 1 AS NAMLEN$, ASC(NAMLEN$) AS NAM$, 2 AS OBJSECT$
970 PRINT "Name is " NAM$
980 PRINT "Object sector is " CVI(OBJSECT$)
990 IF NAM$ = A$ THEN GOTO 1070
1000 'no match
1010 HASH4 = HASH4 + HASH3
1020 HASH4 = HASH4 MOD 37
1030 NEXT I
1040 HASH1 = HASH1 + HASH2
1050 HASH1 = HASH1 MOD MAJCLASS
1060 GOTO 830
1070 'match
1080 PRINT "Match!!  Object sector is " CVI(OBJSECT$)
1090 GET #1, CVI(OBJSECT$)
1100 STOP
1110 'rotate left 2
1120   W1 = WORK1*4
1130   W2 = W1\256
1140   W3 = W1 MOD 256
1150   W4 = WORK2*4
1160   W5 = W4\256
1170   W6 = W4 MOD 256
1180   WORK1 = W3 + W5
1190   WORK2 = W6 + W2
1200 RETURN
1210 'rotate right 2
1220   W1 = WORK1*64
1230   W2 = W1\256
1240   W3 = W1 MOD 256
1250   W4 = WORK2*64
1260   W5 = W4\256
1270   W6 = W4 MOD 256
1280   WORK1 = W2 + W6
1290   WORK2 = W3 + W5
1300 RETURN
1310 'integer divide work1 cat work2 by work3 & return remainder in work1
1320   W1# = WORK1
1330   W2# = WORK2
1340   W3# = (W1# * 256#) + W2#
1350   W4# = WORK3
1360   W5# = W3# / W4#
1370   W6# = INT(W5#)
1380   W7# = W6# * W4#
1390   W8# = W3# - W7#
1400   WORK1 = INT(W8#)
1410 RETURN
