	REM  GENERAL INVENTORY PROGRAM
	REM  WRITTEN BY DON TARBELL
	REM  LAST CHANGE MADE 4-23-78
	REM
	REM  EACH ENTRY IN THE INVENTORY CONSISTS OF THE QUANTITY
	REM  OF ITEMS, THE VALUE OF THE ITEM, THE PART NUMBER, A
	REM  A SHORT DESCRIPTION OF THE ITEM, AND A POINTER.
	REM  UNITS ARE INVENTORY ITEMS WHICH CONSIST OF A PACKAGE
	REM  OF OTHER PARTS IN THE INVENTORY.  THE PACKAGE COMMAND
	REM  AUTOMATICALLY SUBTRACTS ITEMS FROM THESE PARTS, AND
	REM  ADDS TO THE NUMBER OF A PARTICULAR UNIT.
	REM  BE SURE THAT ALL ITEMS THAT MAKE UP A PARTICULAR UNIT
	REM  ARE ENTERED INTO THE INVENTORY BEFORE THAT UNIT IS ENTERED.
	REM
	REM  UNIT(J,2)	LIST OF PARTS PER UNIT.
	REM		AN ARRAY NCPA LONG, 2 WIDE,
	REM		WITH QUANTITY THE FIRST ELEMENT,
	REM		AND POINTER TO AN ITEM 2ND ELEMENT.
	REM  PARTS	NUMBER OF ITEMS NOW IN UNIT LIST.
	REM
	REM  Q(I)	QUANTITY OF AN ITEM I IN INVENTORY.
	REM  C(I)	COST OF AN ITEM I IN INVENTORY.
	REM  P$(I)	PART NO. OF AN ITEM I IN INVENTORY.
	REM  D$(I)	DESCRIPTION OF AN ITEM I IN INVENTORY.
	REM  PTR(I)	POINTER TO SUBSIDIARY ITEMS OF A UNIT.
	REM		IS = 0 FOR ITEMS BOUGHT OUTSIDE.
	REM		IS LOCATION IN UNIT LIST FOR UNITS.
	REM  S		SIZE OF INVENTORY (NUMBER OF ITEMS).
	REM  W$,CMD$	TEMPORARY STRING VARIABLES.
	REM  E,I,J,K	TEMPORARY INDEX VARIABLES.
	REM  EC		EXTENDED COST (COST TIMES QTY).
	REM  COST,SUM,M	TEMPORARY SUMMING VARIABLES.
	REM  STACK	ARRAY FOR SAVING VARIABLES IN RECURSIVE
	REM		SUBROUTINE CALLS.
	REM  SP		POINTS TO NEXT LOCATION IN STACK.
	REM  NOP	NO. OF PACKAGES ENTERED.
	REM
	REM  CONSTANTS:
	ZERO = 0	REM  TAKES LESS SPACE & RUNS FASTER.
	ONE = 1
	TWO = 2
	L = 100		REM  MAXIMUM NUMBER OF INVENTORY ITEMS.
	NCPA = 100	REM  MAX NUMBER OF COMPONENT PARTS.
	DIM PTR(L), UNIT(NCPA,2), Q(L), C(L), P$(L), D$(L)
	DIM STACK(30)	REM  ALLOW TEN LEVELS.
	SP = ONE	REM  SET STACK POINTER.
	S = ZERO	REM  SET INITIAL INVENTORY SIZE.
	PARTS = ZERO	REM  SET INITIAL UNITS ARRAY SIZE.
40	INPUT "WANT A LIST OF COMMANDS";W$
	IF W$="NO" THEN 100
	PRINT "SAVE     SAVE THE INVENTORY ON DISK"
	PRINT "LOAD     LOAD THE INVENTORY FROM DISK"
	PRINT "LIST     LIST THE ENTIRE INVENTORY"
	PRINT "FIND     FIND ONE ITEM"
	PRINT "NEW      PUT A NEW ITEM IN"
	PRINT "CHANGE   CHANGE AN ITEM"
	PRINT "ADD      ADD A QUANTITY OF AN ITEM"
	PRINT "SUB      SUBTRACT A QUANTITY OF AN ITEM"
	PRINT "PACKAGE  SUBTRACT OR ADD (-) AFTER PACKAGING"
	PRINT "VALUE    CALCULATE THE VALUE OF THE INVENTORY"
	PRINT "UNIT     LIST ITEMS OF A UNIT"
	PRINT "BUY      LIST ITEMS TO BUY FOR N UNITS"
	PRINT "DONE     DONE WITH ALL ENTRIES"
	PRINT "YOU CAN USE JUST THE FIRST 3 LETTERS."
100	PRINT
	INPUT "COMMAND";CMD$
	W$=LEFT$(CMD$,3)
	IF W$="LIS" THEN 1000
	IF W$="FIN" THEN 1500
	IF W$="NEW" THEN 2000
	IF W$="CHA" THEN 3000
	IF W$="ADD" THEN 4000
	IF W$="PAC" THEN 5000
	IF W$="UNI" THEN 6000
	IF W$="BUY" THEN 7000
	IF W$="VAL" THEN 8000
	IF W$="SUB" THEN 9000
	IF W$="SAV" THEN 10000
	IF W$="LOA" THEN 11000
	IF W$="DON" THEN 18000
	GOTO 40
1000	REM  LIST ALL ITEMS IN THE INVENTORY
	COST = ZERO
	GOSUB 12000:REM  PRINT HEADING.
	FOR I=ONE TO S
	GOSUB 13000:REM  PRINT ONE LINE ITEM.
	COST = COST + EC
	NEXT I
	GOSUB 22000
	GOTO 100
1500	REM  FIND ONE INVENTORY ITEM
	GOSUB 15000	REM  READ PART NO., GET I.
	GOSUB 16000	REM  PRINT HEADING & ENTRY.
	GOTO 100
2000	REM  ENTER A NEW ITEM INTO INVENTORY
	S=S+ONE
	E=S
2010	INPUT "QUANTITY NOW IN STOCK";Q(E)
	INPUT "PART NUMBER";P$(E)
	INPUT "DESCRIPTION";D$(E)
	INPUT "IS THIS A UNIT MADE OF OTHER PARTS";W$
	IF W$ = "YES" THEN 2020
	INPUT "COST OF ITEM";C(E)
	PTR(E) = ZERO
	GOTO 2050
2020	REM  ENTER LIST OF PARTS THAT MAKE A UNIT.
	PRINT "ENTER THE PARTS. MAKE QTY 0 AFTER LAST ONE."
	PARTS = PARTS + ONE
	PTR(E) = PARTS
2030	INPUT "QTY";UNIT(PARTS,ONE)
	IF UNIT(PARTS,ONE) = ZERO THEN UNIT(PARTS,TWO) = E: GOTO 2050
	GOSUB 15000	REM  ENTER PART NUMBER, RETURN WITH I.
2040	UNIT(PARTS,TWO) = I
	PARTS = PARTS + ONE
	GOTO 2030
2050	PRINT FRE;" BYTES LEFT."
	GOTO 100
3000	REM  CHANGE ITEM
	GOSUB 15000:REM INPUT PART NUMBER, RETURN WITH LINE NO. I
	IF I>S THEN 100
	GOSUB 16000:REM  PRINT HEADING AND LINE ITEM
	INPUT "JUST CHANGE QTY";W$
	IF W$="NO" THEN E=I:GOTO 2010
	INPUT "NEW QUANTITY";Q(I)
	GOSUB 13000:REM PRINT ONE LINE ITEM.
	GOTO 100
4000	REM  ADD TO STOCK
	GOSUB 15000:REM INPUT PART NUMBER, GET LINE NO.
	IF I>S THEN 100
	GOSUB 16000:REM  PRINT HEADING AND LINE ITEM.
	INPUT "ADD HOW MANY";J
	Q(I)=Q(I)+J
	GOSUB 13000:REM  PRINT ONE LINE ITEM.
	GOTO 100
5000	REM  PACKAGE UNITS
	GOSUB 15000	REM  GET PART NUMBER, ENTRY NO.
	IF I>S THEN 100
	IF PTR(I) = ZERO THEN 21000
	INPUT "NUMBER PACKAGED";NOP
	IF NOP=ZERO THEN 100
	FOR J = PTR(I) TO PARTS
	    IF UNIT(J,ONE) = ZERO THEN 5010
	    Q(UNIT(J,2)) = Q(UNIT(J,2)) - NOP*UNIT(J,ONE)
	NEXT J
5010	Q(I) = Q(I) + NOP
	GOTO 100
6000	REM  LIST THE ITEMS THAT MAKE UP A UNIT.
	COST = ZERO
	GOSUB 15000	REM  READ PART NUMBER, FIND I.
	IF I>S THEN 100
	PRINT "PARTS FOR ";D$(I);":"
	GOSUB 12000	REM  PRINT COLUMN HEADINGS.
	FOR K = PTR(I) TO PARTS
	    IF UNIT(K,ONE) = ZERO THEN 6010
	    I = UNIT(K,TWO)	REM  GET ITEM NUMBER.
	    PRINT UNIT(K,ONE);TAB(8);P$(I);TAB(19);D$(I);
	    GOSUB 17000		REM  COST OF ITEM I = M.
	    PRINT TAB(40);M;
	    EC = UNIT(K,ONE)*M
	    PRINT TAB(49);EC	REM  EXTENDED COST.
	    COST = COST + EC
	NEXT K
6010	GOSUB 22000
	GOTO 100
7000	REM  LIST THE ITEMS TO BUY FOR N UNITS.
	GOSUB 15000	REM  READ PART NUMBER, GET I.
	IF I>S THEN 100		REM  PART NO. BAD?
	IF PTR(I) = ZERO THEN 21000	REM  POSSIBLE?
	GOSUB 16000	REM  PRINT HEADING & ENTRY.
	INPUT "HOW MANY DO YOU WANT TO BE ABLE TO MAKE";NOP
	PRINT "ITEMS REQUIRED FOR";NOP;D$(I);":"
	GOSUB 12000	REM  PRINT COLUMN HEADINGS.
	COST = ZERO	REM  KEEP A RUNNING TOTAL.
	GOSUB 7100	REM  PRINT ITEMS.
	GOSUB 22000	REM  PRINT TOTAL COST.
	GOTO 100	REM  QUIT.
7100	REM  LIST ITEMS REQUIRED FOR NOP UNITS OF ITEM I.
	GOSUB 19000		REM  SAVE I,J,SUM.
	SUM = NOP	REM  NEW NUMBER REQUIRED.
	FOR J = PTR(I) TO PARTS	REM  GO THRU UNIT LIST.
	    I = UNIT(J,TWO)	REM GET ITEM NUMBER.
	    IF UNIT(J,ONE) = ZERO THEN 7120	REM LAST ITEM?
	    NOP = SUM*UNIT(J,ONE) - Q(I)    REM  NO. REQUIRED.
	    IF NOP <= ZERO THEN 7110	REM  NONE REQUIRED.
	    IF PTR(I) = ZERO THEN COST = COST + NOP*C(I)
	    IF PTR(I) = ZERO THEN \
		PRINT NOP;TAB(8);P$(I);TAB(19);D$(I); \
		      TAB(40);C(I);TAB(49);NOP*C(I) \
		ELSE GOSUB 7100		REM  CALL THIS ROUTINE.
7110	NEXT J
7120	GOSUB 20000		REM  RESTORE I,J,SUM.
	RETURN
8000	REM  PRINT THE COST OF THE INVENTORY.
	COST = ZERO
	FOR I = ONE TO S
	    GOSUB 17000		REM  M IS COST OF ITEM I.
	    COST = COST + M*Q(I)
	NEXT I
	PRINT "TOTAL COST = $";COST
	GOTO 100
9000	REM  SUBTRACT A QUANTITY FROM AN ENTRY.
	GOSUB 15000	REM  READ PART NO., GET I.
	IF I>S THEN 100
	GOSUB 16000	REM  PRINT HEADING & LINE ITEM.
	INPUT "SUBTRACT HOW MANY";J
	Q(I) = Q(I) - J
	GOSUB 13000	REM  PRINT THE UPDATED LINE.
	GOTO 100
10000	REM  SAVE INVENTORY ON DISK.
	INPUT "FILENAME";FILENAME$
	FILE FILENAME$
	PRINT #ONE;S
	FOR I = ONE TO S
	    PRINT #ONE;Q(I),P$(I),D$(I),C(I),PTR(I)
	NEXT I
	PRINT #ONE;PARTS
	FOR I = ONE TO PARTS
	    PRINT #ONE;UNIT(I,ONE),UNIT(I,TWO)
	NEXT I
	CLOSE ONE
	GOTO 100
11000	REM  LOAD INVENTORY FROM DISK.
	INPUT "FILENAME";FILENAME$
	FILE FILENAME$
	READ #ONE;S	REM  READ SIZE.
	FOR I = ONE TO S
	    READ #ONE;Q(I),P$(I),D$(I),C(I),PTR(I)
	NEXT I
	READ #ONE;PARTS
	FOR I = ONE TO PARTS
	    READ #ONE;UNIT(I,ONE),UNIT(I,TWO)
	NEXT I
	CLOSE ONE
	GOTO 100
12000	REM  PRINT THE HEADING.
	PRINT
	PRINT "QTY";TAB(8);"PART NO.";TAB(19);"DESCRIPTION";
	PRINT TAB(40);"COST";TAB(49);"EXT COST"
	PRINT
	RETURN
13000	REM  PRINT ONE LINE ITEM.
	PRINT Q(I);TAB(8);P$(I);TAB(19);D$(I);
	GOSUB 17000	REM  M IS COST OF ITEM I.
	PRINT TAB(40);M;
	EC = Q(I)*M
	PRINT TAB(49);EC	REM  PRINT EXTENDED COST.
	RETURN
15000	REM  INPUT PART NO., RETURN WITH ENTRY NUMBER I.
	INPUT "PART NUMBER";W$
	FOR I=ONE TO S
	IF P$(I)=W$ THEN RETURN
	NEXT I
	PRINT "ITEM NOT FOUND"
	RETURN
16000	REM  PRINT HEADING, THEN ENTRY.
	GOSUB 12000
	GOSUB 13000
	RETURN
17000	REM  FIND THE COST (M) OF AN ITEM (I).
	SUM = ZERO
	IF PTR(I) = ZERO THEN M = C(I): RETURN
	FOR J = PTR(I) TO PARTS
	    IF UNIT(J,ONE) = ZERO THEN 17010
	    GOSUB 19000		REM  SAVE I,J,SUM.
	    I = UNIT(J,TWO)
	    GOSUB 17000		REM  CALL THIS ROUTINE.
	    GOSUB 20000		REM  RESTORE I,J,SUM.
	    SUM = SUM + UNIT(J,ONE)*M
	NEXT J
17010	M = SUM		REM  PASS ARGUMENT.
	RETURN
18000	REM  DONE WITH PROGRAM, QUIT.
	STOP
19000	REM  SAVE I, J, AND SUM ON STACK.
	STACK(SP) = I
	SP = SP + ONE
	STACK(SP) = J
	SP = SP + ONE
	STACK(SP) = SUM
	SP = SP + ONE
	RETURN
20000	REM  RESTORE I, J, AND SUM FROM STACK.
	SP = SP - ONE
	SUM = STACK(SP)
	SP = SP - ONE
	J = STACK(SP)
	SP = SP - ONE
	I = STACK(SP)
	RETURN
21000	REM  SITUATIONS THAT ARE NOT POSSILBE COME HERE.
	PRINT "NOT POSSIBLE."
	GOTO 100
22000	REM  PRINT TOTAL COST.
	PRINT
	PRINT TAB(19);"TOTAL COST:";TAB(49);"$";COST
	PRINT
	RETURN
	END
