*#######################################################################
*               Program FONT...Create Scientific Font
*
*                       Dr. David C. Wilcox
*                       DCW Industries, Inc.
*               5354 Palm Drive, La Canada, CA  91011
*                          818/790-3844
*
*                         March 21, 1986
*#######################################################################
boot	equ	00		*warm boot
list	equ	05		*send character to printer
pstring	equ	09		*send string to console
bell	equ	07		*ascii bel
lf	equ	10		*line feed
ff	equ	12		*form feed
cr	equ	13		*carriage return
esc	equ	27		*ascii escape
space	equ	32		*ascii space
bdos	equ	$0002		*bdos entry point
*#######################################################################
*
* Locate FCB (for portability)
*
	link	a6,#0		*mark stack frame
	move.l	8(a6),a0	*get base page address
	lea	$5c(a0),a6	*get address of FCB and save it in a6
*
* Send scientific font definition to printer
*
	movea.l	#scifont,a1
	jsr	lpsend
*
* Send "font-loaded" message to console
*
	move.l	#fontmsg,d1
	move.w	#pstring,d0
	trap	#bdos
*
* Check for sample <P>rint requested
*
	cmpi.b	#'P',1(a6)
	bne	quit
*
* Do a sample print
*
	movea.l	#line1,a1		*first line...regular font
	jsr	lpsend
	jsr	crlf
	movea.l	#sfont,a1
	jsr	lpsend
	movea.l	#line1,a1		*first line...new font
	jsr	lpsend
	movea.l	#efont,a1
	jsr	lpsend
	jsr	crlf
	jsr	crlf
*
	movea.l	#line2,a1		*second line...regular font
	jsr	lpsend
	jsr	crlf
	movea.l	#sfont,a1
	jsr	lpsend
	movea.l	#line2,a1		*second line...new font
	jsr	lpsend
	movea.l	#efont,a1
	jsr	lpsend
	jsr	crlf
	jsr	crlf
*
	movea.l	#line3,a1		*third line...regular font
	jsr	lpsend
	jsr	crlf
	movea.l	#sfont,a1
	jsr	lpsend
	movea.l	#line3,a1		*third line...new font
	jsr	lpsend
	movea.l	#efont,a1
	jsr	lpsend
	jsr	crlf
	jsr	crlf
*
	movea.l	#line4,a1		*fourth line...regular font
	jsr	lpsend
	jsr	crlf
	movea.l	#sfont,a1
	jsr	lpsend
	movea.l	#line4,a1		*fourth line...new font
	jsr	lpsend
	movea.l	#efont,a1
	jsr	lpsend
*
	move.w	#ff,d1		*page eject
	move.w	#list,d0
	trap	#bdos
*
* Return to CP/M
*
quit:
	movea.l	#draft,a1		*return to draft mode
	jsr	lpsend
	move.w	#boot,d0		*and return to CP/M
	trap	#bdos
*
* Send string terminated by lf to printer
*
lpsend:	move.b	(a1)+,d1	*keep looping until a lf is found
	cmpi.b	#lf,d1		*(lf is safe...it's been avoided
	bne	sendit		*in defining the font)
	rts			*return when it's found
sendit:	move.w	#list,d0
	trap	#bdos
	bra	lpsend
*
* Send a carriage return/line feed pair to printer
*
crlf:	move.w	#cr,d1
	move.w	#list,d0
	trap	#bdos
	move.w	#lf,d1
	move.w	#list,d0
	trap	#bdos
	rts
*#######################################################################
*              Sample print strings and console message
*#######################################################################
draft:	dc.b	esc,'x',0,lf
efont:	dc.b	esc,'%',0,lf
sfont:	dc.b	esc,'%',1,lf
line1:	dc.b	'1234567890-=   !@#$%^&*()_+   ~\|',lf
line2:	dc.b	'qwertyuiop{}   QWERTYUIOP[]',lf
line3:	dc.b	'asdfghjkl;',39,'    ASDFGHJKL:"',lf
line4:	dc.b	'zxcvbnm,./     ZXCVBNM<>?',lf
fontmsg:dc.b	cr,lf,'SCIENTIFIC font now loaded...'
	dc.b	'LETTER QUALITY mode',cr,lf,'$'
*#######################################################################
*      Epson LQ-1500...Letter quality mode font definition
*#######################################################################
scifont:
* Select letter quality mode
lq:	dc.b	esc,'x',1
* Copy ROM characters to RAM
romram:	dc.b	esc,':',0,0,0
* Redefine characters from " to $
init1:	dc.b	esc,'&',0,'"$'
* Define " = therefore symbol
thrfor:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,64,       0,0,0
	dc.b	0,0,224,     0,0,0,       0,0,224,      0,0,0
	dc.b	0,0,64,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       4,0,0,        0,0,0
	dc.b	14,0,0,      0,0,0,       14,0,0,       0,0,0
	dc.b	4,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,64,       0,0,0
	dc.b	0,0,224,     0,0,0,       0,0,224,      0,0,0
	dc.b	0,0,64,      0,0,0,       0,0,0,        0,0,0
* Define # = twiddle
twid:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,1,128,     0,0,0,       0,7,128,      0,0,0
	dc.b	0,14,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,16,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,14,0,      0,0,0,       0,7,0,        0,0,0
	dc.b	0,1,128,     0,0,0,       0,0,128,      0,0,0
	dc.b	0,1,128,     0,0,0,       0,7,0,        0,0,0
	dc.b	0,30,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define $ = large integral
lint:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,14,       0,0,0
	dc.b	0,0,31,      0,0,0,       0,0,15,       0,0,0
	dc.b	0,0,1,       0,0,0,       0,0,7,        0,0,0
	dc.b	0,0,31,      0,0,0,       7,255,254,    0,0,0
	dc.b	31,255,248,  0,0,0,       127,255,224,  0,0,0
	dc.b	248,0,0,     0,0,0,       224,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       240,0,0,      0,0,0
	dc.b	248,0,0,     0,0,0,       112,0,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from & to '
init2:	dc.b	esc,'&',0,'&',39
* Define & = dagger
dagger:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       4,0,0,        0,0,0
	dc.b	4,0,0,       0,0,0,       4,0,0,        0,0,0
	dc.b	255,254,0,   0,0,0,       255,248,0,    0,0,0
	dc.b	4,0,0,       0,0,0,       4,0,0,        0,0,0
	dc.b	4,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define ' = prime symbol
prime:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	63,224,0,    0,0,0,       63,192,0,     0,0,0
	dc.b	63,128,0,    0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from , to ,
init3:	dc.b	esc,'&',0,',,'
* Define , = dot
dot:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,60,0,      0,0,0,       0,126,0,      0,0,0
	dc.b	0,126,0,     0,0,0,       0,126,0,      0,0,0
	dc.b	0,126,0,     0,0,0,       0,60,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from : to ;
init4:	dc.b	esc,'&',0,':;'
* Define : = summation sigma
sumsig:	dc.b	0,36,0
	dc.b	192,0,3,     0,0,0,       224,0,7,      0,0,0
	dc.b	240,0,15,    0,0,0,       248,0,31,     0,0,0
	dc.b	220,0,59,    0,0,0,       206,0,115,    0,0,0
	dc.b	199,0,227,   0,0,0,       195,129,195,  0,0,0
	dc.b	193,195,131, 0,0,0,       192,231,3,    0,0,0
	dc.b	192,126,3,   0,0,0,       192,60,3,     0,0,0
	dc.b	192,24,3,    0,0,0,       192,0,3,      0,0,0
	dc.b	192,0,3,     0,0,0,       192,0,3,      0,0,0
	dc.b	240,0,15,    0,0,0,       240,0,15,     0,0,0
* Define ; = product pi
prodpi:	dc.b	0,36,0
	dc.b	192,0,0,     0,0,0,       192,0,1,      0,0,0
	dc.b	192,0,1,     0,0,0,       255,255,255,  0,0,0
	dc.b	255,255,255, 0,0,0,       192,0,1,      0,0,0
	dc.b	192,0,1,     0,0,0,       192,0,0,      0,0,0
	dc.b	192,0,0,     0,0,0,       192,0,1,      0,0,0
	dc.b	192,0,1,     0,0,0,       255,255,255,  0,0,0
	dc.b	255,255,255, 0,0,0,       192,0,1,      0,0,0
	dc.b	192,0,1,     0,0,0,       192,0,0,      0,0,0
	dc.b	240,0,0,     0,0,0,       240,0,0,      0,0,0
* Redefine characters from ? to Z
init5:	dc.b	esc,'&',0,'?Z'
* Define ? = division sign
divide:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,16,0,       0,0,0
	dc.b	0,16,0,      0,0,0,       0,16,0,       0,0,0
	dc.b	0,16,0,      0,0,0,       2,16,128,     0,0,0
	dc.b	7,17,192,    0,0,0,       7,17,192,     0,0,0
	dc.b	2,16,128,    0,0,0,       0,16,0,       0,0,0
	dc.b	0,16,0,      0,0,0,       0,16,0,       0,0,0
	dc.b	0,16,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define @ = copyright symbol
cpyrt:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	1,252,0,     0,0,0,       6,3,0,        0,0,0
	dc.b	12,1,128,    0,0,0,       24,0,192,     0,0,0
	dc.b	16,248,64,   0,0,0,       33,4,32,      0,0,0
	dc.b	34,2,32,     0,0,0,       34,2,32,      0,0,0
	dc.b	34,2,32,     0,0,0,       33,4,32,      0,0,0
	dc.b	16,136,64,   0,0,0,       24,0,192,     0,0,0
	dc.b	12,1,128,    0,0,0,       6,3,0,        0,0,0
	dc.b	1,252,0,     0,0,0,       0,0,0,        0,0,0
* Define A = subscript infinity
snfin:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,1,224,     0,0,0,       0,3,48,       0,0,0
	dc.b	0,6,24,      0,0,0,       0,4,8,        0,0,0
	dc.b	0,6,24,      0,0,0,       0,3,48,       0,0,0
	dc.b	0,1,224,     0,0,0,       0,1,224,      0,0,0
	dc.b	0,3,48,      0,0,0,       0,6,24,       0,0,0
	dc.b	0,4,8,       0,0,0,       0,6,24,       0,0,0
	dc.b	0,3,48,      0,0,0,       0,1,224,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define B = infinity
infin:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,60,0,      0,0,0,       0,102,0,      0,0,0
	dc.b	0,195,0,     0,0,0,       0,129,0,      0,0,0
	dc.b	0,195,0,     0,0,0,       0,102,0,      0,0,0
	dc.b	0,60,0,      0,0,0,       0,60,0,       0,0,0
	dc.b	0,102,0,     0,0,0,       0,195,0,      0,0,0
	dc.b	0,129,0,     0,0,0,       0,195,0,      0,0,0
	dc.b	0,102,0,     0,0,0,       0,60,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define C = upper case psi
upsi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       4,0,0,        0,0,0
	dc.b	7,240,0,     0,0,0,       7,248,0,      0,0,0
	dc.b	4,12,0,      0,0,0,       0,6,0,        0,0,0
	dc.b	32,2,32,     0,0,0,       32,2,32,      0,0,0
	dc.b	63,255,224,  0,0,0,       63,255,224,   0,0,0
	dc.b	32,2,32,     0,0,0,       32,2,32,      0,0,0
	dc.b	0,6,0,       0,0,0,       4,12,0,       0,0,0
	dc.b	7,248,0,     0,0,0,       7,240,0,      0,0,0
	dc.b	4,0,0,       0,0,0,       0,0,0,        0,0,0
* Define D = curly d (partial derivative operator)
curlyd:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	32,0,0,      0,0,0,       32,0,0,       0,0,0
	dc.b	48,15,128,   0,0,0,       16,31,192,    0,0,0
	dc.b	24,48,96,    0,0,0,       8,96,32,      0,0,0
	dc.b	12,64,32,    0,0,0,       6,64,32,      0,0,0
	dc.b	3,64,32,     0,0,0,       1,192,32,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,96,192,     0,0,0
	dc.b	0,63,128,    0,0,0,       0,31,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define E = large left bracket
lbrack:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	255,255,255, 0,0,0,       255,255,255,  0,0,0
	dc.b	255,255,255, 0,0,0,       192,0,3,      0,0,0
	dc.b	192,0,3,     0,0,0,       192,0,3,      0,0,0
	dc.b	192,0,3,     0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define F = upper case phi
uphi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,248,0,      0,0,0
	dc.b	1,252,0,     0,0,0,       3,6,0,        0,0,0
	dc.b	2,2,0,       0,0,0,       6,3,0,        0,0,0
	dc.b	36,1,32,     0,0,0,       36,1,32,      0,0,0
	dc.b	63,255,224,  0,0,0,       63,255,224,   0,0,0
	dc.b	36,1,32,     0,0,0,       36,1,32,      0,0,0
	dc.b	6,3,0,       0,0,0,       2,2,0,        0,0,0
	dc.b	3,6,0,       0,0,0,       1,252,0,      0,0,0
	dc.b	0,248,0,     0,0,0,       0,0,0,        0,0,0
* Define G = upper case gamma
ugamma:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	63,255,224,  0,0,0,       63,255,224,   0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	63,0,0,      0,0,0,       63,0,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define H = proportionality symbol
propor:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,28,0,       0,0,0
	dc.b	0,62,0,      0,0,0,       0,99,0,       0,0,0
	dc.b	0,193,128,   0,0,0,       0,193,128,    0,0,0
	dc.b	0,193,128,   0,0,0,       0,193,128,    0,0,0
	dc.b	0,99,0,      0,0,0,       0,54,0,       0,0,0
	dc.b	0,28,0,      0,0,0,       0,54,0,       0,0,0
	dc.b	0,99,0,      0,0,0,       0,193,128,    0,0,0
	dc.b	0,193,128,   0,0,0,       0,193,128,    0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define I = small integral
sint:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,28,      0,0,0,       0,0,62,       0,0,0
	dc.b	0,0,27,      0,0,0,       0,0,1,        0,0,0
	dc.b	0,0,3,       0,0,0,       63,255,254,   0,0,0
	dc.b	127,255,252, 0,0,0,       192,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       216,0,0,      0,0,0
	dc.b	124,0,0,     0,0,0,       56,0,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define J = upper case theta
utheta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	3,254,0,     0,0,0,       7,255,0,      0,0,0
	dc.b	12,1,128,    0,0,0,       24,0,192,     0,0,0
	dc.b	48,112,64,   0,0,0,       48,32,96,     0,0,0
	dc.b	32,32,32,    0,0,0,       32,32,32,     0,0,0
	dc.b	48,32,96,    0,0,0,       48,112,64,    0,0,0
	dc.b	24,0,192,    0,0,0,       12,1,128,     0,0,0
	dc.b	7,255,0,     0,0,0,       3,254,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define K = right arrow
rarow:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,24,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,24,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,24,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,153,0,     0,0,0,       0,153,0,      0,0,0
	dc.b	0,90,0,      0,0,0,       0,90,0,       0,0,0
	dc.b	0,60,0,      0,0,0,       0,60,0,       0,0,0
	dc.b	0,24,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define L = upper case lambda
ulamda:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,32,      0,0,0,       0,0,32,       0,0,0
	dc.b	0,1,224,     0,0,0,       0,14,32,      0,0,0
	dc.b	0,112,32,    0,0,0,       3,128,0,      0,0,0
	dc.b	12,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	12,0,0,      0,0,0,       3,128,0,      0,0,0
	dc.b	0,112,32,    0,0,0,       0,14,32,      0,0,0
	dc.b	0,1,224,     0,0,0,       0,0,32,       0,0,0
	dc.b	0,0,32,      0,0,0,       0,0,0,        0,0,0
* Define M = script l
lmix:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,32,      0,0,0,       15,240,96,    0,0,0
	dc.b	24,12,192,   0,0,0,       48,7,128,     0,0,0
	dc.b	48,3,0,      0,0,0,       24,15,128,    0,0,0
	dc.b	15,252,192,  0,0,0,       0,0,96,       0,0,0
	dc.b	0,0,32,      0,0,0,       0,0,192,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define N = large right bracket
rbrack:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       192,0,3,      0,0,0
	dc.b	192,0,3,     0,0,0,       192,0,3,      0,0,0
	dc.b	192,0,3,     0,0,0,       255,255,255,  0,0,0
	dc.b	255,255,255, 0,0,0,       255,255,255,  0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define O = cross product
cross:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	1,0,64,      0,0,0,       0,128,128,    0,0,0
	dc.b	0,65,0,      0,0,0,       0,34,0,       0,0,0
	dc.b	0,20,0,      0,0,0,       0,8,0,        0,0,0
	dc.b	0,20,0,      0,0,0,       0,34,0,       0,0,0
	dc.b	0,65,0,      0,0,0,       0,128,128,    0,0,0
	dc.b	1,0,64,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define P = upper case pi
upi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,32,      0,0,0
	dc.b	48,0,32,     0,0,0,       63,255,224,   0,0,0
	dc.b	48,0,32,     0,0,0,       48,0,32,      0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,32,     0,0,0,       63,255,224,   0,0,0
	dc.b	48,0,32,     0,0,0,       48,0,32,      0,0,0
	dc.b	48,0,32,     0,0,0,       62,0,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define Q = upper case delta
udelta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,96,       0,0,0
	dc.b	0,1,224,     0,0,0,       0,6,96,       0,0,0
	dc.b	0,24,96,     0,0,0,       0,96,96,      0,0,0
	dc.b	1,128,96,    0,0,0,       6,0,96,       0,0,0
	dc.b	24,0,96,     0,0,0,       24,0,96,      0,0,0
	dc.b	6,0,96,      0,0,0,       1,128,96,     0,0,0
	dc.b	0,96,96,     0,0,0,       0,24,96,      0,0,0
	dc.b	0,6,96,      0,0,0,       0,1,224,      0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,0,        0,0,0
* Define R = square root
root:	dc.b	0,36,0
	dc.b	0,0,112,     0,0,0,       0,1,192,      0,0,0
	dc.b	0,7,0,       0,0,0,       0,1,192,      0,0,0
	dc.b	0,0,112,     0,0,0,       0,0,28,       0,0,0
	dc.b	0,0,7,       0,0,0,       0,0,28,       0,0,0
	dc.b	0,0,112,     0,0,0,       0,1,192,      0,0,0
	dc.b	0,7,0,       0,0,0,       0,28,0,       0,0,0
	dc.b	0,112,0,     0,0,0,       1,192,0,      0,0,0
	dc.b	7,0,0,       0,0,0,       28,0,0,       0,0,0
	dc.b	112,0,0,     0,0,0,       192,0,0,      0,0,0
* Define S = upper case sigma
usigma:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	48,0,96,     0,0,0,       56,0,224,     0,0,0
	dc.b	60,1,224,    0,0,0,       54,3,96,      0,0,0
	dc.b	51,6,96,     0,0,0,       49,140,96,    0,0,0
	dc.b	48,216,96,   0,0,0,       48,112,96,    0,0,0
	dc.b	48,32,96,    0,0,0,       48,0,96,      0,0,0
	dc.b	48,0,96,     0,0,0,       48,0,96,      0,0,0
	dc.b	60,1,224,    0,0,0,       60,1,224,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define T = overbar
over:	dc.b	0,36,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
	dc.b	128,0,0,     0,0,0,       128,0,0,      0,0,0
* Define U = upper case upsilon
uupsi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	6,0,0,       0,0,0,       14,0,0,       0,0,0
	dc.b	24,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,32,     0,0,0,       24,0,32,      0,0,0
	dc.b	15,255,224,  0,0,0,       15,255,224,   0,0,0
	dc.b	24,0,32,     0,0,0,       48,0,32,      0,0,0
	dc.b	48,0,0,      0,0,0,       24,0,0,       0,0,0
	dc.b	14,0,0,      0,0,0,       6,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define V = approximately equal with a dot
eqdot:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,33,0,       0,0,0
	dc.b	0,33,0,      0,0,0,       0,33,0,       0,0,0
	dc.b	0,33,0,      0,0,0,       8,33,0,       0,0,0
	dc.b	28,33,0,     0,0,0,       28,33,0,      0,0,0
	dc.b	8,33,0,      0,0,0,       0,33,0,       0,0,0
	dc.b	0,33,0,      0,0,0,       0,33,0,       0,0,0
	dc.b	0,33,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define W = upper case omega
uomega:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       3,248,96,     0,0,0
	dc.b	7,252,96,    0,0,0,       12,6,96,      0,0,0
	dc.b	24,3,96,     0,0,0,       16,1,224,     0,0,0
	dc.b	48,0,224,    0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,0,       0,0,0
	dc.b	48,0,0,      0,0,0,       48,0,224,     0,0,0
	dc.b	16,1,224,    0,0,0,       24,3,96,      0,0,0
	dc.b	12,6,96,     0,0,0,       7,252,96,     0,0,0
	dc.b	3,248,96,    0,0,0,       0,0,0,        0,0,0
* Define X = upper case xi
uexi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	62,3,224,    0,0,0,       48,0,96,      0,0,0
	dc.b	48,0,96,     0,0,0,       48,248,96,    0,0,0
	dc.b	48,32,96,    0,0,0,       48,32,96,     0,0,0
	dc.b	48,32,96,    0,0,0,       48,32,96,     0,0,0
	dc.b	48,32,96,    0,0,0,       48,32,96,     0,0,0
	dc.b	48,248,96,   0,0,0,       48,0,96,      0,0,0
	dc.b	48,0,96,     0,0,0,       62,3,224,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define Y = identically equal
eqidnt:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       4,33,0,       0,0,0
	dc.b	4,33,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define Z = subscript tau
stau:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,48,0,      0,0,0,       0,48,0,       0,0,0
	dc.b	0,48,0,      0,0,0,       0,63,224,     0,0,0
	dc.b	0,63,240,    0,0,0,       0,48,24,      0,0,0
	dc.b	0,48,8,      0,0,0,       0,48,24,      0,0,0
	dc.b	0,48,48,     0,0,0,       0,56,0,       0,0,0
	dc.b	0,24,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from \ to \
init6:	dc.b	esc,'&',0,'\\'
* Define \ = vertical bar
vert:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	255,255,255, 0,0,0,       255,255,255,  0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from a to c
init7:	dc.b	esc,'&',0,'ac'
* Define a = lower case alpha
lalpha:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,31,0,       0,0,0
	dc.b	0,63,128,    0,0,0,       0,96,192,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,96,192,    0,0,0,       0,49,128,     0,0,0
	dc.b	0,31,0,      0,0,0,       0,63,128,     0,0,0
	dc.b	0,96,192,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define b = lower case beta
lbeta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,63,248,    0,0,0,       3,255,248,    0,0,0
	dc.b	15,224,64,   0,0,0,       28,64,32,     0,0,0
	dc.b	48,64,32,    0,0,0,       32,64,32,     0,0,0
	dc.b	32,224,96,   0,0,0,       49,176,192,   0,0,0
	dc.b	31,31,128,   0,0,0,       14,15,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define c = lower case psi
lpsi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	6,0,0,       0,0,0,       6,0,0,        0,0,0
	dc.b	3,248,0,     0,0,0,       1,252,0,      0,0,0
	dc.b	0,6,0,       0,0,0,       0,6,0,        0,0,0
	dc.b	63,255,224,  0,0,0,       63,255,224,   0,0,0
	dc.b	0,6,0,       0,0,0,       0,6,0,        0,0,0
	dc.b	0,6,0,       0,0,0,       0,12,0,       0,0,0
	dc.b	7,252,0,     0,0,0,       7,240,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from e to z
init8:	dc.b	esc,'&',0,'ez'
* Define e = lower case epsilon
leps:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,14,0,       0,0,0
	dc.b	0,63,128,    0,0,0,       0,117,192,    0,0,0
	dc.b	0,100,192,   0,0,0,       0,196,96,     0,0,0
	dc.b	0,196,96,    0,0,0,       0,196,96,     0,0,0
	dc.b	0,196,96,    0,0,0,       0,196,96,     0,0,0
	dc.b	0,196,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define f = lower case phi
lphi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,248,0,      0,0,0
	dc.b	1,252,0,     0,0,0,       3,6,0,        0,0,0
	dc.b	6,3,0,       0,0,0,       6,3,0,        0,0,0
	dc.b	63,255,224,  0,0,0,       63,255,224,   0,0,0
	dc.b	6,3,0,       0,0,0,       6,3,0,        0,0,0
	dc.b	3,6,0,       0,0,0,       1,252,0,      0,0,0
	dc.b	0,248,0,     0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define g = lower case gamma
lgamma:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       3,0,0,        0,0,0
	dc.b	6,0,0,       0,0,0,       6,0,0,        0,0,0
	dc.b	6,0,0,       0,0,0,       3,0,224,      0,0,0
	dc.b	1,135,224,   0,0,0,       0,255,0,      0,0,0
	dc.b	0,120,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	1,128,0,     0,0,0,       3,0,0,        0,0,0
	dc.b	2,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define h = lower case eta
leta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,192,0,      0,0,0
	dc.b	1,192,0,     0,0,0,       0,127,224,    0,0,0
	dc.b	0,63,224,    0,0,0,       0,24,0,       0,0,0
	dc.b	0,48,0,      0,0,0,       0,96,0,       0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,127,252,   0,0,0,       0,63,252,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define i = lower case iota
liota:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,255,192,    0,0,0
	dc.b	0,255,224,   0,0,0,       0,0,96,       0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,192,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define j = lower case theta
ltheta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       3,254,0,      0,0,0
	dc.b	15,255,128,  0,0,0,       28,33,192,    0,0,0
	dc.b	48,32,96,    0,0,0,       32,32,32,     0,0,0
	dc.b	48,32,96,    0,0,0,       28,33,192,    0,0,0
	dc.b	15,255,128,  0,0,0,       3,254,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define k = lower case kappa
lkappa:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	1,255,224,   0,0,0,       1,255,224,    0,0,0
	dc.b	0,12,0,      0,0,0,       0,30,0,       0,0,0
	dc.b	0,51,0,      0,0,0,       0,97,128,     0,0,0
	dc.b	0,192,192,   0,0,0,       1,128,96,     0,0,0
	dc.b	1,128,96,    0,0,0,       1,128,96,     0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define l = lower case lambda
llamda:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       12,0,224,     0,0,0
	dc.b	12,1,224,    0,0,0,       12,3,0,       0,0,0
	dc.b	12,6,0,      0,0,0,       6,12,0,       0,0,0
	dc.b	3,48,0,      0,0,0,       1,176,0,      0,0,0
	dc.b	0,224,0,     0,0,0,       0,48,0,       0,0,0
	dc.b	0,31,192,    0,0,0,       0,7,224,      0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define m = lower case mu
lmu:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,255,254,   0,0,0,       0,255,254,    0,0,0
	dc.b	0,1,128,     0,0,0,       0,0,192,      0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,96,       0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,192,      0,0,0
	dc.b	0,0,128,     0,0,0,       0,255,192,    0,0,0
	dc.b	0,255,96,    0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define n = lower case nu
lnu:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,128,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,96,0,       0,0,0
	dc.b	0,48,0,      0,0,0,       0,24,0,       0,0,0
	dc.b	0,15,224,    0,0,0,       0,7,224,      0,0,0
	dc.b	0,0,64,      0,0,0,       0,0,192,      0,0,0
	dc.b	0,1,128,     0,0,0,       0,255,0,      0,0,0
	dc.b	0,254,0,     0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define o = lower case omicron
lomi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,31,0,      0,0,0,       0,63,128,     0,0,0
	dc.b	0,96,192,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,96,192,     0,0,0
	dc.b	0,63,128,    0,0,0,       0,31,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define p = lower case pi
lpi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,255,224,    0,0,0
	dc.b	0,255,224,   0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,255,224,   0,0,0,       0,255,224,    0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,240,0,     0,0,0,       0,240,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define q = lower case delta
ldelta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,7,128,     0,0,0,       14,15,192,    0,0,0
	dc.b	31,24,96,    0,0,0,       49,176,96,    0,0,0
	dc.b	48,224,96,   0,0,0,       48,96,96,     0,0,0
	dc.b	48,48,96,    0,0,0,       48,24,192,    0,0,0
	dc.b	28,15,128,   0,0,0,       12,7,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define r = lower case rho
lrho:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,31,254,     0,0,0
	dc.b	0,63,254,    0,0,0,       0,97,128,     0,0,0
	dc.b	0,192,192,   0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,96,192,    0,0,0,       0,63,128,     0,0,0
	dc.b	0,31,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define s = lower case sigma
lsigma:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,31,128,    0,0,0,       0,63,192,     0,0,0
	dc.b	0,96,96,     0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,224,192,   0,0,0,       0,255,128,    0,0,0
	dc.b	0,223,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define t = lower case tau
ltau:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,255,128,    0,0,0
	dc.b	0,255,192,   0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,32,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,192,   0,0,0,       0,192,128,    0,0,0
	dc.b	0,224,0,     0,0,0,       0,96,0,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define u = lower case upsilon
lupsi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,128,0,      0,0,0
	dc.b	0,192,0,     0,0,0,       0,126,0,      0,0,0
	dc.b	0,63,128,    0,0,0,       0,1,192,      0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,32,       0,0,0
	dc.b	0,0,96,      0,0,0,       0,128,192,    0,0,0
	dc.b	0,193,128,   0,0,0,       0,127,0,      0,0,0
	dc.b	0,62,0,      0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define v = gradient operator
lgrad:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       48,0,0,       0,0,0
	dc.b	60,0,0,      0,0,0,       51,0,0,       0,0,0
	dc.b	48,192,0,    0,0,0,       48,48,0,      0,0,0
	dc.b	48,12,0,     0,0,0,       48,3,0,       0,0,0
	dc.b	48,0,192,    0,0,0,       48,0,192,     0,0,0
	dc.b	48,3,0,      0,0,0,       48,12,0,      0,0,0
	dc.b	48,48,0,     0,0,0,       48,192,0,     0,0,0
	dc.b	51,0,0,      0,0,0,       60,0,0,       0,0,0
	dc.b	48,0,0,      0,0,0,       0,0,0,        0,0,0
* Define w = lower case omega
lomega:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,31,0,       0,0,0
	dc.b	0,63,128,    0,0,0,       0,96,192,     0,0,0
	dc.b	0,192,96,    0,0,0,       0,128,96,     0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,96,       0,0,0
	dc.b	0,7,192,     0,0,0,       0,7,192,      0,0,0
	dc.b	0,0,96,      0,0,0,       0,0,96,       0,0,0
	dc.b	0,128,96,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,96,192,    0,0,0,       0,63,128,     0,0,0
	dc.b	0,31,0,      0,0,0,       0,0,0,        0,0,0
* Define x = lower case xi
lexi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       1,142,0,      0,0,0
	dc.b	27,223,0,    0,0,0,       46,113,128,   0,0,0
	dc.b	12,32,192,   0,0,0,       12,32,72,     0,0,0
	dc.b	12,32,72,    0,0,0,       0,0,48,       0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define y = lower case chi
lchi:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,192,0,      0,0,0
	dc.b	0,192,32,    0,0,0,       0,192,96,     0,0,0
	dc.b	0,192,192,   0,0,0,       0,97,128,     0,0,0
	dc.b	0,54,0,      0,0,0,       0,31,0,       0,0,0
	dc.b	0,31,128,    0,0,0,       0,48,192,     0,0,0
	dc.b	0,96,96,     0,0,0,       0,192,32,     0,0,0
	dc.b	0,128,0,     0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Define z = lower case zeta
lzeta:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       24,0,0,       0,0,0
	dc.b	60,0,0,      0,0,0,       44,120,0,     0,0,0
	dc.b	12,252,24,   0,0,0,       12,134,56,    0,0,0
	dc.b	15,3,96,     0,0,0,       14,1,192,     0,0,0
	dc.b	12,0,128,    0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* Redefine characters from | to |
init9:	dc.b	esc,'&',0,'||'
* Define | = absolute value
labs:	dc.b	0,36,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	63,255,224,  0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
	dc.b	0,0,0,       0,0,0,       0,0,0,        0,0,0
* End of redefinition tables
stop:	dc.b	bell,lf
*#######################################################################
	end
