                PAGE    58,132
                TITLE   CRTROM
                .LFCOND
;*********************************************************************
;*
;*      CRTROM  V3.0
;*
;*
;*
;*********************************************************************
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      CONSTANT
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;       SYSTEM ADDRESS
;
CRT_DATA_SEGMENT        EQU     0
TEXT_VRAM_SEGMENT       EQU     0A000H
ATTRIBUTE_OFFSET        EQU     2000H
GRAPH_VRAM_SEGMENT      EQU     0A800H
PLANE1_SEGMENT          EQU     0A800H
PLANE2_SEGMENT          EQU     0B000H
PLANE3_SEGMENT          EQU     0B800H
CMOS_SWITCH_OFFSET      EQU     0AH
CMOS_SWITCH_SEGMENT     EQU     0A3FEH
;
;       SYSTEM PORT
;
SYS_PORT_B              EQU     33H
SYS_PORT_C              EQU     37H
;
CRT_FF                  EQU     68H
BORDER_COLOR_PORT       EQU     6CH
CRT_SELECT_PORT    	EQU     6EH
DISPLAY_BANK       	EQU     0A4H
ACCESS_BANK        	EQU     0A6H
PALETTE_REG01      	EQU     0AEH
PALETTE_REG23      	EQU     0ACH
PALETTE_REG45      	EQU     0AAH
PALETTE_REG67      	EQU     0A8H
;
;       CRT M/S
;
CRT_MS_PL               EQU     70H
CRT_MS_BL               EQU     72H
CRT_MS_CL               EQU     74H
CRT_MS_SSL              EQU     76H
CRT_MS_SUR              EQU     78H
CRT_MS_SDR              EQU     7AH
;
;       CRT MODE F/F
;
ATRSEL_VLINE            EQU     0
COLWIDTH_40             EQU     5
COLWIDTH_80             EQU     4
FONTSEL_80              EQU     6
FONTSEL_88              EQU     7
GRAPH_88CRT200          EQU     9
GRAPH_OTHER             EQU     8
;
;       GDC COMMAND & PARAMETER
;
TEXT_GDC_COM            EQU     62H
TEXT_GDC_PAR            EQU     60H
GRAPH_GDC_COM           EQU     0A2H
GRAPH_GDC_PAR           EQU     0A0H
;
SYNC                    EQU     0FH
SYNC_STOP		EQU	0EH
START                   EQU     0DH
STOP                    EQU     0CH
ZOOM			EQU	46H
SCROLL                  EQU     70H
CSRFORM                 EQU     4BH
LPEN                    EQU     0C0H
VECTW                   EQU     4CH
VECTE                   EQU     6CH
TEXTW                   EQU     78H
TEXTE                   EQU     68H
CSRW                    EQU     49H
MASKC                   EQU     4AH
WRITE                   EQU     20H
CLEAR_MOD               EQU     02H
;
;       ATTRIBUTE CODE
;
WHITE_ATTR              EQU     0E0H
GREEN_ATTR              EQU     080H
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      DATA AREA
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
INCLUDE         B:SYSCOM.LIB
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      CODE AREA
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
ROM             SEGMENT PUBLIC
                ASSUME  CS:ROM,DS:SYSCOM,ES:SYSCOM
;
;
		EXTRN	CLS:NEAR	; GRAPHROM MODULE
		EXTRN	LINE:NEAR	;
		EXTRN	BOX:NEAR	;
		EXTRN	BOX_FILL:NEAR	;
		EXTRN	CIRCLE:NEAR	;
		EXTRN	FONT_80:BYTE	; 8*8 FONT TABLE
		EXTRN	FONT_88:BYTE	; 8*16 FONT TABLE
                PUBLIC  CRT_IO          ; CRT INTERRUPT ENTRY
;
;
;
;*********************************************************************
;*
;*      CRT-ROM ROUTINE MAIN ENTRY
;*
;*********************************************************************
;
DISPATCH_TABLE  LABEL   WORD
                                                        ; ALPHA MODE
                DW      OFFSET  SET_MODE                ; 0
                DW      OFFSET  SET_CURSOR_TYPE
                DW      OFFSET  SET_CURSOR
                DW      OFFSET  GET_CURSOR
                DW      OFFSET  GET_LPEN
                DW      OFFSET  SET_DISPLAY_PAGE_TEXT   ; 5
                DW      OFFSET  SCROLL_UP_TEXT
                DW      OFFSET  SCROLL_DOWN_TEXT
                DW      OFFSET  READ_AC_TEXT
                DW      OFFSET  WRITE_AC_TEXT
                DW      OFFSET  WRITE_C_TEXT            ; 10
                DW      OFFSET  SET_PALETTE
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  WRITE_TTY
                DW      OFFSET  GET_MODE                ; 15
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 20
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 25
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 30
                DW      OFFSET  NOTHING_MEAN
                                                        ; 200 GRAPH MODE
                DW      OFFSET  SET_MODE                ; 0
                DW      OFFSET  SET_CURSOR_TYPE
                DW      OFFSET  SET_CURSOR
                DW      OFFSET  GET_CURSOR
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  SET_DISPLAY_PAGE_GR     ; 5
                DW      OFFSET  SCROLL_UP_GR200
                DW      OFFSET  SCROLL_DOWN_GR200
                DW      OFFSET  READ_AC_GR200
                DW      OFFSET  WRITE_AC_GR200
                DW      OFFSET  WRITE_AC_GR200          ; 10
                DW      OFFSET  SET_PALETTE
                DW      OFFSET  WRITE_DOT
                DW      OFFSET  READ_DOT
                DW      OFFSET  WRITE_TTY
                DW      OFFSET  GET_MODE                ; 15
                DW      OFFSET  SET_DRAW_MODE
                DW      OFFSET  SET_DRAW_PAGE
                DW      OFFSET  CLS
                DW      OFFSET  LINE
                DW      OFFSET  BOX			; 20
                DW      OFFSET  BOX_FILL
                DW      OFFSET  CIRCLE
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 25
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 30
                DW      OFFSET  NOTHING_MEAN
                                                        ; 400 GRAPH MODE
                DW      OFFSET  SET_MODE                ; 0
                DW      OFFSET  SET_CURSOR_TYPE
                DW      OFFSET  SET_CURSOR
                DW      OFFSET  GET_CURSOR
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  SET_DISPLAY_PAGE_GR     ; 5
                DW      OFFSET  SCROLL_UP_GR400
                DW      OFFSET  SCROLL_DOWN_GR400
                DW      OFFSET  READ_AC_GR400
                DW      OFFSET  WRITE_AC_GR400
                DW      OFFSET  WRITE_AC_GR400          ; 10
                DW      OFFSET  SET_PALETTE
                DW      OFFSET  WRITE_DOT
                DW      OFFSET  READ_DOT
                DW      OFFSET  WRITE_TTY
                DW      OFFSET  GET_MODE                ; 15
                DW      OFFSET  SET_DRAW_MODE
                DW      OFFSET  SET_DRAW_PAGE
                DW      OFFSET  CLS
                DW      OFFSET  LINE
                DW      OFFSET  BOX			; 20
                DW      OFFSET  BOX_FILL
                DW      OFFSET  CIRCLE
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 25
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN
                DW      OFFSET  NOTHING_MEAN            ; 30
                DW      OFFSET  NOTHING_MEAN
;
CRT_IO          PROC    FAR
                STI
                PUSH    DS
                PUSH    ES
                CMP     AH,32
                JNC     CRT_IO1
                PUSH    AX
                SHL     AH,1
                XOR     AL,AL
                XCHG    AH,AL
                MOV     BP,AX
                MOV     AX,CRT_DATA_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                ADD     BP,CRT_ENTRY
                POP     AX
                CALL    WORD PTR DISPATCH_TABLE[BP]
CRT_IO1:
                POP     ES
                POP     DS
                IRET
CRT_IO          ENDP
;
NOTHING_MEAN    PROC
                RET
NOTHING_MEAN    ENDP
;
;*********************************************************************
;*
;*      CNV_VRAM_TEXT
;*
;*              CALCULATE TEXT VRAM ADDRESS
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   DH = ROW
;*
;*                   DL = COLUMN
;*
;*              OUT: DX = OFFSET ON TEXT VRAM    (SEGMENT = 0A000H)
;*
;*              DESTROY: AX,SI
;*
;*********************************************************************
;
CNV_VRAM_TEXT   PROC
                MOV     SI,0                    ; SET PAGE 0
                OR      BH,BH
                JZ      CNV_VRAM_TEXT1
		CMP	CRT_MODE,4		; CHECK GRAPH MODE
		JNC	CNV_VRAM_TEXT1
                MOV     SI,1000H                ; SET PAGE 1
CNV_VRAM_TEXT1:
                XOR     AL,AL
                MOV     AH,DH
                SHR     AX,1
                ADD     SI,AX                   ; ADD ROW*128
                SHR     AX,1
                SHR     AX,1
                ADD     AX,SI                   ; ADD ROW*32
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     CNV_VRAM_TEXT2
                SHL     DL,1                    ; COLUMN*2
CNV_VRAM_TEXT2:
                SHL     DL,1                    ; GET NUMBER OF BYTE
                XOR     DH,DH
                ADD     DX,AX
                RET
CNV_VRAM_TEXT   ENDP
;
;*********************************************************************
;*
;*      CNV_VRAM_GRAPH
;*
;*              CALCULATE GRAPH VRAM ADDRESS
;*
;*
;*              IN:  CX = X COORDINATES
;*
;*                   DX = Y COORDINATES
;*
;*              OUT: DI = OFFSET ON GRAPH VRAM PLANE
;*
;*                   CX = DOT ADDRESS
;*
;*              DESTROY: DX
;*
;*********************************************************************
;
CNV_VRAM_GRAPH  PROC
                CMP     CRT_MODE,6
                JNC     CNV_VRAM_GRAPH1
                SHL     CX,1
CNV_VRAM_GRAPH1:
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                MOV     DI,DX
                SHL     DX,1
                SHL     DX,1
                ADD     DI,DX                   ; DI = Y * 80
                MOV     DX,CX
                SHR     DX,1
                SHR     DX,1
                SHR     DX,1
                ADD     DI,DX                   ; DI = (Y*80) + (X/8)
                AND     CX,7
                RET
CNV_VRAM_GRAPH  ENDP
;
;*********************************************************************
;*
;*	GDC_COMPLETE
;*
;*		WAIT UNTIL COMPLETE GDC-DRAWING
;*
;*
;*		IN:  NOTHING
;*
;*		OUT: NOTHING
;*
;*		DESTROY: AL
;*
;*********************************************************************
;
GDC_COMPLETE	PROC
GC1:
		IN	AL,GRAPH_GDC_PAR	; CHECK FIFO NOT FULL
		TEST	AL,2
		JNZ	GC1
		MOV	AL,ZOOM
		OUT	GRAPH_GDC_COM,AL	; SEND DUMMY COMMAND
		NOP
		NOP
		NOP
		NOP
GC2:
		IN	AL,GRAPH_GDC_PAR	; CHECK FIFO EMPTY
		TEST	AL,4
		JZ	GC2
		RET
GDC_COMPLETE	ENDP
;
;*********************************************************************
;*
;*      READ_G_CHAR200
;*
;*              READ GRAPHIC CHARACTER  (200 MODE)
;*
;*
;*              IN:  DH = ROW
;*
;*                   DL = COLUMN
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,CX,DX,SI,DI
;*
;*********************************************************************
;
READ_G_CHAR200  PROC
                PUSH    DS
		CALL	GDC_COMPLETE
                CMP     CRT_MODE,6              ; CHECK 320 MODE
                JNC     RGC2002
                SHL     DL,1
RGC2002:
                MOV     AH,DH
                XOR     AL,AL
                SHR     AX,1
                MOV     SI,AX                   ; SI = ROW*128
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*512
                ADD     SI,AX                   ; SI = ROW*640
                XOR     DH,DH
                ADD     SI,DX                   ; SI= (ROW*640) + COLUMN
                MOV     DI,OFFSET CHAR_BUF
                MOV     CX,8
                CMP     CRT_MODE,7
                JNZ     RGC2006
RGC20071:                                       ; MODE 7
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI],AL
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI+8],AL
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI+16],AL
                INC     DI
                ADD     SI,80
                LOOP    RGC20071
                POP     DS
                RET
RGC2006:
                CMP     CRT_MODE,6
                JNZ     RGC2005
                                                ; MODE 6
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                CLD
RGC20061:
                MOVSB
                ADD     SI,80-1
                LOOP    RGC20061
                POP     DS
                RET
RGC2005:
                CMP     CRT_MODE,5
                JNZ     RGC2004
                                                ; MODE 5
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                CLD
RGC20051:
                MOVSW
                ADD     SI,80-2
                LOOP    RGC20051
                POP     DS
                RET
RGC2004:
RGC20041:                                       ; MODE 4
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     AX,DS:[SI]
                MOV     ES:[DI],AX
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     AX,DS:[SI]
                MOV     ES:[DI+16],AX
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     AX,DS:[SI]
                MOV     ES:[DI+32],AX
                INC     DI
                INC     DI
                ADD     SI,80
                LOOP    RGC20041
                POP     DS
                RET
READ_G_CHAR200  ENDP
;
;*********************************************************************
;*
;*      READ_G_CHAR400
;*
;*              READ GRAPHIC CHARACTER  (400 MODE)
;*
;*
;*              IN:  DH = ROW
;*
;*                   DL = COLUMN
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,CX,DX,SI,DI
;*
;*********************************************************************
;
READ_G_CHAR400  PROC
                PUSH    DS
		CALL	GDC_COMPLETE
                MOV     AH,DH
                XOR     AL,AL
                MOV     SI,AX                   ; SI = ROW*256
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*1024
                ADD     SI,AX                   ; SI = ROW*1280
                XOR     DH,DH
                ADD     SI,DX                   ; SI = (ROW*1280) + COLUMN
                MOV     DI,OFFSET CHAR_BUF
                MOV     CX,16
                CMP     CRT_MODE,9
                JNZ     RGC4008
RGC40091:                                       ; MODE 9
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI],AL
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI+16],AL
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[SI]
                MOV     ES:[DI+32],AL
                INC     DI
                ADD     SI,80
                LOOP    RGC40091
                POP     DS
                RET
RGC4008:
                                                ; MODE 8
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                CLD
RGC40081:
                MOVSB
                ADD     SI,80-1
                LOOP    RGC40081
                POP     DS
                RET
READ_G_CHAR400  ENDP
;
;*********************************************************************
;*
;*      WRITE_G_CHAR200
;*
;*              WRITE GRAPHIC CHARACTER (200 MODE)
;*
;*
;*              IN:  DH = ROW
;*
;*                   DL = COLUMN
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI
;*
;*********************************************************************
;
;
;       MODIFY WRITE ROUTINE
;               ES:[DI] <-- AX(AL)
;
BYTE_MOD_WRITE  LABEL   WORD
                DW      OFFSET  WGC_WB00
                DW      OFFSET  WGC_WB01
                DW      OFFSET  WGC_WB02
                DW      OFFSET  WGC_WB03
WORD_MOD_WRITE  LABEL   WORD
                DW      OFFSET  WGC_WW00
                DW      OFFSET  WGC_WW01
                DW      OFFSET  WGC_WW02
                DW      OFFSET  WGC_WW03
;
WGC_WB00:
                MOV     ES:[DI],AL              ; REPLACE
                RET
;
WGC_WB01:
                XOR     ES:[DI],AL              ; COMPLEMENT
                RET
;
WGC_WB02:
                NOT     AL                      ; CLEAR
                AND     ES:[DI],AL
                RET
;
WGC_WB03:
                OR      ES:[DI],AL              ; SET
                RET
;
WGC_WW00:
                MOV     ES:[DI],AX              ; REPLACE
                RET
;
WGC_WW01:
                XOR     ES:[DI],AX              ; COMPLEMENT
                RET
;
WGC_WW02:
                NOT     AX                      ; CLEAR
                AND     ES:[DI],AX
                RET
;
WGC_WW03:
                OR      ES:[DI],AX              ; SET
                RET
;
WRITE_G_CHAR200 PROC
                PUSH    ES
                MOV     AL,DOT_MODIFY_MODE
                SHL     AL,1
                XOR     AH,AH
                MOV     BX,AX
		CALL	GDC_COMPLETE
                CMP     CRT_MODE,6              ; CHECK 320 MODE
                JNC     WGC2002
                SHL     DL,1
WGC2002:
                MOV     AH,DH
                XOR     AL,AL
                SHR     AX,1
                MOV     DI,AX                   ; DI = ROW*128
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*512
                ADD     DI,AX                   ; DI = ROW*640
                XOR     DH,DH
                ADD     DI,DX                   ; DI = (ROW*640) + COLUMN
                MOV     SI,OFFSET CHAR_BUF
                MOV     CX,8
                CMP     CRT_MODE,7
                JNZ     WGC2006
WGC20071:                                       ; MODE 7
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI]
                CALL    BYTE_MOD_WRITE[BX]
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI+8]
                CALL    BYTE_MOD_WRITE[BX]
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI+16]
                CALL    BYTE_MOD_WRITE[BX]
                INC     SI
                ADD     DI,80
                LOOP    WGC20071
                POP     ES
                RET
WGC2006:
                CMP     CRT_MODE,6
                JNZ     WGC2005
                                                ; MODE 6
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                CLD
WGC20061:
                LODSB
                CALL    BYTE_MOD_WRITE[BX]
                ADD     DI,80
                LOOP    WGC20061
                POP     ES
                RET
WGC2005:
                CMP     CRT_MODE,5
                JNZ     WGC2004
                                                ; MODE 5
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                CLD
WGC20051:
                LODSW
                CALL    WORD_MOD_WRITE[BX]
                ADD     DI,80
                LOOP    WGC20051
                POP     ES
                RET
WGC2004:
WGC20041:                                       ; MODE 4
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                MOV     AX,DS:[SI]
                CALL    WORD_MOD_WRITE[BX]
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
                MOV     AX,DS:[SI+16]
                CALL    WORD_MOD_WRITE[BX]
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
                MOV     AX,DS:[SI+32]
                CALL    WORD_MOD_WRITE[BX]
                INC     SI
                INC     SI
                ADD     DI,80
                LOOP    WGC20041
                POP     ES
                RET
WRITE_G_CHAR200 ENDP
;
;*********************************************************************
;*
;*      WRITE_G_CHAR400
;*
;*              WRITE GRAPHIC CHARACTER (400 MODE)
;*
;*
;*              IN:  DH = ROW
;*
;*                   DL = COLUMN
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI
;*
;*********************************************************************
;
WRITE_G_CHAR400 PROC
                PUSH    ES
                MOV     AL,DOT_MODIFY_MODE
                SHL     AL,1
                XOR     AH,AH
                MOV     BX,AX
		CALL	GDC_COMPLETE
                MOV     AH,DH
                XOR     AL,AL
                MOV     DI,AX                   ; DI = ROW*256
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*1024
                ADD     DI,AX                   ; DI = ROW*1280
                XOR     DH,DH
                ADD     DI,DX                   ; DI = (ROW*1280) + COLUMN
                MOV     SI,OFFSET CHAR_BUF
                MOV     CX,16
                CMP     CRT_MODE,9
                JNZ     WGC4008
WGC40091:                                       ; MODE 9
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI]
                CALL    BYTE_MOD_WRITE[BX]
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI+16]
                CALL    BYTE_MOD_WRITE[BX]
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
                MOV     AL,DS:[SI+32]
                CALL    BYTE_MOD_WRITE[BX]
                INC     SI
                ADD     DI,80
                LOOP    WGC40091
                POP     ES
                RET
WGC4008:
                                                ; MODE 8
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                CLD
WGC40081:
                LODSB
                CALL    BYTE_MOD_WRITE[BX]
                ADD     DI,80
                LOOP    WGC40081
                POP     ES
                RET
WRITE_G_CHAR400 ENDP
;
;*********************************************************************
;*
;*      CLEAR & CLEAR_STOP
;*
;*              CLEAR GRAPHIC VRAM
;*
;*
;*              IN:  CX = DOT DISTANCE VALUE
;*
;*                      ( BW    : 400  )
;*                      ( COLOR : 1228 )
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX
;*
;*********************************************************************
;
CLEAR1          DB      8
                DB      GRAPH_GDC_COM,CSRW      ; CSRW (EAD=4000H,DAD=0)
                DB      GRAPH_GDC_PAR,00H
                DB      GRAPH_GDC_PAR,40H
                DB      GRAPH_GDC_PAR,00H
                DB      GRAPH_GDC_COM,VECTW     ; VECTW (GRAPH CHAR,DIR=0,DC=39)
                DB      GRAPH_GDC_PAR,10H
                DB      GRAPH_GDC_PAR,39
                DB      GRAPH_GDC_PAR,00H
;
CLEAR2          DB      14
                DB      GRAPH_GDC_COM,MASKC     ; MASK (0FFFFH)
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_COM,WRITE OR CLEAR_MOD ; WRITE (MOD=CLEAR)
                DB      GRAPH_GDC_COM,TEXTW     ; TEXTW (ALL 0FFH)
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_COM,TEXTE     ; TEXTE
;
CLEAR_STOP	PROC
CS1:
		IN	AL,GRAPH_GDC_PAR	; CHECK FIFO NOT FULL
		TEST	AL,2
		JNZ	CS1
		MOV	AL,STOP
		OUT	GRAPH_GDC_COM,AL
		CALL	CLEAR
CS2:
		IN	AL,GRAPH_GDC_PAR	; CHECK FIFO EMPTY & V-SYNC
		XOR	AL,24H
		TEST	AL,24H
		JNZ	CS2
		MOV	AL,START
		OUT	GRAPH_GDC_COM,AL
		RET
CLEAR_STOP	ENDP
;
CLEAR           PROC
                PUSH    CX
                CALL    FIFO_EMPTY_GR
                MOV     BX,OFFSET CLEAR1
                CALL    SEND_GDC_GR
                POP     AX
                OUT     GRAPH_GDC_PAR,AL
                PUSH    AX                      ; WAIT
                POP     AX                      ;
                XCHG    AH,AL
                OUT     GRAPH_GDC_PAR,AL
                CALL    FIFO_EMPTY_GR
                MOV     BX,OFFSET CLEAR2
                CALL    SEND_GDC_GR
                RET
CLEAR           ENDP
;
;*********************************************************************
;*
;*      FIFO_EMPTY_GR
;*
;*              WAIT UNTIL FIFO EMPTY (FOR GRAPHIC GDC)
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL
;*
;*********************************************************************
;
FIFO_EMPTY_GR   PROC
FIFO_EMPTY_GR1:
                IN      AL,GRAPH_GDC_PAR
                TEST    AL,4
                JZ      FIFO_EMPTY_GR1
                RET
FIFO_EMPTY_GR   ENDP
;
;*********************************************************************
;*
;*      SEND_GDC_GR
;*
;*              SEND COMMANDS TO GRAPHIC GDC
;*
;*
;*              IN:  CS:BX = COMMAND BLOCK POINTER
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL,BX,CX,DX
;*
;*********************************************************************
;
SEND_GDC_GR     PROC
                XOR     CH,CH
                XOR     DH,DH
                MOV     CL,CS:[BX]              ; GET NUMBER OF COMMANDS
SEND_GDC_GR1:
                INC     BX
                MOV     DL,CS:[BX]              ; GET PORT NUMBER
                INC     BX
                MOV     AL,CS:[BX]              ; GET DATA
                OUT     DX,AL
                LOOP    SEND_GDC_GR1
                RET
SEND_GDC_GR     ENDP
;
;*********************************************************************
;*
;*      TRAN_UP_TEXT
;*
;*              COPY 1 LINE     (ALPHA)
;*
;*
;*              IN:  DH,DL = SOURCE ROW,COLUMN
;*
;*                   CH,CL = DESTINATION ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*              OUT: NOTHING
;*
;*              DESTROY: SI,DI
;*
;*********************************************************************
;
TRAN_UP_TEXT    PROC
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                PUSH    ES
                PUSH    AX                      ; SAVE LENGTH
                MOV     BH,ACTIVE_PAGE
                CALL    CNV_VRAM_TEXT           ; SOURCE ADDRESS
                XCHG    DX,CX
                CALL    CNV_VRAM_TEXT           ; DESTINATION ADDRESS
                MOV     DI,DX
                MOV     SI,CX
                POP     CX                      ; GET LENGTH
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     TT1
                SHL     CL,1
TT1:
                XOR     CH,CH
                PUSH    CX
                PUSH    SI
                PUSH    DI
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                CLD
                REP     MOVSW                   ; COPY CHARACTER CODE
                POP     DI
                POP     SI
                POP     CX
                MOV     AX,TEXT_VRAM_SEGMENT + 200H
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSW                   ; COPY ATTRIBUTE
                POP     ES
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                RET
TRAN_UP_TEXT    ENDP
;
;*********************************************************************
;*
;*      TRAN_UP_GRAPH200
;*
;*              COPY 1 LINE     (200 MODE)
;*
;*
;*              IN:  DH,DL = SOURCE ROW,COLUMN
;*
;*                   CH,CL = DESTINATION ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*              OUT: NOTHING
;*
;*              DESTROY: SI,DI,BP
;*
;*********************************************************************
;
TRAN_UP_GRAPH200 PROC
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                PUSH    ES
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     T_GR2001
                SHL     DL,1
                SHL     CL,1
T_GR2001:
                XOR     AH,AH
                MOV     BP,AX                   ; SAVE LENGTH
                MOV     AH,DH
                XOR     AL,AL
                SHR     AX,1
                MOV     BX,AX                   ; BX = ROW*128
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*512
                ADD     BX,AX                   ; BX = ROW*640
                XOR     DH,DH
                ADD     BX,DX                   ; BX = (ROW*640) + COLUMN
		CALL	GDC_COMPLETE
                MOV     AH,CH
                XOR     AL,AL
                SHR     AX,1
                MOV     DX,AX                   ; DX = ROW*128
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*512
                ADD     DX,AX                   ; DX = ROW*640
                XOR     CH,CH
                ADD     DX,CX                   ; DX (ROW*640) + COLUMN
                MOV     AX,8
                PUSH    AX                      ; PUSH LINE/CHAR
                CLD
                CMP     CRT_MODE,7
                JNZ     T_GR2006
T_GR20071:                                      ; MODE 7
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                ADD     BX,80
                ADD     DX,80
                POP    CX
                DEC    CX
                PUSH   CX
                JNZ    T_GR20071
                JMP    T_GR20099
T_GR2006:
                CMP     CRT_MODE,6
                JNZ     T_GR2005
                                                ; MODE 6
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                POP     AX
T_GR20061:
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                REP     MOVSB
                ADD     BX,80
                ADD     DX,80
                DEC     AX
                JNZ     T_GR20061
                JMP     T_GR20098
T_GR2005:
                CMP     CRT_MODE,5
                JNZ     T_GR2004
                                                ; MODE 5
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                POP     AX
T_GR20051:
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                REP     MOVSW
                ADD     BX,80
                ADD     DX,80
                DEC     AX
                JNZ     T_GR20051
                JMP     T_GR20098
T_GR2004:
T_GR20041:                                      ; MODE 4
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSW
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSW
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSW
                ADD     BX,80
                ADD     DX,80
                POP     CX
                DEC     CX
                PUSH    CX
                JNZ     T_GR20041
T_GR20099:
                INC     SP
                INC     SP
T_GR20098:
                POP     ES
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                RET
TRAN_UP_GRAPH200 ENDP
;
;*********************************************************************
;*
;*      TRAN_UP_GRAPH400
;*
;*              COPY 1 LINE     (400 MODE)
;*
;*
;*              IN:  DH,DL = SOURCE ROW,COLUMN
;*
;*                   CH,CL = DESTINATION ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*              OUT: NOTHING
;*
;*              DESTROY: SI,DI,BP
;*
;*********************************************************************
;
TRAN_UP_GRAPH400 PROC
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                PUSH    ES
                XOR     AH,AH
                MOV     BP,AX                   ; SAVE LENGTH
                MOV     AH,DH
                XOR     AL,AL
                MOV     BX,AX                   ; BX = ROW*256
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*1024
                ADD     BX,AX                   ; BX = ROW*1280
                XOR     DH,DH
                ADD     BX,DX                   ; BX = (ROW*1280) + COLUMN
		CALL	GDC_COMPLETE
                MOV     AH,CH
                XOR     AL,AL
                MOV     DX,AX                   ; DX = ROW*256
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*1024
                ADD     DX,AX                   ; DX = ROW*1280
                XOR     CH,CH
                ADD     DX,CX                   ; DX = (ROW*1280) + COLUMN
                MOV     AX,16
                PUSH    AX                      ; PUSH LINE/CHAR
                CLD
                CMP     CRT_MODE,9
                JNZ     T_GR4008
T_GR40091:                                      ; MODE 9
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                REP     MOVSB
                ADD     BX,80
                ADD     DX,80
                POP     CX
                DEC     CX
                PUSH    CX
                JNZ     T_GR40091
                INC     SP
                INC     SP
T_GR40098:
                POP     ES
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                RET
T_GR4008:
                                                ; MODE 8
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     ES,AX
                POP     AX
T_GR40081:
                MOV     SI,BX
                MOV     DI,DX
                MOV     CX,BP
                REP     MOVSB
                ADD     BX,80
                ADD     DX,80
                DEC     AX
                JNZ     T_GR40081
                JMP     T_GR40098
TRAN_UP_GRAPH400 ENDP
;
;*********************************************************************
;*
;*      FILL_UP_TEXT
;*
;*              FILL BLANK      (ALPHA)
;*
;*
;*              IN:  DH,DL = ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*                   CH = ATTRIBUTE
;*
;*                   BH = NUMBER OF LINE
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI
;*
;*********************************************************************
;
FILL_UP_TEXT    PROC
                PUSH    ES
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     FT1
                SHL     AL,1
FT1:
                MOV     BL,AL                   ; SAVE LENGTH
                MOV     CL,BH
                XCHG    CH,CL                   ; CH = NUMBER OF LINE
                                                ; CL = ATTRIBUTE
                CLD
                MOV     BH,ACTIVE_PAGE
                CALL    CNV_VRAM_TEXT
                MOV     AX,CX
FT2:
                PUSH    AX
                MOV     DI,DX                   ; DI = VRAM ADDRESS
                MOV     CL,BL
                XOR     CH,CH
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     ES,AX
                MOV     AX,0020H                ; SET BLANK CODE
                REP     STOSW
                MOV     DI,DX
                MOV     CL,BL
                XOR     CH,CH
                MOV     AX,TEXT_VRAM_SEGMENT + 200H
                MOV     ES,AX
                POP     AX
                REP     STOSW
                ADD     DX,160                  ; NEXT LINE
                DEC     AH
                JNZ     FT2
                POP     ES
                RET
FILL_UP_TEXT    ENDP
;
;*********************************************************************
;*
;*      FILL_UP_GRAPH200
;*
;*              FILL COLOR      (200 MODE)
;*
;*
;*              IN:  DH,DL = ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*                   CH = COLOR ID
;*
;*                   BH = NUMBER OF LINE
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI,BP
;*
;*********************************************************************
;
FILL_UP_GRAPH200 PROC
                PUSH    ES
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     FG21
                SHL     DL,1
FG21:
                XOR     AH,AH
                MOV     BP,AX                   ; SAVE LENGTH
		CALL	GDC_COMPLETE
                MOV     AH,DH
                XOR     AL,AL
                SHR     AX,1
                MOV     SI,AX                   ; SI = ROW*128
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*512
                ADD     SI,AX                   ; SI = ROW*640
                XOR     DH,DH
                ADD     SI,DX                   ; SI = (ROW*640) + COLUMN
                MOV     DL,BH
                XOR     DH,DH
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1                    ; DX = (NUMBER OF LINE) * 8
                MOV     BL,CH
                MOV     BH,BL                   ; BL,BH = COLOR ID
                CLD
                CMP     CRT_MODE,7
                JNZ     FG26
FG271:                                          ; MODE 7
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 1
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 2
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                ADD     SI,80                   ; NEXT LINE
                MOV     BL,BH                   ; RESTORE COLOR ID
                DEC     DX
                JNZ     FG271
                JMP     FG299
FG26:
                CMP     CRT_MODE,6
                JNZ     FG25
                                                ; MODE 6
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AL,AL                   ; SET 000H OR 0FFH
FG261:
                MOV     DI,SI
                MOV     CX,BP
                REP     STOSB
                ADD     SI,80                   ; NEXT LINE
                DEC     DX
                JNZ     FG261
                JMP     FG299
FG25:
                CMP     CRT_MODE,5
                JNZ     FG24
                                                ; MODE 5
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                XOR     AX,AX
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AX,AX                   ; SET 000 OR 0FFH
FG251:
                MOV     DI,SI
                MOV     CX,BP
                REP     STOSW
                ADD     SI,80                   ; NEXT LINE
                DEC     DX
                JNZ     FG251
                JMP     FG299
FG24:
FG241:                                          ; MODE 4
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
                XOR     AX,AX
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AX,AX                   ; SET 000H OR 0FFH
                REP     STOSW
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
                XOR     AX,AX
                SHR     BL,1                    ; CHECK BIT 1
                SBB     AX,AX                   ; SET 000H OR 0FFH
                REP     STOSW
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
                XOR     AX,AX
                SHR     BL,1                    ; CHECK BIT 2
                SBB     AX,AX                   ; SET 000H OR 0FFH
                REP     STOSW
                ADD     SI,80                   ; NEXT LINE
                MOV     BL,BH                   ; RESTORE COLOR ID
                DEC     DX
                JNZ     FG241
FG299:
                POP     ES
                RET
FILL_UP_GRAPH200 ENDP
;
;*********************************************************************
;*
;*      FILL_UP_GRAPH400
;*
;*              FILL COLOR      (400 MODE)
;*
;*
;*              IN:  DH,DL = ROW,COLUMN
;*
;*                   AL = LENGTH (NUMBER OF CHARACTER)
;*
;*                   CH = COLOR ID
;*
;*                   BH = NUMBER OF LINE
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI,BP
;*
;*********************************************************************
;
FILL_UP_GRAPH400 PROC
                PUSH    ES
                XOR     AH,AH
                MOV     BP,AX                   ; SAVE LENGTH
		CALL	GDC_COMPLETE
                MOV     AH,DH
                XOR     AL,AL
                MOV     SI,AX                   ; SI = ROW*256
                SHL     AX,1
                SHL     AX,1                    ; AX = ROW*1024
                ADD     SI,AX                   ; SI = ROW*1280
                XOR     DH,DH
                ADD     SI,DX                   ; SI = (ROW*1280) + COLUMN
                MOV     DL,BH
                XOR     DH,DH
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1                    ; DX = (NUMBER OF LINE) * 16
                MOV     BL,CH
                MOV     BH,BL                   ; BL,BH = COLOR ID
                CLD
                CMP     CRT_MODE,9
                JNZ     FG48
FG491:                                          ; MODE 9
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE3_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE2_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 1
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                MOV     DI,SI
                MOV     CX,BP
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 2
                SBB     AL,AL                   ; SET 000H OR 0FFH
                REP     STOSB
                ADD     SI,80                   ; NEXT LINE
                MOV     BL,BH                   ; RESTORE COLOR ID
                DEC     DX
                JNZ     FG491
                JMP     FG499
FG48:
                                                ; MODE 8
                MOV     AX,PLANE1_SEGMENT
                MOV     ES,AX
;               XOR     AL,AL
                SHR     BL,1                    ; CHECK BIT 0
                SBB     AL,AL                   ; SET 000H OR 0FFH
FG481:
                MOV     DI,SI
                MOV     CX,BP
                REP     STOSB
                ADD     SI,80                   ; NEXT LINE
                DEC     DX
                JNZ     FG481
FG499:
                POP     ES
                RET
FILL_UP_GRAPH400 ENDP
;
;*********************************************************************
;*
;*      READ_FONT200
;*
;*              READ FONT PATTERN       (200 MODE)
;*
;*
;*              IN:  DL = CHARACTER CODE
;*
;*                   DI = BUFFER OFFSET
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI
;*
;*********************************************************************
;
READ_FONT200    PROC
                XOR     DH,DH
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                MOV     SI,DX
                ADD     SI,OFFSET FONT_80       ; SI = FONT PATTERN OFFSET
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     RF21
                MOV     DL,8
RF22:
                MOV     AL,CS:[SI]
                MOV     CX,8
RF23:
                SHR     AL,1
                LAHF
                RCR     BX,1
                SAHF
                RCR     BX,1
                LOOP    RF23
                XCHG    BH,BL
                MOV     DS:[DI],BX
                INC     SI
                INC     DI
                INC     DI
                DEC     DL
                JNZ     RF22
                RET
RF21:
                MOV     AX,CS
                MOV     DS,AX
                MOV     CX,4
                CLD
                REP     MOVSW
                MOV     AX,ES
                MOV     DS,AX
                RET
READ_FONT200    ENDP
;
;*********************************************************************
;*
;*      READ_FONT400
;*
;*              READ FONT PATTERN       (400 MODE)
;*
;*
;*              IN:  DL = CHARACTER CODE
;*
;*                   DI = BUFFER OFFSET
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,CX,SI,DI,DX
;*
;*********************************************************************
;
READ_FONT400    PROC
                XOR     DH,DH
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                MOV     SI,DX
                ADD     SI,OFFSET FONT_88       ; SI = FONT PATTERN OFFSET
                MOV     AX,CS
                MOV     DS,AX
                MOV     CX,8
                CLD
                REP     MOVSW
                MOV     AX,ES
                MOV     DS,AX
                RET
READ_FONT400    ENDP
;
;*********************************************************************
;*
;*      SEARCH_FONT200
;*
;*              SEARCH FONT PATTERN     (200 MODE)
;*
;*
;*              IN:  DH,DL = ROW,COLUMN
;*
;*              OUT: AL = CHARACTER CODE
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI,BP
;*
;*********************************************************************
;
SEARCH_FONT200  PROC
                CALL    READ_G_CHAR200
                CMP     CRT_MODE,5
                JZ      SF21                    ; JUMP IF BW MODE
                CMP     CRT_MODE,6
                JZ      SF21                    ; JUMP IF BW MODE
                MOV     CX,4
                JNC     SF22                    ; JUMP IF 640*200 MODE
                SHL     CX,1
SF22:
                MOV     SI,OFFSET CHAR_BUF
                MOV     BX,CX
                SHL     BX,1
SF23:
                MOV     AX,[SI+BX]
                OR      [SI],AX                 ; OR PLANE 2
                SHL     BX,1
                MOV     AX,[SI+BX]
                OR      [SI],AX                 ; OR PLANE 3
                SHR     BX,1
                INC     SI
                INC     SI
                LOOP    SF23
SF21:
                CLD
                XOR     BP,BP
SF24:
                MOV     DX,BP                   ; SET CHARACTER CODE
                MOV     DI,(OFFSET CHAR_BUF) + 16
                CALL    READ_FONT200
                MOV     CX,4                    ; SET 4 WORD
                CMP     CRT_COLS,40             ; CHECK 40 COLUMN MODE
                JNZ     SF25
                SHL     CX,1                    ; SET 8 WORD
SF25:
                MOV     SI,OFFSET CHAR_BUF
                MOV     DI,(OFFSET CHAR_BUF) + 16
                REPE    CMPSW
                JE      SF_MATCH2               ; JUMP IF MATCH
                INC     BP
                TEST    BP,0100H                ; END ?
                JZ      SF24
SF_MATCH2:
                MOV     AX,BP
                RET
SEARCH_FONT200  ENDP
;
;*********************************************************************
;*
;*      SEARCH_FONT400
;*
;*              SEARCH FONT PATTERN     (400 MODE)
;*
;*
;*              IN:  DH,DL = ROW,COLUMN
;*
;*              OUT: AL = CHARACTER CODE
;*
;*              DESTROY: AX,BX,CX,DX,SI,DI,BP
;*
;*********************************************************************
;
SEARCH_FONT400  PROC
                CALL    READ_G_CHAR400
                CMP     CRT_MODE,8
                JZ      SF41                    ; JUMP IF BW MODE
                MOV     SI,OFFSET CHAR_BUF
                MOV     CX,8
SF43:
                MOV     AX,[SI+16]
                OR      [SI],AX                 ; OR PLANE 2
                MOV     AX,[SI+32]
                OR      [SI],AX                 ; OR PLANE 3
                INC     SI
                INC     SI
                LOOP    SF43
SF41:
                CLD
                XOR     BP,BP
SF44:
                MOV     DX,BP                   ; SET CHARACTER CODE
                MOV     DI,(OFFSET CHAR_BUF) + 16
                CALL    READ_FONT400
                MOV     CX,8                    ; SET 8 WORD
                MOV     SI,OFFSET CHAR_BUF
                MOV     DI,(OFFSET CHAR_BUF) + 16
                REPE    CMPSW
                JE      SF_MATCH4               ; JUMP IF MATCH
                INC     BP
                TEST    BP,0100H                ; END ?
                JZ      SF44
SF_MATCH4:
                MOV     AX,BP
                RET
SEARCH_FONT400  ENDP
;
;*********************************************************************
;*
;*      SET_MODE_TEXT_L
;*
;*              LOW LEVEL INITIALIZATION FOR TEXT SCREEN
;*
;*
;*              IN:  DL = 1 (40 CHARACTER MODE)
;*                      = 0 (80 CHARACTER MODE)
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,SI
;*
;*********************************************************************
;
CR_MS_DATA      LABEL   BYTE
                DB      00H,07H,08H             ; 80CRT
                DB      00H,0FH,10H             ; 88CRT
;
SET_MODE_TEXT_L PROC
                MOV     AX,CS
                MOV     DS,AX
                MOV     SI,OFFSET CR_MS_DATA
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                JZ      SMTL1
                ADD     SI,3                    ; 88CRT
SMTL1:
                LODSB
                OUT     CRT_MS_PL,AL
                LODSB
                OUT     CRT_MS_BL,AL
                LODSB
                OUT     CRT_MS_CL,AL
                XOR     AL,AL
                OUT     CRT_MS_SSL,AL
                MOV     AL,ATRSEL_VLINE
                OUT     CRT_FF,AL
                TEST    DL,1
                MOV     AL,COLWIDTH_40
                JNZ     SMTL2
                MOV     AL,COLWIDTH_80
SMTL2:
                OUT     CRT_FF,AL
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                MOV     AL,FONTSEL_80
                JZ      SMTL3
                MOV     AL,FONTSEL_88
SMTL3:
                OUT     CRT_FF,AL
                MOV     AX,ES
                MOV     DS,AX
SMTL4:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY & V-SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SMTL4
                MOV     AL,SCROLL               ; SEND SCROLL COMMAND
                OUT     TEXT_GDC_COM,AL
                XOR     AX,AX                   ; SAD = 0
                NOP
                OUT     TEXT_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     TEXT_GDC_PAR,AL
                MOV     AX,3FF0H                ; SL = 3FFH
                NOP
                OUT     TEXT_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     TEXT_GDC_PAR,AL
                RET
SET_MODE_TEXT_L ENDP
;
;*********************************************************************
;*
;*      SET_MODE_GRAPH_L
;*
;*              LOW LEVEL INITIALIZATION FOR GRAPH SCREEN
;*
;*
;*              IN:  DL (bit 0) = 1 (200 MODE)
;*                      	= 0 (400 MODE)
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX
;*
;*********************************************************************
;
SET_MODE_GRAPH_L PROC
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                MOV     AL,GRAPH_OTHER
                JZ      SMGL1                   ; JUMP IF 80CRT
                TEST    DL,1
                JZ      SMGL1                   ; JUMP IF 400 MODE
                MOV     AL,GRAPH_88CRT200
SMGL1:
                OUT     CRT_FF,AL
SMGL2:
                IN      AL,GRAPH_GDC_PAR        ; CHECK FIFO EMPTY & V-SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SMGL2
                MOV     AL,SYNC_STOP            ; SEND SYNC COMMAND
		OUT     GRAPH_GDC_COM,AL
                MOV     AL,16H
                NOP
                OUT     GRAPH_GDC_PAR,AL
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                JZ      SMGL3                   ; JUMP IF 80CRT
                MOV     AL,CSRFORM              ; SEND CSRFORM COMMAND
                OUT     GRAPH_GDC_COM,AL
                XOR     AL,AL
                TEST    DL,1
                JZ      SMGL4
                INC     AL
SMGL4:
                OUT     GRAPH_GDC_PAR,AL
		NOP
SMGL3:
                MOV     AL,SCROLL               ; SEND SCROLL COMMAND
                OUT     GRAPH_GDC_COM,AL
                XOR     AX,AX                   ; SAD = 0
                NOP
                OUT     GRAPH_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     GRAPH_GDC_PAR,AL
                MOV     AX,3FF0H                ; SL = 3FFH
                NOP
                OUT     GRAPH_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     GRAPH_GDC_PAR,AL
                RET
SET_MODE_GRAPH_L ENDP
;
;*********************************************************************
;*
;*	SET_ACCESS_BANK
;*
;*		SET ACCESS BANK IF NECESSARY
;*
;*
;*		IN:  NOTHING
;*
;*		OUT: NOTHING
;*
;*		DESTROY: AL
;*
;*********************************************************************
;
SET_ACCESS_BANK	PROC
		MOV	AL,DRAW_PAGE_SETTING
		CMP	AL,DRAW_PAGE
		JNZ	SET_BANK
		RET
SET_ACCESS_BANK	ENDP
;
;*********************************************************************
;*
;*      SET_BANK
;*
;*              SET ACCESS BANK
;*
;*
;*              IN:  AL = BANK NUMBER
;*
;*              OUT: NOTHING
;*
;*              DESTROY: NOTHING
;*
;*********************************************************************
;
SET_BANK        PROC
                MOV     DRAW_PAGE,AL
		CALL	GDC_COMPLETE
                MOV     AL,DRAW_PAGE
                OUT     ACCESS_BANK,AL
                RET
SET_BANK        ENDP
;
;*********************************************************************
;*
;*      SET_MODE
;*
;*             SET CRT MODE
;*
;*
;*              IN:  AL = MODE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
COND_MODE       LABEL   BYTE    ; 40 CHAR FLAG,COLOR & 200 MODE FLAG,CRT_COLS,
                                ; B/W MODE,CRT_ENTRY,DISTANCE FOR CLEAR
                DB      1,0 OR 1,40,0                ; MODE 0
                DW                      0,400
                DB      1,2 OR 1,40,1                ; MODE 1
                DW                      0,400
                DB      0,0 OR 1,80,2                ; MODE 2
                DW                      0,400
                DB      0,2 OR 1,80,3                ; MODE 3
                DW                      0,400
                DB      1,2 OR 1,40,5                ; MODE 4
                DW                      64,1228
                DB      1,0 OR 1,40,5                ; MODE 5
                DW                      64,400
                DB      0,0 OR 1,80,6                ; MODE 6
                DW                      64,400
                DB      0,2 OR 1,80,6                ; MODE 7
                DW                      64,1228
                DB      0,0 OR 0,80,8                ; MODE 8
                DW                      128,400
                DB      0,2 OR 0,80,8                ; MODE 9
                DW                      128,1228
PALETTE_INIT    LABEL   WORD                            ; INITIAL PALETTE VALUE
                DW      0000H,0101H,0202H,0303H         ; COLOR MODE
                DW      0404H,0505H,0606H,0707H
                DW      0000H,0100H,0200H,0300H         ; B/W MODE
                DW      0407H,0507H,0607H,0707H
SET_MODE        PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
		CLD
                MOV     BL,AL
                XOR     BH,BH
                SHL     BX,1
                SHL     BX,1
                SHL     BX,1
                MOV     BP,BX
                TEST    BYTE PTR BIOS_FLAG[1],00001000B ; CHECK COLOR RAM
                JNZ     SET_MODE1
                MOV     AL,COND_MODE[BP+3]      ; CHANGE B/W MODE
                MOV     BL,AL
                XOR     BH,BH
                SHL     BX,1
                SHL     BX,1
                SHL     BX,1
                MOV     BP,BX
SET_MODE1:
                MOV     CRT_MODE,AL
SET_MODE4:
                IN      AL,GRAPH_GDC_PAR        ; CHECK FIFO NOT FULL
                TEST    AL,2
                JNZ     SET_MODE4
                MOV     AL,STOP                 ; SEND STOP COMMAND
                OUT     GRAPH_GDC_COM,AL
SET_MODE5:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO NOT FULL
                TEST    AL,2
                JNZ     SET_MODE5
                MOV     AL,STOP                 ; SEND STOP COMMAND
                OUT     TEXT_GDC_COM,AL
                MOV     DL,COND_MODE[BP]
                CALL    SET_MODE_TEXT_L         ; LOW LEVEL INITIALIZE (TEXT)
                MOV     DL,COND_MODE[BP+1]
                CALL    SET_MODE_GRAPH_L        ; LOW LEVEL INITIALIZE (GRAPH)
                MOV     AL,COND_MODE[BP+2]
                MOV     CRT_COLS,AL
                MOV     AX,WORD PTR COND_MODE[BP+4]
                MOV     CRT_ENTRY,AX
                MOV     CURSOR_POSN[0],0
                MOV     CURSOR_POSN[2],0
                MOV     ACTIVE_PAGE,0
		MOV	DRAW_PAGE_SETTING,0
		MOV	AL,BYTE PTR COND_MODE[BP+1]
		SHR	AL,1
		MOV	CRT_COLOR,AL
                                                ; CLEAR TEXT VRAM
                PUSH    DS
                MOV     AX,CMOS_SWITCH_SEGMENT
                MOV     DS,AX
                MOV     BX,CMOS_SWITCH_OFFSET
                TEST    BYTE PTR DS:[BX],01000000B
                POP     DS
                MOV     DH,WHITE_ATTR           ; WHITE
                JZ      WHITE_DEF
                MOV     DH,GREEN_ATTR           ; GREEN
WHITE_DEF:
                PUSH    ES
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     ES,AX
                XOR     AX,AX
                MOV     CX,1000H
                MOV     AL,DH
                MOV     DI,ATTRIBUTE_OFFSET
                REP     STOSW
                MOV     CX,1000H
                MOV     AL,20H                  ; BLANK CODE
                XOR     DI,DI
                REP     STOSW
                POP     ES
                XOR     AX,AX                   ; CLEAR PALETTE FOR ALPHA
                OUT     PALETTE_REG01,AL
                OUT     PALETTE_REG23,AL
                OUT     PALETTE_REG45,AL
                OUT     PALETTE_REG67,AL
                CMP     CRT_MODE,4
                JC      SET_MODE7               ; JUMP IF ALPHA MODE
                MOV     CX,WORD PTR COND_MODE[BP+6]	; SET DISTANCE
                MOV     AL,1                    ; SET BANK=1
                CALL    SET_BANK
                CALL    CLEAR
                MOV     CX,WORD PTR COND_MODE[BP+6]	; SET DISTANCE
                XOR     AL,AL                   ; SET BANK=0
                CALL    SET_BANK
                CALL    CLEAR
                MOV     SI,OFFSET PALETTE_INIT
                CMP     WORD PTR COND_MODE[BP+6],400	; CHECK B/W MODE
                JNZ     SET_MODE8
                ADD     SI,16                   ; SET DATA FOR B/W MODE
SET_MODE8:
                MOV     CX,8
SET_MODE9:
                MOV     BX,CS:[SI]
                INC     SI
                INC     SI
                CALL    SP3			; NO CHECK SET_PALETTE ROUTINE
                LOOP    SET_MODE9
SET_MODE7:
                MOV     BX,0FF00H               ; INITIALIZE BORDER COLOR
                CALL    SET_PALETTE
                XOR     BH,BH                   ; INITIALIZE CURSOR POSITION
                XOR     DX,DX                   ; (0,0)
                CALL    SET_CURSOR
                MOV     CX,0007H                ; INITIALIZE CURSOR TYPE
                CALL    SET_CURSOR_TYPE
                CMP     CRT_MODE,4
                JC      SET_MODE3               ; JUMP IF ALPHA MODE
SET_MODE2:
                IN      AL,GRAPH_GDC_PAR        ; CHECK FIFO EMPTY & V-SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SET_MODE2
                XOR     AL,AL                   ; SET DISPLAY BANK
                OUT     DISPLAY_BANK,AL
                MOV     AL,START                ; SEND START COMMAND
                OUT     GRAPH_GDC_COM,AL
SET_MODE3:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY & V-SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SET_MODE3
                MOV     AL,START                ; SEND START COMMAND
                OUT     TEXT_GDC_COM,AL
                POP     DX
                POP     CX
                POP     BX
                RET
SET_MODE        ENDP
;
;*********************************************************************
;*
;*      SET_CURSOR_TYPE
;*
;*              SET CURSOR TYPE
;*
;*
;*              IN:  CH = CURSOR START LINE (MSB=1 : CURSOR OFF)
;*
;*                   CL = CURSOR END LINE
;*
;*              OUT: NOTHING
;*
;*              DESTORY: AX
;*
;*********************************************************************
;
SET_CURSOR_TYPE PROC
                PUSH    CX
                MOV     CURSOR_MODE,CX
SCT1:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY
                TEST    AL,4
                JZ      SCT1
                MOV     AL,CSRFORM
                OUT     TEXT_GDC_COM,AL
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                MOV     AL,7                    ; SET L/R FOR 80CRT
                JZ      SCT2
                SHL     CX,1
                MOV     AL,15                   ; SET L/R FOR 88CRT
                JC      SCT3
                JMP     SHORT SCT15
SCT2:
                TEST    CH,80H                  ; CHECK MSB
                JNZ     SCT3
SCT15:
                OR      AL,80H
SCT3:
                OUT     TEXT_GDC_PAR,AL
                MOV     AL,7FH
                AND     AL,CH
                ROL     CL,1
                ROL     CL,1
                OUT     TEXT_GDC_PAR,AL         ; OUTPUT AFTER DELAY
                ROL     CL,1
                MOV     AL,CL
                ADD     AL,3                    ; SET BLINK RATE
                OUT     TEXT_GDC_PAR,AL
                POP     CX
                RET
SET_CURSOR_TYPE ENDP
;
;*********************************************************************
;*
;*      SET_CURSOR
;*
;*              SET CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   DH,DL = ROW,COLUMN
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AX,SI
;*
;*********************************************************************
;
SET_CURSOR      PROC
                PUSH    DX
                PUSH    BX
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     CURSOR_POSN[BX],DX
                SHR     BX,1
                CMP     BL,ACTIVE_PAGE
                JNZ     SCP1
                MOV     BH,BL
                CALL    CNV_VRAM_TEXT
SCP2:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY
                TEST    AL,4
                JZ      SCP2
                MOV     AL,CSRW                 ; SEND CSRW COMMAND
                OUT     TEXT_GDC_COM,AL
                MOV     AX,DX
                SHR     AX,1
                OUT     TEXT_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     TEXT_GDC_PAR,AL
SCP1:
                POP     BX
                POP     DX
                RET
SET_CURSOR      ENDP
;
;*********************************************************************
;*
;*      GET_CURSOR
;*
;*              GET CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*              OUT: DH,DL = ROW,COLUMN
;*
;*                   CH = CURSOR START LINE (MSB=1 : CURSOR OFF)
;*
;*                   CL = CURSOR END LINE
;*
;*********************************************************************
;
GET_CURSOR      PROC
                PUSH    BX
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                MOV     CX,CURSOR_MODE
                POP     BX
                RET
GET_CURSOR      ENDP
;
;*********************************************************************
;*
;*      GET_LPEN
;*
;*              GET LIGHT PEN STATUS
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: AH = 0 : ON
;*                      = 1 : OFF
;*
;*                   DH,DL = ROW,COLUMN
;*
;*********************************************************************
;
GET_LPEN        PROC
                IN      AL,TEXT_GDC_PAR         ; SENSE LPEN STATUS
                TEST    AL,80H
                JNZ     GL2
                MOV     AH,1
                RET
GL2:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY
                TEST    AL,4
                JZ      GL2
                MOV     AL,LPEN                 ; SEND LPEN COMMAND
                OUT     TEXT_GDC_COM,AL
                NOP
GL3:
                IN      AL,TEXT_GDC_PAR         ; CHECK DATA READY
                TEST    AL,1
                JZ      GL3
                IN      AL,TEXT_GDC_COM         ; GET LAD
                MOV     DL,AL
                NOP
                IN      AL,TEXT_GDC_COM
                MOV     DH,AL
                NOP
                IN      AL,TEXT_GDC_COM
                SUB     DX,6                    ; ADJUSTMENT
                CMP     ACTIVE_PAGE,0
                JZ      GL5
                SUB     DX,800H                 ;
GL5:
                MOV     AX,DX
                MOV     DL,80
                DIV     DL
                MOV     DX,AX
                XCHG    DH,DL
                CMP     CRT_COLS,40
                JNZ     GL4
                SHR     DL,1
GL4:
                XOR     AH,AH
                RET
GET_LPEN        ENDP
;
;*********************************************************************
;*
;*      SET_DISPLAY_PAGE_TEXT
;*
;*              SET ACTIVE DISPLAY PAGE (ALPHA)
;*
;*
;*              IN:  AL = PAGE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SET_DISPLAY_PAGE_TEXT PROC
                PUSH    DX
                PUSH    BX
                MOV     ACTIVE_PAGE,AL
                SHL     AL,1
                SHL     AL,1
                SHL     AL,1
                MOV     DH,AL
SDPT1:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY & V-SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SDPT1
                MOV     AL,SCROLL               ; SEND SCROLL COMMAND
                OUT     TEXT_GDC_COM,AL
                XOR     AL,AL                   ; SAD = PAGE NUMBER * 800H
                NOP
                OUT     TEXT_GDC_PAR,AL
                MOV     AL,DH
                NOP
                OUT     TEXT_GDC_PAR,AL
                MOV     AX,3FF0H                ; SL = 3FFH
                NOP
                OUT     TEXT_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     TEXT_GDC_PAR,AL
SET_DISPLAY_PAGE_COM:
                MOV     BL,ACTIVE_PAGE
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                SHR     BX,1
                MOV     BH,BL
                CALL    CNV_VRAM_TEXT
SDPT2:
                IN      AL,TEXT_GDC_PAR         ; CHECK FIFO EMPTY
                TEST    AL,4
                JZ      SDPT2
                MOV     AL,CSRW                 ; SEND CSRW COMMAND
                OUT     TEXT_GDC_COM,AL
                MOV     AX,DX
                SHR     AX,1
                OUT     TEXT_GDC_PAR,AL
                XCHG    AH,AL
                NOP
                OUT     TEXT_GDC_PAR,AL
                POP     BX
                POP     DX
                RET
SET_DISPLAY_PAGE_TEXT ENDP
;
;*********************************************************************
;*
;*      SET_DISPLAY_PAGE_GR
;*
;*              SET ACTIVE DISPLAY PAGE (GRAPH)
;*
;*
;*              IN:  AL = PAGE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SET_DISPLAY_PAGE_GR PROC
                PUSH    DX
                PUSH    BX
                MOV     ACTIVE_PAGE,AL
                MOV     DH,AL
SDPG1:
                IN      AL,GRAPH_GDC_PAR        ; CHECK V-SYNC
                TEST    AL,20H
                JZ      SDPG1
                MOV     AL,DH
                OUT     DISPLAY_BANK,AL
                JMP     SET_DISPLAY_PAGE_COM
SET_DISPLAY_PAGE_GR ENDP
;
;*********************************************************************
;*
;*      SCROLL_UP_TEXT
;*
;*              SCROLL UP       (ALPHA)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = ATTRIBUTE
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_UP_TEXT  PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                AND     AL,AL                   ; CHECK AL=0
                JZ      SUT1
                SUB     DH,CH
                SUB     DH,AL
                INC     DH
                PUSH    BX
                MOV     BL,DH                   ; LOOP COUNT (BL=DH-CH-AL+1)
                SUB     DL,CL
                INC     DL                      ; TRANSFER LENGTH (DL=DL-CL+1)
                PUSH    DX
                MOV     DX,CX
                ADD     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
SUT2:
                CALL    TRAN_UP_TEXT
                INC     CH
                INC     DH
                DEC     BL
                JNZ     SUT2
                XCHG    DX,CX
                POP     CX
SUT3:
                CALL    FILL_UP_TEXT
                POP     DX
                POP     CX
                POP     BX
                RET
SUT1:
                MOV     AH,BH
                MOV     BH,DH
                SUB     BH,CH
                INC     BH                      ; NUMBER OF LINE (BH=DH-CH+1)
                XCHG    DX,CX
                MOV     CH,AH                   ; SET ATTRIBUTE
                MOV     AL,CL
                SUB     AL,DL
                INC     AL                      ; NUMBER OF COLUMN (AL=DL-CL+1)
                JMP     SHORT SUT3
SCROLL_UP_TEXT  ENDP
;
;*********************************************************************
;*
;*      SCROLL_UP_GR200
;*
;*              SCROLL UP       (200 MODE)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_UP_GR200 PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BL,ACTIVE_PAGE
                CMP     BL,DRAW_PAGE
                JZ      SUG20
                XCHG    AL,BL
                CALL    SET_BANK
                XCHG    AL,BL
SUG20:
                AND     AL,AL                   ; CHECK AL=0
                JZ      SUG21
                SUB     DH,CH
                SUB     DH,AL
                INC     DH
                PUSH    BX
                MOV     BL,DH                   ; LOOP COUNT (BL=DH-CH-AL+1)
                SUB     DL,CL
                INC     DL                      ; TRANSFER LENGTH (DL=DL-CL+1)
                PUSH    DX
                MOV     DX,CX
                ADD     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
SUG22:
                CALL    TRAN_UP_GRAPH200
                INC     CH
                INC     DH
                DEC     BL
                JNZ     SUG22
                XCHG    DX,CX
                POP     CX
SUG23:
                CALL    FILL_UP_GRAPH200
SUG26:
                POP     DX
                POP     CX
                POP     BX
                RET
SUG21:
                AND     CX,CX                   ; CHECK (0,0)
                JNZ     SUG24
                CMP     DH,24                   ;       (24,
                JNZ     SUG24
                MOV     AL,CRT_COLS
                DEC     AL
                CMP     AL,DL                   ;          ,CRT_COLS-1)
                JNZ     SUG24
                AND     BH,00000111B            ; PALETTE NUMBER = 0 ?
                JNZ     SUG24
                MOV     CX,1228			; DISTANCE FOR COLOR MODE
                CMP     CRT_MODE,7              ; JUMP IF COLOR
                JZ      SUG25
                CMP     CRT_MODE,4              ; JUMP IF COLOR
                JZ      SUG25
                MOV     CX,400                  ; DISTANCE FOR B/W MODE
SUG25:
                CALL    CLEAR_STOP
                JMP     SHORT SUG26
SUG24:
                MOV     AH,BH
                MOV     BH,DH
                SUB     BH,CH
                INC     BH                      ; NUMBER OF LINE (BH=DH-CH+1)
                XCHG    DX,CX
                MOV     CH,AH                   ; SET PALETTE NUMBER
                MOV     AL,CL
                SUB     AL,DL
                INC     AL                      ; NUMBER OF COLUMN (AL=DL-CL+1)
                JMP     SHORT SUG23
SCROLL_UP_GR200 ENDP
;
;*********************************************************************
;*
;*      SCROLL_UP_GR400
;*
;*              SCROLL UP       (400 MODE)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_UP_GR400 PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BL,ACTIVE_PAGE
                CMP     BL,DRAW_PAGE
                JZ      SUG40
                XCHG    AL,BL
                CALL    SET_BANK
                XCHG    AL,BL
SUG40:
                AND     AL,AL                   ; CHECK AL=0
                JZ      SUG41
                SUB     DH,CH
                SUB     DH,AL
                INC     DH
                PUSH    BX
                MOV     BL,DH                   ; LOOP COUNT (BL=DH-CH-AL+1)
                SUB     DL,CL
                INC     DL                      ; TRANSFER LENGTH (DL=DL-CL+1)
                PUSH    DX
                MOV     DX,CX
                ADD     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
SUG42:
                CALL    TRAN_UP_GRAPH400
                INC     CH
                INC     DH
                DEC     BL
                JNZ     SUG42
                XCHG    DX,CX
                POP     CX
SUG43:
                CALL    FILL_UP_GRAPH400
SUG46:
                POP     DX
                POP     CX
                POP     BX
                RET
SUG41:
                AND     CX,CX                   ; CHECK (0,0)
                JNZ     SUG44
                CMP     DH,24                   ;       (24,
                JNZ     SUG44
                MOV     AL,CRT_COLS
                DEC     AL
                CMP     AL,DL                   ;          ,CRT_COLS-1)
                JNZ     SUG44
                AND     BH,00000111B            ; PALETTE NUMBER = 0 ?
                JNZ     SUG44
                MOV     CX,1228			; DISTANCE FOR COLOR MODE
                CMP     CRT_MODE,9              ; JUMP IF COLOR
                JZ      SUG45
                MOV     CX,400                  ; DISTANCE FOR B/W MODE
SUG45:
                CALL    CLEAR_STOP
		JMP     SHORT SUG46
SUG44:
                MOV     AH,BH
                MOV     BH,DH
                SUB     BH,CH
                INC     BH                      ; NUMBER OF LINE (BH=DH-CH+1)
                XCHG    DX,CX
                MOV     CH,AH                   ; SET PALETTE NUMBER
                MOV     AL,CL
                SUB     AL,DL
                INC     AL                      ; NUMBER OF COLUMN (AL=DL-CL+1)
                JMP     SHORT SUG43
SCROLL_UP_GR400 ENDP
;
;*********************************************************************
;*
;*      SCROLL_DOWN_TEXT
;*
;*              SCROLL DOWN     (ALPHA)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = ATTRIBUTE
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_DOWN_TEXT PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                AND     AL,AL                   ; CHECK AL=0
                JZ      SDT1
                PUSH    BX
                MOV     BL,DH
                SUB     BL,CH
                SUB     BL,AL
                INC     BL                      ; LOOP COUNT (BL=DH-CH-AL+1)
                MOV     BH,DL
                SUB     BH,CL
                INC     BH                      ; TRANSFER LENGTH (BH=DL-CL+1)
                PUSH    BX
                MOV     DL,CL
                MOV     CH,DH
                SUB     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
                XCHG    AH,AL
SDT2:
                CALL    TRAN_UP_TEXT
                DEC     CH
                DEC     DH
                DEC     BL
                JNZ     SDT2
                POP     CX
                INC     DH
                CALL    FILL_UP_TEXT
                POP     DX
                POP     CX
                POP     BX
                RET
SDT1:
                JMP     SUT1
SCROLL_DOWN_TEXT ENDP
;
;*********************************************************************
;*
;*      SCROLL_DOWN_GR200
;*
;*              SCROLL DOWN     (200 MODE)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_DOWN_GR200 PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BL,ACTIVE_PAGE
                CMP     BL,DRAW_PAGE
                JZ      SDG20
                XCHG    AL,BL
                CALL    SET_BANK
                XCHG    AL,BL
SDG20:
                AND     AL,AL                   ; CHECK AL=0
                JZ      SDG21
                PUSH    BX
                MOV     BL,DH
                SUB     BL,CH
                SUB     BL,AL
                INC     BL                      ; LOOP COUNT (BL=DH-CH-AL+1)
                MOV     BH,DL
                SUB     BH,CL
                INC     BH                      ; TRANSFER LENGTH (BH=DL-CL+1)
                PUSH    BX
                MOV     DL,CL
                MOV     CH,DH
                SUB     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
                XCHG    AH,AL
SDG22:
                CALL    TRAN_UP_GRAPH200
                DEC     CH
                DEC     DH
                DEC     BL
                JNZ     SDG22
                POP     CX
                INC     DH
                CALL    FILL_UP_GRAPH200
                POP     DX
                POP     CX
                POP     BX
                RET
SDG21:
                JMP     SUG21
SCROLL_DOWN_GR200 ENDP
;
;*********************************************************************
;*
;*      SCROLL_DOWN_GR400
;*
;*              SCROLL DOWN     (400 MODE)
;*
;*
;*              IN:  AL = NUMBER OF LINES
;*                        (AL=0 : MEANS BLANK ENTIRE WINDOW)
;*
;*                   CH,CL = ROW,COLUMN OF UPPER LEFT CORNER OF SCROLL
;*
;*                   DH,DL = ROW,COLUMN OF LOWER RIGHT CORNER OF SCROLL
;*
;*                   BH = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SCROLL_DOWN_GR400 PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BL,ACTIVE_PAGE
                CMP     BL,DRAW_PAGE
                JZ      SDG40
                XCHG    AL,BL
                CALL    SET_BANK
                XCHG    AL,BL
SDG40:
                AND     AL,AL                   ; CHECK AL=0
                JZ      SDG41
                PUSH    BX
                MOV     BL,DH
                SUB     BL,CH
                SUB     BL,AL
                INC     BL                      ; LOOP COUNT (BL=DH-CH-AL+1)
                MOV     BH,DL
                SUB     BH,CL
                INC     BH                      ; TRANSFER LENGTH (BH=DL-CL+1)
                PUSH    BX
                MOV     DL,CL
                MOV     CH,DH
                SUB     DH,AL
                MOV     BH,AL                   ; SAVE AL
                POP     AX
                XCHG    AH,AL
SDG42:
                CALL    TRAN_UP_GRAPH400
                DEC     CH
                DEC     DH
                DEC     BL
                JNZ     SDG42
                POP     CX
                INC     DH
                CALL    FILL_UP_GRAPH400
                POP     DX
                POP     CX
                POP     BX
                RET
SDG41:
                JMP     SUG41
SCROLL_DOWN_GR400 ENDP
;
;*********************************************************************
;*
;*      READ_AC_TEXT
;*
;*              READ ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*              OUT: AL = CHARACTER
;*
;*                   AH = ATTRIBUTE
;*
;*********************************************************************
;
READ_AC_TEXT    PROC
                PUSH    BX
                PUSH    DX
                PUSH    DS
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                SHR     BX,1
                MOV     BH,BL
                CALL    CNV_VRAM_TEXT
                MOV     BX,DX
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[BX]
                MOV     AH,DS:[BX+ATTRIBUTE_OFFSET]
                POP     DS
                POP     DX
                POP     BX
                RET
READ_AC_TEXT    ENDP
;
;*********************************************************************
;*
;*      READ_AC_GR200
;*
;*              READ ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*              OUT: AL = CHARACTER
;*
;*********************************************************************
;
READ_AC_GR200   PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                CMP     BH,DRAW_PAGE
                JZ      RAG20
                MOV     AL,BH
                CALL    SET_BANK
RAG20:
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                CALL    SEARCH_FONT200
                MOV     AH,WHITE_ATTR           ; SET WHITE ATTRIBUTE
                POP     DX
                POP     CX
                POP     BX
                RET
READ_AC_GR200   ENDP
;
;*********************************************************************
;*
;*      READ_AC_GR400
;*
;*              READ ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*              OUT: AL = CHARACTER
;*
;*********************************************************************
;
READ_AC_GR400   PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                CMP     BH,DRAW_PAGE
                JZ      RAG40
                MOV     AL,BH
                CALL    SET_BANK
RAG40:
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                CALL    SEARCH_FONT400
                MOV     AH,WHITE_ATTR           ; SET WHITE ATTRIBUTE
                POP     DX
                POP     CX
                POP     BX
                RET
READ_AC_GR400   ENDP
;
;*********************************************************************
;*
;*      WRITE_AC_TEXT
;*
;*              WRITE ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   CX = COUNT OF CHARACTERS
;*
;*                   AL = CHARACTER
;*
;*                   BL = ATTRIBUTE
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
WRITE_AC_TEXT   PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                MOV     AH,BL
                MOV     BP,AX                   ; SAVE ATTR./CHAR.
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                SHR     BX,1
                MOV     BH,BL
                CALL    CNV_VRAM_TEXT
                MOV     BX,DX
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     DS,AX
                MOV     AX,BP
WAT1:
                MOV     DS:[BX],AL
                MOV     DS:[BX+ATTRIBUTE_OFFSET],AH
                INC     BX
                INC     BX
                CMP     ES:CRT_COLS,40
                JNZ     WAT2
                INC     BX
                INC     BX
WAT2:
                LOOP    WAT1
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
WRITE_AC_TEXT   ENDP
;
;*********************************************************************
;*
;*      WRITE_AC_GR200
;*
;*              WRITE ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   CX = COUNT OF CHARACTERS
;*
;*                   AL = CHARACTER
;*
;*                   BL = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
WRITE_AC_GR200  PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    CX
                PUSH    BX
                CLD
                MOV     DL,AL
                CMP     BH,DRAW_PAGE
                JZ      WAG200
                MOV     AL,BH
                CALL    SET_BANK
WAG200:
                MOV     DI,OFFSET CHAR_BUF
                CALL    READ_FONT200
                CMP     CRT_MODE,5
                JZ      WAG20                   ; JUMP IF B/W MODE
                CMP     CRT_MODE,6
                JZ      WAG20                   ; JUMP IF B/W MODE
                MOV     CX,8                    ; SET 8 WORD
                JNC     WAG21
                SHL     CX,1                    ; SET 16 WORD
WAG21:
                MOV     SI,OFFSET CHAR_BUF
                MOV     DI,SI
                ADD     DI,CX
                REP     MOVSW                   ; COPY PLANE 2 & 3
WAG20:
                POP     BX
                MOV     AL,BL
                ROL     AL,1
                ROL     AL,1
                AND     AL,00000011B
                MOV     DOT_MODIFY_MODE,AL      ; SET MOD
                XOR     AX,AX
                MOV     DI,OFFSET CHAR_BUF
                CMP     CRT_MODE,7
                JNZ     WAG260
                                                ; MODE 7
                MOV     DL,3
WAG272:
                SHL     BL,1
                TEST    BL,00001000B
                JNZ     WAG271
                MOV     CX,4
                REP     STOSW
WAG273:
                DEC     DL
                JNZ     WAG272
                JMP     SHORT WAG2E
WAG271:
                ADD     DI,8
                JMP     SHORT WAG273
WAG260:
                CMP     CRT_MODE,6
                JNZ     WAG250
                                                ; MODE 6
                TEST    BL,00000001B
                JNZ     WAG2E
                MOV     CX,4
                REP     STOSW
                JMP     SHORT WAG2E
WAG250:
                CMP     CRT_MODE,5
                JNZ     WAG240
                                                ; MODE 5
                TEST    BL,00000001B
                JNZ     WAG2E
                MOV     CX,8
                REP     STOSW
                JMP     SHORT WAG2E
WAG240:
                                                ; MODE 4
                MOV     DL,3
WAG242:
                SHL     BL,1
                TEST    BL,00001000B
                JNZ     WAG241
                MOV     CX,8
                REP     STOSW
WAG243:
                DEC     DL
                JNZ     WAG242
                JMP     SHORT WAG2E
WAG241:
                ADD     DI,16
                JMP     SHORT WAG243
WAG2E:
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                POP     CX
WAG2F:
                PUSH    CX
                PUSH    DX
                CALL    WRITE_G_CHAR200
                POP     DX
                INC     DL
                POP     CX
                LOOP    WAG2F
                POP     DX
                POP     CX
                POP     BX
                RET
WRITE_AC_GR200  ENDP
;
;*********************************************************************
;*
;*      WRITE_AC_GR400
;*
;*              WRITE ATTRIBUTE/CHARACTER AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   CX = COUNT OF CHARACTERS
;*
;*                   AL = CHARACTER
;*
;*                   BL = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
WRITE_AC_GR400  PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    CX
                PUSH    BX
                CLD
                MOV     DL,AL
                CMP     BH,DRAW_PAGE
                JZ      WAG400
                MOV     AL,BH
                CALL    SET_BANK
WAG400:
                MOV     DI,OFFSET CHAR_BUF
                CALL    READ_FONT400
                CMP     CRT_MODE,8
                JZ      WAG40                   ; JUMP IF B/W MODE
                MOV     CX,16
                MOV     SI,OFFSET CHAR_BUF
                MOV     DI,SI
                ADD     DI,CX
                REP     MOVSW                   ; COPY PLANE 2 & 3
WAG40:
                POP     BX
                MOV     AL,BL
                ROL     AL,1
                ROL     AL,1
                AND     AL,00000011B
                MOV     DOT_MODIFY_MODE,AL      ; SET MOD
                XOR     AX,AX
                MOV     DI,OFFSET CHAR_BUF
                CMP     CRT_MODE,9
                JNZ     WAG480
                                                ; MODE 9
                MOV     DL,3
WAG492:
                SHL     BL,1
                TEST    BL,00001000B
                JNZ     WAG491
                MOV     CX,8
                REP     STOSW
WAG493:
                DEC     DL
                JNZ     WAG492
                JMP     SHORT WAG4E
WAG491:
                ADD     DI,16
                JMP     SHORT WAG493
WAG480:
                                                ; MODE 8
                TEST    BL,00000001B
                JNZ     WAG4E
                MOV     CX,8
                REP     STOSW
WAG4E:
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                POP     CX
WAG4F:
                PUSH    CX
                PUSH    DX
                CALL    WRITE_G_CHAR400
                POP     DX
                INC     DL
                POP     CX
                LOOP    WAG4F
                POP     DX
                POP     CX
                POP     BX
                RET
WRITE_AC_GR400  ENDP
;
;*********************************************************************
;*
;*      WRITE_C_TEXT
;*
;*              WRITE CHARACTER ONLY AT CURRENT CURSOR POSITION
;*
;*
;*              IN:  BH = PAGE NUMBER
;*
;*                   CX = COUNT OF CHARACTERS
;*
;*                   AL = CHARACTER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
WRITE_C_TEXT    PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                MOV     BP,AX                   ; SAVE CHAR.
                MOV     BL,BH
                XOR     BH,BH
                SHL     BX,1
                MOV     DX,CURSOR_POSN[BX]
                SHR     BX,1
                MOV     BH,BL
                CALL    CNV_VRAM_TEXT
                MOV     BX,DX
                MOV     AX,TEXT_VRAM_SEGMENT
                MOV     DS,AX
                MOV     AX,BP
WCT1:
                MOV     DS:[BX],AL
                INC     BX
                INC     BX
                CMP     ES:CRT_COLS,40
                JNZ     WCT2
                INC     BX
                INC     BX
WCT2:
                LOOP    WCT1
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
WRITE_C_TEXT    ENDP
;
;*********************************************************************
;*
;*      SET_PALETTE
;*
;*              SET PALETTE VALUE
;*
;*
;*              IN:  BH = PALETTE NUMBER
;*
;*                   BL = COLOR CODE
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SET_PALETTE     PROC
                CMP     BH,0FFH
                JNZ     SP1
                                                ; SET BORDER COLOR
                IN      AL,SYS_PORT_B
                TEST    AL,08H
                JNZ     SP2
                MOV     AL,BL
                AND     AL,00000111B
                SHL     AL,1
                SHL     AL,1
                SHL     AL,1
                SHL     AL,1
                OUT     BORDER_COLOR_PORT,AL
SP2:
                RET
SP1:
                                                ; SET PALETTE VALUE
                CMP     CRT_MODE,9              ; JUMP IF COLOR MODE
                JZ      SP3
                CMP     CRT_MODE,7
                JZ      SP3
                CMP     CRT_MODE,4
                JZ      SP3
                RET
SP3:
                MOV     AL,BH
                AND     AL,00000111B
                XOR     AH,AH
                SHL     AX,1
                MOV     DI,AX
                MOV     AL,BL
                AND     AL,00000111B
                TEST    BH,1
                JNZ     SPP
                SHL     AL,1
                SHL     AL,1
                SHL     AL,1
                SHL     AL,1
SPP:
                JMP     WORD PTR CS:PAL_SET[DI]
PAL_SET         DW      OFFSET PS0
                DW      OFFSET PS1
                DW      OFFSET PS2
                DW      OFFSET PS3
                DW      OFFSET PS4
                DW      OFFSET PS5
                DW      OFFSET PS6
		DW      OFFSET PS7
PS0:
                MOV     AH,PALETTE01
                AND     AH,0FH
                OR      AL,AH
                MOV     PALETTE01,AL
                OUT     PALETTE_REG01,AL
                RET
PS1:
                MOV     AH,PALETTE01
                AND     AH,0F0H
                OR      AL,AH
                MOV     PALETTE01,AL
                OUT     PALETTE_REG01,AL
                RET
PS2:
                MOV     AH,PALETTE23
                AND     AH,0FH
                OR      AL,AH
                MOV     PALETTE23,AL
                OUT     PALETTE_REG23,AL
                RET
PS3:
                MOV     AH,PALETTE23
                AND     AH,0F0H
                OR      AL,AH
                MOV     PALETTE23,AL
                OUT     PALETTE_REG23,AL
                RET
PS4:
                MOV     AH,PALETTE45
                AND     AH,0FH
                OR      AL,AH
                MOV     PALETTE45,AL
                OUT     PALETTE_REG45,AL
                RET
PS5:
                MOV     AH,PALETTE45
                AND     AH,0F0H
                OR      AL,AH
                MOV     PALETTE45,AL
                OUT     PALETTE_REG45,AL
                RET
PS6:
                MOV     AH,PALETTE67
                AND     AH,0FH
                OR      AL,AH
                MOV     PALETTE67,AL
                OUT     PALETTE_REG67,AL
                RET
PS7:
                MOV     AH,PALETTE67
                AND     AH,0F0H
                OR      AL,AH
                MOV     PALETTE67,AL
                OUT     PALETTE_REG67,AL
                RET
SET_PALETTE     ENDP
;
;*********************************************************************
;*
;*      WRITE_DOT
;*
;*              WRITE DOT
;*
;*
;*              IN:  (CX,DX) = (X,Y)
;*
;*                   AL = PALETTE NUMBER (INCLUDE MOD)
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
;
;       BYTE MODIFY ROUTINE     ( AL <- CL OP AL )
;
MDSUB           DW      MDS0
                DW      MDS1
                DW      MDS2
                DW      MDS3
MDS0:
                RET                             ; REPLACE
MDS1:
                XOR     AL,CL                   ; COMPLEMENT
                RET
MDS2:
                NOT     AL                      ; CLEAR
                AND     AL,CL
                RET
MDS3:
                OR      AL,CL                   ; SET
                RET
WRITE_DOT       PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
                PUSH    AX
		CALL	SET_ACCESS_BANK
		CALL	GDC_COMPLETE
                CALL    CNV_VRAM_GRAPH
                MOV     BL,10000000B
                CMP     CRT_COLS,40
                JNZ     WD3
                MOV     BL,11000000B
WD3:
                SHR     BL,CL                   ; MAKE DOT MASK
                MOV     BH,BL
                NOT     BH                      ; REVERSE DOT MASK
                CMP     CRT_MODE,9              ; JUMP IF COLOR MODE
                JZ      WD_COLOR
                CMP     CRT_MODE,7
                JZ      WD_COLOR
                CMP     CRT_MODE,4
                JZ      WD_COLOR
                                                ; B/W MODE
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                POP     DX
                MOV     CL,DS:[DI]
                XOR     AL,AL
                SHR     DL,1
                SBB     AL,AL
                ROL     DL,1
                ROL     DL,1
                ROL     DL,1
                AND     DL,00000011B
                SHL     DL,1
                XOR     DH,DH
                MOV     SI,DX
                CALL    MDSUB[SI]
                AND     AL,BL
                AND     DS:[DI],BH
                OR      DS:[DI],AL
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
WD_COLOR:                                       ; COLOR MODE
                POP     DX
                MOV     CH,DL
                ROL     DL,1
                ROL     DL,1
                AND     DL,00000011B
                SHL     DL,1
                XOR     DH,DH
                MOV     SI,DX
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     CL,DS:[DI]
;               XOR     AL,AL
                SHR     CH,1
                SBB     AL,AL
                CALL    MDSUB[SI]
                AND     AL,BL
                AND     DS:[DI],BH
                OR      DS:[DI],AL
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     CL,DS:[DI]
;               XOR     AL,AL
                SHR     CH,1
                SBB     AL,AL
                CALL    MDSUB[SI]
                AND     AL,BL
                AND     DS:[DI],BH
                OR      DS:[DI],AL
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     CL,DS:[DI]
;               XOR     AL,AL
                SHR     CH,1
                SBB     AL,AL
                CALL    MDSUB[SI]
                AND     AL,BL
                AND     DS:[DI],BH
                OR      DS:[DI],AL
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
WRITE_DOT       ENDP
;
;*********************************************************************
;*
;*      READ_DOT
;*
;*              READ DOT
;*
;*
;*              IN:  (CX,DX) = (X,Y)
;*
;*              OUT: AL = PALETTE NUMBER
;*
;*********************************************************************
;
READ_DOT        PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    DS
		CALL	SET_ACCESS_BANK
		CALL	GDC_COMPLETE
                CALL    CNV_VRAM_GRAPH
                CMP     CRT_MODE,9              ; JUMP IF COLOR MODE
                JZ      RD_COLOR
                CMP     CRT_MODE,7
                JZ      RD_COLOR
                CMP     CRT_MODE,4
                JZ      RD_COLOR
                                                ; B/W MODE
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[DI]
                INC     CL
                ROL     AL,CL
                AND     AL,1
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
RD_COLOR:                                       ; COLOR MODE
                MOV     AX,PLANE1_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[DI]
                INC     CL
                ROL     AL,CL
                AND     AL,1
                MOV     CH,AL
                MOV     AX,PLANE2_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[DI]
                ROL     AL,CL
                AND     AL,1
                SHL     CH,1
                OR      CH,AL
                MOV     AX,PLANE3_SEGMENT
                MOV     DS,AX
                MOV     AL,DS:[DI]
                ROL     AL,CL
                AND     AL,1
                SHL     CH,1
                OR      AL,CH
                POP     DS
                POP     DX
                POP     CX
                POP     BX
                RET
READ_DOT        ENDP
;
;*********************************************************************
;*
;*      WRITE_TTY
;*
;*              WRITE TELETYPE
;*
;*
;*              IN:  AL = CHARACTER
;*
;*                   BL = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
WRITE_TTY       PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    AX
                MOV     BH,ACTIVE_PAGE
                CALL    GET_CURSOR
                CMP     AL,8                    ; BACK_SPACE
                JE      U8
                CMP     AL,0DH                  ; CR
                JE      U9
                CMP     AL,0AH                  ; LF
                JE      U10
                CMP     AL,07H                  ; BELL
                JE      U11
                MOV     CX,1
                MOV     SI,CRT_ENTRY
                CALL    DISPATCH_TABLE[SI+10*2] ; CALL WRITE_C
                INC     DL
                CMP     DL,CRT_COLS
                JNZ     U7
                XOR     DL,DL
                CMP     DH,24
                JNZ     U6
U1:
                CALL    SET_CURSOR
                CMP     CRT_MODE,4
                JC      U2
                XOR     BH,BH
                JMP     SHORT U3
U2:
                CALL    READ_AC_TEXT
                MOV     BH,AH
U3:
                MOV     AL,1
                XOR     CX,CX
                MOV     DH,24
                MOV     DL,CRT_COLS
                DEC     DL
                MOV     SI,CRT_ENTRY
                CALL    DISPATCH_TABLE[SI+6*2]  ; CALL SCROOL_UP
U5:
                POP     AX
                POP     DX
                POP     CX
                POP     BX
                RET
U6:
                INC     DH
U7:
                CALL    SET_CURSOR
                JMP     SHORT U5
U8:                                             ; BS
                AND     DL,DL
                JNZ     U12
                AND     DH,DH
                JZ      U7
                DEC     DH
                MOV     DL,CRT_COLS
U12:
                DEC     DL
                JMP     SHORT U7
U9:                                             ; CR
                XOR     DL,DL
                JMP     SHORT U7
U10:                                            ; LF
                CMP     DH,24
                JNE     U6
                JMP     SHORT U1
U11:                                            ; BELL
                MOV     AL,06H
                OUT     SYS_PORT_C,AL
                MOV     CX,8000H                ; WAIT
                LOOP    $
                MOV     AL,07H
                OUT     SYS_PORT_C,AL
                JMP     SHORT U5
WRITE_TTY       ENDP
;
;*********************************************************************
;*
;*      GET_MODE
;*
;*              GET CURRENT CRT MODE
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: AL = CRT MODE
;*
;*                   AH = NUMBER OF CHARACTER COLUMNS ON SCREEN
;*
;*                   BH = CURRENT ACTIVE DISPLAY PAGE
;*
;*********************************************************************
;
GET_MODE        PROC
                MOV     AL,CRT_MODE
                MOV     AH,CRT_COLS
                MOV     BH,ACTIVE_PAGE
                RET
GET_MODE        ENDP
;
;*********************************************************************
;*
;*      SET_DRAW_MODE
;*
;*              SET DRAWING MODE ON GDC
;*
;*
;*              IN:  AL = 0 : FLASH
;*                      = 1 : FLASHLESS
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SET_DRAW_MODE   PROC
                MOV     AH,AL
SDM1:
                IN      AL,GRAPH_GDC_PAR        ; CHECK FIFO EMPTY & V_SYNC
                XOR     AL,24H
                TEST    AL,24H
                JNZ     SDM1
                MOV     AL,SYNC                 ; SEND SYNC COMMAND
                OUT     GRAPH_GDC_COM,AL
                MOV     AL,16H                  ; FLASHLESS
                AND     AH,AH
                JNZ     SDM2
                MOV     AL,06H                  ; FLASH
SDM2:
                OUT     GRAPH_GDC_PAR,AL
                RET
SET_DRAW_MODE   ENDP
;
;*********************************************************************
;*
;*      SET_DRAW_PAGE
;*
;*              SET DRAWING PAGE
;*
;*
;*              IN:  AL = PAGE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
SET_DRAW_PAGE   PROC
		MOV	DRAW_PAGE_SETTING,AL
                RET
SET_DRAW_PAGE   ENDP
ROM             ENDS
                END
