	page
;
;	Common subroutins for BACKUP.ASM and RESTORE.ASM
;
;****************************************
;*   PATH DIRECTORY PARENT REMOVE	*
;****************************************
;	<INPUT>  :  DI = DIRECTORY PATH NAME POINTER
;
PATH_DIR_PAIR:
	PUSH	DI
	PUSH	AX
	CALL	SKIP_ZERO
DIR_PAIR_00:
	DEC	DI			; di point to ASCIZ last chr.
	CMP	BYTE PTR [DI],'\'	; check path delimiter \
	JZ	DIR_PAIR_10
	MOV	BYTE PTR [DI],0		; clear last chr. by null
	JMP	SHORT DIR_PAIR_00

DIR_PAIR_10:
	CMP	BYTE PTR [DI-1],':'	; CHECK DRIVE DELIMITER
	JZ	DIR_PAIR_20		; SPECIFIED ROOT PATH
	MOV	BYTE PTR [DI],0		; set ASCIZ 0
DIR_PAIR_20:
	POP	AX
	POP	DI
	RET
;************************
;*   FILE OF PATH PICK  *
;************************
;	<INPUT>  : DI  = PATH NAME POINTER
;
FILE_PICK:
	CALL	SKIP_ZERO
FILE_PICK_00:
	CMP	BYTE PTR [DI],'\'	; check path delimiter \
	JZ	FILE_PICK_10
	DEC	DI
	JMP	SHORT FILE_PICK_00	; 

FILE_PICK_10:
	INC	DI			; di point to lowest path name
	RET
;************************
;*    FILE NAME CHECK	*
;************************
;		compare filename string 
; <input > : si = filename from path string using ASCIZ 0
;            di = filename from path string using ASCIZ 0 or
;                 searched string
; <output> : Z flag on if same filename

FILE_NAME_CHECK:
	PUSH	AX
	PUSH	SI			; source path
	PUSH	DI			; destination path
FILE_CK_10:
	MOV	AL,[SI]
	CALL	TOUPPER			; CONVERT UPPER CASE
	CMP	AL,0			; check ASCIZ 0
	JZ	FILE_CK_20
	MOV	AH,AL			;
	MOV	AL,[DI]			;
	CALL	TOUPPER			; CONVERT UPPER CASE
	CMP	AH,AL  			; check si = di
	JNZ	FILE_CK_RET		; different si from di
	INC	SI
	INC	DI
	JMP	SHORT FILE_CK_10	; compare to next chr.

FILE_CK_20:
	MOV	AL,[DI]
	CMP	AL,0			; check ASCIZ 0 di too
	JZ	FILE_CK_RET
	CMP	AL,20H			; check space
FILE_CK_RET:
	POP	DI
	POP	SI
	POP	AX
	RET
;************************
;*   SKIP ZERO		*
;************************
;	<INPUT>  :  DI = CHARACTER POINTER
;
SKIP_ZERO:
SKIP_Z10:
	CMP	BYTE PTR [DI],0		; check ASCIZ 0
	JE	SKIP_Z20		;
	INC	DI			;
	JMP	SHORT SKIP_Z10		; check next chr.

SKIP_Z20:				;
	RET				;
;************************
;*   ASCIZ TRANSLATE	*
;************************
; <input > : si = source pointer of ASCIZ string
;            di = destination pointer

TRANS_ASCIZ:
	PUSH	AX			;
TRANS_10:
	LODSB				;
	CMP	AL,0			; check ASCIZ 0
	JE	TRANS_20		;
	STOSB				;
	JMP	SHORT TRANS_10		;

TRANS_20:
	MOV	[DI],AL			; set ASCIZ 0 to destination
	POP	AX			;
	RET				;
;************************
;*   DIR PATH SET	*
;************************
;	<INPUT>  : DI = PATH NAME POINTER
;
PATH_DIR_CHECK:
	PUSH	AX			;
	PUSH	DI			;
	MOV	CX,128			;
	REP	MOVSB			;
;
	POP	DI			;
	CALL	SKIP_ZERO		;
DEST_DIR_10:
	DEC	DI			;
	CMP	BYTE PTR [DI],'\'	; check path delimiter \
	JZ	DEST_DIR_20		;
	MOV	BYTE PTR [DI],0		; SET ZERO TO DEST DIR PATH
	JMP	SHORT DEST_DIR_10

DEST_DIR_20:
	DEC	DI			;
	CMP	BYTE PTR [DI],':'	; check drive delimiter :
	JZ	DEST_DIR_30		;
	INC	DI			; [di] = \
	MOV	BYTE PTR [DI],0		; set ASCIZ 0 instead of \
DEST_DIR_30:
	POP	AX			;
	RET				;
;********************************
;*   BINARY --> ASCII CONVERT	*
;********************************
;	<INPUT>  : AX  = BINARY DATA
;		 : SI  = ASCII DATA ADDRES
;
BINASCII:
	PUSH	SI			;
	PUSH	AX			;
	PUSH	BX			;
;
	MOV	BL,10			;
	DIV	BL			;
	OR	AL,30H			;
	MOV	[SI],AL			; 10 DEGIT SET
	INC	SI			;
	OR	AH,30H			;
	MOV	[SI],AH			; 1 DEGIT SET
;
	POP	BX			;
	POP	AX			;
	POP	SI			;
	RET				;
