****	SORT -- Sort Array of Strings
**
**	Function:
**		SORT sorts the set of fixed length records according to
**		the control information in the Sort Specification Block (SSB)
**		pointed to by D1.
**	Inputs:  D1.L points to SSB
**	Outputs:  -none-  (records sorted)
**	Registers affected:  -none-
**	Routines called:  compare routine (SSB)
**	Special Error Conditions:  -none-
**
**	SSB Format:
**
**		Long: starting address of first record
**		Word: number of records to sort
**		Word: Size of each record
**		Long: Address of compare routine
**		Long: -reserved-
*
	.globl	sort
	.globl	cmpa12
	.text
sort:
	movem.l	d0-d7/a0-a6,-(a7)	* save registers
	move.l	d1,a1		* ptr to ssb
	move.l	(a1),a2		* start of records
	move	4(a1),d6	* number of records
	cmpi	#1,d6
	ble	sortx		* if .le. 1 record
	mulu	6(a1),d6	* lba+1; inner loop limit
	add.l	a2,d6
	move.l	d6,a5
	sub	6(a1),a5	* (lba+1)-recsize
	move.l	a5,d5		* outer loop limit
*	begin inner loop
sort1:	move.l	a2,a3
	add	6(a1),a3
*	compare
sort2:	move.l	8(a1),a6	* compare routine
	jsr	(a6)
	ble	sort4		* no need to swap
*	swap entries
	move.l	a2,a5		* item 1
	move.l	a3,a6		* item 2
	move	6(a1),d3	* length in bytes
	subq	#1,d3
sort3:	move.b	(a5),d4		* swap bytes
	move.b	(a6),(a5)+
	move.b	d4,(a6)+
	dbra	d3,sort3	* loop for all of entry
*	end of inner loop
sort4:	add	6(a1),a3
	cmpa.l	d6,a3
	blt	sort2
*	end of outer loop
	add	6(a1),a2
	cmpa.l	d5,a2
	blt	sort1
*
sortx:	movem.l	(a7)+,d0-d7/a0-a6
	rts
*
***	cmpa12 -- compare 12 bytes ascending (on word boundary)
*
cmpa12:
	movem.l	d2/a2-a3,-(a7)	* save registers
	cmpm.l	(a3)+,(a2)+
	bne	cmpx		* not equal
	cmpm.l	(a3)+,(a2)+
	bne	cmpx		* not equal
	cmpm.l	(a3)+,(a2)+
cmpx:	movem.l	(a7)+,d2/a2-a3
	rts
*
	.end
