****	OPTSET -- option set
**
**	Function:
**		Set options in option table according to options in command
**		line.  Terminate at first delimiter (i.e. not A-Z)
**	Inputs:	D0.l == pointer to first option
**		D1.l == pointer to table
**	Outputs: D0.l == pointer to delimiter
**	Registers affected:  D0.l, (table)
**	Routines called: -none-
**	Special error conditions: D1.l=0 indicates error, then D0.l points
**		to invalid option.
**
**	Option table format:  The options table consists of a series of
**		byte pairs as "option letter, occurance value".
**		i.e.
**			.dc.b	'A',0
**			.dc.b	'B',0
**			etc,
**			.dc.b	0,0	* terminator
**
**		If an option is encountered, the least-significant bit of the
**		occurance value is *TOGGLED*.
**
*
	.globl	optset
	.text
optset:
	movem.l	d1/a0-a1,-(a7)
	move.l	d0,a0
*
optst1:	move.b	(a0),d2		* get option
	cmpi.b	#'A',d2
	blt	optstx		* delimiter
	cmpi.b	#'Z',d2
	bgt	optstx		* delimiter
	move.l	d1,a1		* table pointer
optst2:	tst.b	(a1)
	bne	optst3		* if not end of table
	clr.l	d1		* bad option
	bra	optstx
*
optst3:	cmp.b	(a1),d2
	beq	optst4		* bingo!
	addq.l	#2,a1
	bra	optst2		* keep looking
optst4:	addq.l	#1,a1
	eori.b	#1,(a1)		* toggle value
*
	addq.l	#1,a0		* go to next character in line
	bra	optst1
*
optstx:	move.l	a0,d0		* pointer to err or delimiter
	movem.l	(a7)+,d2/a0-a1
	rts
*
	.end
