****	MD5DC -- convert binary value to decimal string
**
**	Function:
**		Store the contents of D1.W as 5 decimal characters in memory
**		location (5 bytes) pointed to by D0.L
**	Inputs:  D0.L == pointer to 5-byte buffer
**		 D1.W == value to convert
**	Outputs: D0.L == pointer to byte following buffer
**	Registers affected: D0.L
**	Routines called:  -none-
**	Special error conditions:  -none-
*
	.globl	md5dc
	.text
md5dc:
	movem.l	d1-d2/a1,-(a7)	* save registers
	move.l	d0,a1
	addq	#5,a1
	moveq	#4,d2
md5dc1:	ext.l	d1		* clear upper
	divu	#10,d1		* get last digit
	swap	d1
	add	#$30,d1		* convert to ascii
	move.b	d1,-(a1)	* and store
	swap	d1
	dbra	d2,md5dc1	* loop for 5 digits
*
	moveq	#3,d2		* get rid of leading zeros
md5dc2:	move.b	(a1),d1
	cmpi.b	#$30,d1
	bne	md5dc3		* if not ZERO
	move.b	#$20,(a1)+	* change to blank
	dbra	d2,md5dc2
*
md5dc3:	addq	#5,d0
	movem.l	(a7)+,d1-d2/a1
	rts
*
	.end
