****	makefcb -- make file control block
**
**	Function:
**		Convert text string into FCB.
**	Inputs:  D0.l == pointer to text string
**		 D1.l == pointer to FCB
**	Outputs: D0.l == points to delimiter after file name
**	Registers affected: D0.l, D1.l (if error), (FCB buffer)
**	Routines called: CAPS
**	Special error conditions: D1.l=0 implies error, then D0.l
**		points to bad character.
*
**			last mod: 14feb85 jmk /fix eol check/
*
*
	.globl	makefcb
	.globl	caps
	.text
makefcb:
	movem.l	a0-a2,-(a7)
	move.l	d1,a2
	move.l	d1,a1
	move.l	d0,a0
	moveq	#7,d0
mkf1:	clr	(a1)+		* clear FCB
	dbra	d0,mkf1
	move.l	d1,a1
	move.l	#'    ',(a1)
	move.l	#'    ',4(a1)
	move.l	#'    ',8(a1)
	clr.b	(a1)
*
	cmpi.b	#':',1(a0)
	bne	mkf3		* if not disk drive #
	move.b	(a0),d1		* get drive letter
	jsr	caps
	subi.b	#$40,d1		* convert to drive # (1-16)
	move.b	d1,(a1)
	addq.l	#2,a0
	cmpi.b	#' ',(a0)
	bgt	mkf3		* more to file name
	addq	#1,a0		* ptr to after delimiter
	addq	#1,a1		* ptr to name in FCB
	move	#10,d1		* special case of 'd:' with
mkf2:	move.b	#'?',(a1)+	* no file name, must fill FCB
	dbra	d1,mkf2		* with '?' wild cards
	bra	mkx
*
mkf3:	addq.l	#1,a1		* start of file name
	moveq	#7,d0
mkf4:	move.b	(a0)+,d1	* get char. of name
	jsr	caps
	cmpi.b	#'0',d1
	blt	mkf5		* if delimiter
mkf4x:	move.b	d1,(a1)+
	dbra	d0,mkf4		* pick up to 8 chars.
	move.b	(a0)+,d1
	bra	mkf6		* better be . or delimiter
*
mkf5:	cmpi.b	#'*',d1
	beq	mkf7		* wild card
	cmpi.b	#'?',d1
	beq	mkf4x		* treat ? as part of name
mkf6:	cmpi.b	#'.',d1
	beq	mkf8		* end of fname
	cmpi.b	#' ',d1
	bgt	mkerr		* to many chars in fname
	bra	mkx		* finished
*
mkf7:				* found '*' wild card
	move.b	#'?',(a1)+	* file name with ? chars
	dbra	d0,mkf7
	move.b	(a0)+,d1
	bra	mkf6		* better be . or delimiter
*
mkf8:	move.l	a2,a1		* now for file type
	add	#9,a1		* point to extension in fcb
	moveq	#2,d0
mkf9:	move.b	(a0)+,d1	* get char
	jsr	caps
	cmpi.b	#'0',d1
	blt	mkf10		* if delimiter of some type
mkf9x:	move.b	d1,(a1)+
	dbra	d0,mkf9		* loop for up to 3 chars
mkf9y:	move.b	(a0)+,d1
	cmpi.b	#' ',d1
	bgt	mkerr		* extension too long
	bra	mkx
*
mkf10:	cmpi.b	#'?',d1
	beq	mkf9x		* treat ? as part of type
	cmpi.b	#'*',d1
	bne	mkf12		* if not wild card
mkf11:	move.b	#'?',(a1)+	* fill with '?'
	dbra	d0,mkf11
	bra	mkf9y		* better end here
*
mkf12:	cmpi.b	#0,d1
	beq	mkx		* if end of cmd line
	cmpi.b	#' ',d1
	beq	mkx		* the end
*
mkerr:	clr.l	d1		* indicate error
	bra	mkx1
*
mkx:	move.l	a2,d1		* normal exit
mkx1:	subq	#1,a0
	move.l	a0,d0
	movem.l	(a7)+,a0-a2
	rts
*
	.end
