;
;
;** LABEL REFERENCE LIST PRINT OUT TO CONSOLE **
;THIS ROUTINE IS ESPECIAL FOR AX68K.COM .
;
;
;
;SYMBOL DEFINITION LIBRARY
;
	DEL3	EQU	0
	DEL4	EQU	';'
	CR	EQU	0DH
	SPACE	EQU	20H
	TAB	EQU	9
	LF	EQU	0AH
	EOF	EQU	1AH
;
;TERMINATER
;
TERM1	EQU	CR
TERM2	EQU	0FFH ;END
TERM3	EQU	0FEH ;INDEX
;
;DATA BUFFER AREA DEFINITION
;
CBASE	EQU	6	;CP/M TPA END ADDR.POINTER
;
;FDOS USE
;
;SYSTEM CALL COMMANDS
;
REBOOT	EQU	0	;CP/M RE-BOOT
BDOS	EQU	5
FCB	EQU	5CH	;FILE CONTROL BLOCK ADDR.
SETDMA	EQU	26
OPEN	EQU	15
READS	EQU	20	;SEQUENTIAL READ
WRITES	EQU	21	;SEQUENTIAL WRITE
CLOSE	EQU	16
MAKE	EQU	22
DELETE	EQU	19
LIST	EQU	5
CONOUT	EQU	2
;
;
;
;CONSOLE LINE LENTGTH DEFINITION
;
;
LLENGTH	EQU	80
;
;
;
;BUFFER AREA DEFINITION
;
;
;
LABTOP	EQU	3D2FH	;THIS ADDRESS IS PECULIAR TO THIS AX68K.COM
;IF REWRITED THE AX68K,THEN REWRITE THIS ADDRESS.
;(REFER SLIST.DOC)
;
;
;
;
;MAIN
;
	ORG	100H
;
LABELP:	LXI	H,BEGMES
	CALL	MESSAGE
	XRA	A
	STA	PCOUNT	;CLEAR PRINT COUNT
	MVI	A,'A'
	STA	SCHAR1	;SEARCH CHARACTER 1
LABELP1: MVI	A,'0'
	STA	SCHAR2	;SEARCH CHARACTER 2
	XRA	A
	STA	LEXIST	;CLEAR LABEL EXIST STATUS
LABELP2: CALL	SRCPRN	;SEARCH AND PRINT
	LDA	SCHAR2
	INR	A
	STA	SCHAR2
	CPI	'9'+1
	JC	LABELP2
	MVI	A,'A'
	STA	SCHAR2
LABELP3: CALL	SRCPRN
	LDA	SCHAR2
	INR	A
	STA	SCHAR2
	CPI	'Z'+1
	JC	LABELP3
	MVI	A,'_'
	STA	SCHAR2
	CALL	SRCPRN	;SEARCH AND PRINT
	LDA	LEXIST
	ORA	A	;LABEL EXSISTED ?
	JZ	LABELP6	;NO
	CALL	PCRLF
	CALL	PCRLF
LABELP6: LDA	SCHAR1
	INR	A
	STA	SCHAR1
	CPI	'Z'+1
	JC	LABELP1
	LXI	H,ENDMES
	CALL	MESSAGE
	JMP	REBOOT
;
;
;SR. SEARCH AND PRINT OUT
;
;CHARACTER IN DE REGISTER SEARCH.
;SWEEP ALL HASH BLOCK.
;
SRCPRN:	MVI	B,0	;HASH BLOCK NUMBER
SRCPRN1: CALL	BLKPRN	;SEARCH A BLOCK AND PRINT OUT
	INR	B
	MOV	A,B
	CPI	32
	JC	SRCPRN1
	RET
;
;
;SR. BLKPRN
;SEARCH A BLOCK (B) AND PRINT OUT
;
;
BLKPRN:	PUSH	B
	MOV	A,B
	ADD	A
	MOV	B,A
	MVI	C,0	;BC=(HASH NUMBER)*512
	LXI	H,LABTOP
	DAD	B	;HL=BLOCK TOP ADDRESS
	XCHG
BLKPR0:	LDAX	D
	CPI	TERM2	;END MARK ?
	JNZ	BLKPR1	;NO
	POP	B
	RET
;
BLKPR1:	CPI	TERM3	;INDEX ?
	JNZ	BLKPR2
	INX	D
	XCHG
;GET INDEXED LINK ADDRESS
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A	;NOW, HL=INDEXED ADDRESS
	XCHG
	JMP	BLKPR0
;
;EXAMINE LABEL 1 WORD
;
BLKPR2:	CALL	EXLAB	;EXAMINE LABEL
	JC	BLKPR0	;NOT HIT
	MVI	A,0FFH
	STA	LEXIST	;LABEL HAS EXSISTED
	CALL	LABP	;LABEL PRINT
	JMP	BLKPR0
;
;
;SR. EXLAB
;EXAMINE LABEL WORD
;COMPARE THE FIRST CHARACTER OF LABEL WITH SCHAR1
;AND SECOND WITH SCHAR2.
;
;IF HIT ,THEN CY=0
;ELSE CY=1
;
;IF ONLY SINGLE CHARACTER LABEL,
;THEN IT HIT TO SCHAR2=21H.
;
;
EXLAB:	PUSH	D
	LHLD	SCHAR1
	LDAX	D
	INX	D
	ORA	A	;DEL3 ?
	JZ	EXLAB3	;YES
	CMP	L
	JNZ	EXLAB3	;NOT HIT
	LDAX	D
	ORA	A	;DEL3 ?
	JZ	EXLAB2	;YES
	CMP	H
	JNZ	EXLAB3	;NOT HIT
;
;HIT
;
	POP	D
	RET	;CY=0
;
EXLAB2:	MOV	A,H
	CPI	21H
	JNZ	EXLAB3
	POP	D
	RET	;HIT , CY=0
;
;NOT HIT
;
EXLAB3:	POP	D
EXLAB4:	LDAX	D
	INX	D
	ORA	A	;DEL3 ?
	JNZ	EXLAB4	;NO
	INX	D
	INX	D
	INX	D
	INX	D	;SKIP DATA PART
	STC
	RET	;CY=1
;
;
;
;LABEL WORD PRINT
;
;
LABP:	LXI	H,LINBUF ;LINE BUFFER
	LDA	PCOUNT	;PRINT COUNTS
	MOV	B,A
LABP1:	LDAX	D
	INX	D
	ORA	A	;DEL3 ?
	JZ	LABP3
	MOV	M,A
	INX	H
	INR	B
	JMP	LABP1
;
LABP3:	MOV	A,B
	ANI	0F8H
	ADI	8	;TAB COUNTS COMPENSATION
	ADI	16	;NEXT DATA COUNTS
	STA	PCOUNT
	CPI	LLENGTH-24	;LINE LENGTH OF CONSOLE-24
	JC	LABP4
	CALL	PCRLF	;PRINT CR/LF
LABP4:	MVI	M,TAB
	INX	H
	CALL	QHAT	;NEXT DATA PART TRANSLATE TO ASCII
	MVI	M,SPACE
	INX	H
	CALL	QHAT
	MVI	M,TAB
	INX	H
	MVI	M,0
;
	LXI	H,LINBUF
	CALL	MESSAGE
	RET
;
;2 BYTES DATA TO ASCII 4 CHAR.
;
QHAT:	CALL	DHAT2	;1 BYTE TRANS.
	CALL	DHAT2
	RET
;
;
;PRINT MESSAGE TO CONSOLE
;
;FROM (HL)~ UNTIL HIT 0H
;BC,DE CONSERVED
;
MESSAGE:	PUSH	D
	PUSH	B
MSG1:	MOV	A,M
	ORA	A
	JZ	MSG2
	INX	H
	PUSH	H
	MOV	E,A
	MVI	C,CONOUT
	CALL	BDOS
	POP	H
	JMP	MSG1
;
MSG2:	POP	B
	POP	D
	RET
;
;
;CR/LF
;
PCRLF:	PUSH	H
	PUSH	D
	PUSH	B
	XRA	A
	STA	PCOUNT	;RESET PCOUNT
	MVI	E,CR
	MVI	C,CONOUT
	CALL	BDOS
	MVI	E,LF
	MVI	C,CONOUT
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
;
;
;DHAT HEX TO ASCII TRANS.(DOUBLE)
;
DHAT2:	LDAX	D
	INX	D
DHAT:	PUSH	A
	RAR!RAR!RAR!RAR
	CALL	HAT
	POP	A
HAT:	ANI	0FH
	CPI	0AH
	JC	HAT1
	ADI	7
HAT1:	ADI	30H
	MOV	M,A
	INX	H
	RET
;
;MEESAGES
;
BEGMES:	DB 'SYMBOL TABLE LIST',CR,LF,CR,LF,0
;
ENDMES:	DB CR,LF,CR,LF,CR,LF
	DB 'SYMBOL REFERENCE END.',CR,LF,0
;
;
;PRINT COUNTS
;
PCOUNT:	DS	1
LEXIST:	DS	1
SCHAR1:	DS	1
SCHAR2:	DS	1
;
;LINE BUFFER
;
LINBUF:	DS	256
;
END
