	TITLE	RS232C
	PAGE	60,132
;-------------------------------------------------------;
;   RS232_BIO			       			;
;				       			;
;	REV.   13 (08/07/83 : 8MHZ SUPPORT)		;
;				       			;
;-------------------------------------------------------;

;NOV./16/1983		; USING SYSCOM.LIB
;NOV/16/83
;DEC/08/83		; DEBUG
;DEC/13/83		;
;MAR/22/84		; DELETE CODE

;********************************************************
;*		EQUATE AREA				*
;********************************************************
;
;-----------------------------------------------------INSERT 1983/11/8-
;*
;**	I/O PORT ADDRESS
;*
RS_STA		EQU	32H
RS_DATA		EQU	30H
RS_CMD		EQU	32H
RS_MOD		EQU	32H
INTM_O1		EQU	02H		;--------DEC/8/83-------
INTM_O2		EQU	00H		;---------DEC/8/83-------
TIMER2		EQU	75H
TIM_CTL		EQU	77H
PORTB		EQU	33H
PORTC		EQU	35H
SYS_PORT	EQU	37H
EOI		EQU	20H
;
;-----------------------------------------------------INSERT END-------
;*
;**	COMMAND OF 8251 OR 8253
;*
RS_CMD_IR	EQU	40H	; INTERNAL RESET
RS_CMD_RXE	EQU	04H	; RECEIVER ENABLE	
RS_RXR_E	EQU	01H	; PORT-C SIGNAL (RXRDY_INT ENABLE)
RS_RXR_D	EQU	00H	; 		(RXRDY_INT DISABLE)
RS_TIM_MOD	EQU	0B6H	; CONTROL CODE FOR 8253
RS_STS_TXR	EQU	01H	; TRANSMITTER READY (BIT)
RS_C8M		EQU	80H	; 8MHZ CLOCK
;*
;*	ASCII CODE (CONTROL CHARACTER)
;*
RS_XON		EQU	11H	; DC1 (CTRL-Q)
RS_XOFF		EQU	13H	; DC3 (CTRL-S)
RS_SI		EQU	0FH	; SHIFT IN  CODE
RS_SO		EQU	0EH	; SHIFT OUT CODE

		PAGE
;************************************************
;*						*
;*		OTHOR SEGMENT			*
;*						*
;************************************************

;****************************************
;*	INTERRUPT VECTOR		*
;****************************************
INT_VEC		SEGMENT	AT 0000H
INT_VEC		ENDS
;****************************************
;*	USER PARAMETER SEGMENT		*
;*		This is dummy segment	*
;*		for assemble		*
;****************************************
USER		SEGMENT	AT 0060H
;
;
;  BUFFER CONTROL BLOCK	        
;

RSB_FLAG	EQU	BYTE PTR 0	; CONTROL FLAGS
RSB_CMDS	EQU	BYTE PTR 1	; COMMAND BYTE SAVE AREA
RSB_STIM	EQU	BYTE PTR 2	; TIME OUT (SEND)
RSB_RTIM	EQU	BYTE PTR 3	; TIME OUT (RECEIVE)
RSB_XON		EQU	WORD PTR 4	; XON  VALUE (3/4 BUFF SIZE)
RSB_XOFF	EQU	WORD PTR 6	; XOFF VALUE (1/4 BUFF SIZE)
RSB_HEAD	EQU	WORD PTR 8	; BUFFER HEAD POINTER
RSB_TAIL	EQU	WORD PTR 10	; BUFFER TAIL POINTER
RSB_CNT		EQU	WORD PTR 12	; DATA COUNT
RSB_PUTP	EQU	WORD PTR 14	; DATA PUT POINTER
RSB_GETP	EQU	WORD PTR 16	; DATA GET POINTER
;
RSB_OFST	EQU	20-2	; BUFFER AREA OFFSET
USER		ENDS
;****************************************
;*	C-MOS SEGMENT			*
;****************************************
CMOS		SEGMENT	AT 0A3FEH
		ORG	2*4+2
MEMORY_SW3	LABEL	BYTE
CMOS		ENDS
;
INCLUDE		B:SYSCOM.LIB
;
		PAGE
ROM 	SEGMENT	WORD PUBLIC
	ASSUME	CS:ROM ,DS:SYSCOM,ES:USER,SS:USER
;********************************
;*	PUBLIC LABEL		*
;********************************
	PUBLIC	RS232C_IO	; ROM ENTRY
	PUBLIC	RS232C_INT	; DATA RECEIVE INTERRUPT--DEC/8/83-
;********************************************************
;*							*
;*		DEFINE CONSTANT	(TABLE)			*
;*							*
;********************************************************
;
;------- TIMER COUNTER -------BPS	(X16)	(X64)
;
;	FOR 5MHZ CLOCK
;
RS_CNTTBL16	DW	0800H	;	75
		DW	0400H	;	150
RS_CNTTBL64	DW	0200H	;	300	75
		DW	0100H	;	600	150
		DW	0080H	;	1200	300
		DW	0040H	;	2400	600
		DW	0020H	;	4800	1200
		DW	0010H	;	9600	2400
		DW	0008H	;		4800
		DW	0	;		-----

;	FOR 8MHZ CLOCK----------;		
;
RS_CNTTBL16_8	DW	0680H	;	75
		DW	0340H	;	150
RS_CNTTBL64_8	DW	01A0H	;	300	75
		DW	00D0H	;	600	150
		DW	0068H	;	1200	300
		DW	0034H	;	2400	600
		DW	001AH	;	4800	1200
		DW	000DH	;	9600	2400
		DW	0	;		-----
		DW	0	;		-----

 
;   COMMAND SUBROUTINE ADDRESS TABLE
 
RS_CMD_TBL	DW	RS_INIT1	; INITIALIZE 1
		DW	RS_INIT2	;	     2 (XON/XOFF ENABLE)
		DW	RS_GTDTL	; GET DATA LENGTH
		DW	RS_SEND		; SEND THE CHARACTER
		DW	RS_RECV		; RECEIVE THE CHARACTER
		DW	RS_OUTC		; COMMAND OUT
		DW	RS_STAT		; READ STATUS
	PAGE
;****************************************************************
;   COMMAND ENTRY						*
;	ENTRY: (AH)= COMMAND					*
;	EXIT : (AH)= RETURN CODE				*
;		   	00 - NORMAL END				*
;		 	01 - PORT NOT INITIALIZED		*
;			02 - COMMUNICATION BUFFER OVERFLOW	*
;			03 - TIME OUT				*
;****************************************************************

RS232C_IO:
	STI			; ENABLE INTERRUPT
	PUSH	ES
	PUSH    DS
	PUSH	DI
	PUSH    SI
	PUSH	BX
	PUSH	DX
;
	TEST	AH,80H		;--------INS MAR/22/84----
	JNZ	RS_NOP		;--------INS MAR/22/84----
	CMP	AH,07H		; CHECK COMMAND
	JNB	RS_NOP		; ILLEGAL
;
;---------------------------------------------------------
;	SET SEGMENT REGISTER
;		ENTRY
;			ES:DI=USER BUFFER
;			DS:  =SYSTEM WORK SEGMENT
;
;		PROGRAM
;			DS:DI=USER BUFFER
;			ES:  =SYSTEM WORK SEGMENT
;
;---------------------------------------------------------
	ASSUME	DS:SYSCOM,ES:USER
	MOV	SI,SYSCOM
	MOV	DS,SI
	CMP	AH,02H		; CMD = INITIALIZE ?
	JNB	PS_P1		; NO

	MOV	[RS_OFST_ADR+0],DI
	MOV	[RS_OFST_ADR+2],ES
PS_P1:
	MOV	ES,SI
	LDS	DI,DWORD PTR [RS_OFST_ADR]
;
	MOV	SI,DS
	OR	SI,DI			; COM_BUFFER ADDRESS = 0:0 ?
	JZ	RS_NI			; Y
;
	ASSUME	DS:USER,ES:SYSCOM
;
	ADD	DI,2
	CMP	AH,2			; GET DATA LENGTH ?
	JE	RS_P2
	CMP	AH,3			; READ ?
	JE	RS_P2
	CMP	AH,4			; WRITE ?
	JNE	RS_P4
RS_P2:
	TEST	RSB_FLAG[DI],80H	; CHECK INIT_FLAG
	JZ	RS_NI			; OFF (ERROR RETURN)
RS_P4:
	PUSH	AX
	MOV	AL,AH
	CBW
	SHL	AX,1
	MOV	SI,OFFSET RS_CMD_TBL
	ADD	SI,AX
	POP	AX
	CALL	CS:[SI]
;********************************
;   RETURN FROM RS232_BIO	*
;********************************
RS232_RET:
	POP 	DX
	POP	BX
	POP	SI
	POP	DI
	POP	DS
	POP	ES
	IRET

;   PORT NOT INITIALIZED
	
RS_NI:
	MOV	AH,1
	JMP     SHORT	RS232_RET

;   ILLEGAL COMMAND (NO OPERATION)

RS_NOP:
	MOV	AH,0		; NORMAL RETURN
	JMP     SHORT	RS232_RET
	PAGE
;****************************************
;   SEND DATA				*
;	SEND THE CHARACTER IN (AL)	*
;	ENTRY: (AH)=3			*
;	       (AL)=SEND DATA		*
;	EXIT : (AH)=RETURN CODE		*
;****************************************
RS_SEND:
	TEST	[RS_S_FLAG],80H	; BIT 8 ?
	JZ	RS_SEND50	; YES
	TEST	AL,80H		; SO CHARACTER ?
	JNZ	RS_SEND30	; YES
	TEST	[RS_S_FLAG],02H	; NOW SI MODE ?
	JZ	RS_SEND50
	PUSH	AX
	MOV	AL,RS_SI	; OUTPUT SI CODE
	CALL	RS_SND		;
	AND	AH,AH
	POP	AX
	JNZ	RS_SEND_EXIT	; 
	AND	[RS_S_FLAG],NOT 02H
	JMP	SHORT RS_SEND50

RS_SEND30:
	TEST	[RS_S_FLAG],02H	; NOW SO MODE ?
	JNZ	RS_SEND50
	PUSH	AX
	MOV	AL,RS_SO	; OUTPUT SO CODE
	CALL	RS_SND		;
	AND	AH,AH
	POP	AX
	JNZ	RS_SEND_EXIT	; 
	OR	[RS_S_FLAG],02H

RS_SEND50:
	CALL	RS_SND
RS_SEND_EXIT:
	RET
	PAGE
;****************************************
;*					*
;*	OUTPUT CHARACTER		*
;*					*
;*	INPUT	AL=OUTPUT CHARACTER	*
;*		RSB_STIM[DI]=TIME OUT	*
;*	EXIT	AH=RETURN CODE		*
;*					*
;*					*
;****************************************
RS_SND:
	PUSH	CX
	MOV	AH,AL		;
	MOV	DL,RSB_STIM[DI]	; SET TIME OUT COUNT
	MOV	DH,0
	ADD	DX,DX
RS_SND1:
	MOV	CX,19000	; SET COUNTER (0.25 SEC)
	TEST	BYTE PTR [BIOS_FLAG+1],80H
	JZ	RS_SND1_1	; BR. IF 5MHZ SYSTEM
	MOV	CX,28000	; SET LOOP COUNTER
RS_SND1_1:
	IN	AL,RS_STA	; READ USART STATUS
	AND	AL,RS_STS_TXR
	OR	AL,RSB_FLAG[DI]	; XOFF RECEIVE ?
	AND	AL,04H+RS_STS_TXR
	CMP	AL,RS_STS_TXR
	JZ	RS_SND3		; BR. TX SEND REDY
	LOOP	RS_SND1_1	; NOT TXRDY (RETRY)
	DEC	DX
	JNZ	RS_SND1		; RETRY	(498MS)

;  TIME	OUT (ERROR RETURN)
	MOV	AH,03H		; TIME OUT
	JMP	SHORT RS_SND_EXIT
;
; SEND THE CHARACTER

RS_SND3:
	MOV	AL,AH
	OUT	RS_DATA,AL	; OUTPUT CHARACTER
	MOV	AH,0
RS_SND_EXIT:
	POP	CX
	RET
	PAGE
;********************************************************
;   RECEIVE DATA					*
;	RECEIVE	A CHARACTER FROM RECEIVER_BUFFER	*
;	ENTRY: (AH)=4					*
;	EXIT : (AH)=RETURN_CODE				*
;	       (CH)=RECEIVED DATA			*
;	       (CL)=STATUS				*
;********************************************************
RS_RECV:
	CLI			; DISABLE INTERRUPT
	MOV	AH,02H
	MOV	DL,RSB_FLAG[DI]	; GET FLAG BYTE
	AND	RSB_FLAG[DI],NOT 20H	; CLEAR 'BOVF' FLAG
	TEST	DL,20H		; BOVF FLAG ON ? (BUFFER OVERFLOW)
	JNZ	RS_RECV_EXIT	; YES, (BUFFER OVER FLOW)

;*
;**	WAIT UNTIL DATA RECEIVE OR TIME OUT
;*
	STI			; ENABLE INTERRUPT
	MOV	DL,RSB_RTIM[DI]	; SET TIME OUT COUNT
	MOV	DH,0
	ADD	DX,DX
RS_RCV0:
	MOV	CX,26500 	; SET COUNTER (0.25 SEC)
	TEST	BYTE PTR [BIOS_FLAG+1],80H
	JZ	RS_RCV0_1	; BR. IF 5MHZ SYSTEM
	MOV	CX,39400	; SET COUNTER
RS_RCV0_1:
	CMP	RSB_CNT[DI],0
	JNZ	RS_RCV3		; BR. IF RECEIVED
	LOOP	RS_RCV0_1
	DEC	DX
	JNZ	RS_RCV0

; TIME OUT
	MOV	AH,03H		; TIME OUT
	JMP	SHORT RS_RECV_EXIT
;*
;**	GET A CHARACTER
;*
RS_RCV3:
	CLI			; DISABLE INTERRUPT
	MOV	BX,RSB_GETP[DI]	; GET GETP
	MOV	CX,[BX]		; GET DATA & STATUS
	ADD	BX,2
	CMP	BX,RSB_TAIL[DI]	; GETP = TAILP ?
	JB 	RS_RCV31	; NO
	MOV	BX,RSB_HEAD[DI]	; GETP := HEADP
RS_RCV31:
	MOV	RSB_GETP[DI],BX	; SAVE GETP
	AND	RSB_FLAG[DI],NOT 40H	; CLEAR 'BFULL' FLAG
	DEC	RSB_CNT[DI]	; DATA COUNT DECREMENT
;*
;**	X-PROTOCOL
;*
	MOV	AX,RSB_CNT[DI]
	CMP	RSB_XON[DI],AX
	JB	RS_RCV9
	TEST	RSB_FLAG[DI],08H	; Q. XON ENABLE ?
	JZ	RS_RCV9

	MOV	AL,RS_XON
	CALL	RS_SND		; COUPUT CTL_Q
	CMP	AH,0
	JNZ	RS_RECV_EXIT
	AND	RSB_FLAG[DI],NOT 08H
RS_RCV9:
	MOV	AH,0
RS_RECV_EXIT:
	RET
	PAGE
;************************************************
;   COMMAND OUT					*
;						*
;	ENTRY: (AH)=5				*
;	       (AL)=COMMAND BYTE		*
;		BIT [7]: ------------		*
;		    [6]: INTERNAL RESET		*
;		    [5]: REQUEST TO SEND	*
;		    [4]: ERROR RESET		*
;		    [3]: SEND BREAK		*
;		    [2]: RECEIVER ENABLE	*
;		    [1]: DATA TERMINAL READY	*
;		    [0]: TRANSMITTER ENABLE	*
;;	EXIT : (AH)=RETURN CODE			*
;************************************************
RS_OUTC:
	OUT	RS_CMD,AL	; OUTPUT 8251 COMMAND BYTE
	MOV	RSB_CMDS[DI],AL	; SAVE 8251 COMMAND BYTE
	CLI			; DISABLE INTERRUPT
	TEST	AL,RS_CMD_IR	; INTERNAL RESET ?
	JNZ	RS_OUT1		; YES
	TEST	AL,RS_CMD_RXE	; RX ENABLE ?
	JZ	RS_OUT2		; NO
	MOV	AL,RS_RXR_E	; RXRDY-INT ENABLE (8255)
	OUT	SYS_PORT,AL
	NOP
	NOP
	IN	AL,INTM_O1	; READ IMR (8259)
	AND	AL,NOT 10H	; LEVEL-4 INT (RXRDY) ENABLE
	OUT	INTM_O1,AL
	JMP	RS_OUTC_EXIT
;
RS_OUT1:
	AND	RSB_FLAG[DI],7FH	; INIT FLAG OFF
;
RS_OUT2:
	MOV	AL,RS_RXR_D	; RXRDY	INT DISABLE
	OUT	SYS_PORT,AL
	NOP
	NOP
	IN	AL,INTM_O1	; READ IMR (8259)
	OR	AL,10H		; LEVEL4_INT (RXRDY) DISABLE
	OUT	INTM_O1,AL
RS_OUTC_EXIT:
	MOV	AH,0
	RET
	PAGE
;************************************************
;   STATUS					*
;						*
;	ENTRY: (AH)=6				*
;	EXIT : (AH)=RETURN CODE			*
;	       (CH)=8251 STATUS	BYTE		*
;		BIT [7]: DATA SET READY		*
;		    [6]: BREAK DETECT		*
; 	 	    [5]: FRAMING ERROR		*
;		    [4]: OVERRUN ERROR		*
;		    [3]: PARITY ERROR		*
;		    [2]: TRANSMITTER EMPTY	*
;		    [1]: RECEIVER READY		*
;		    [0]: TRANSMITTER READY	*
;	       (CL)=SYSTEM_PORT	(8255) STATUS	*
;		BIT [7]: 0-CI			*
;		    [6]: 0-CLEAR TO SEND (CS)	*
;		    [5]: 0-CARRIER DETECT (CD)	*
;		    [4]-[0]: ----		*
;************************************************
RS_STAT:
	IN	AL,RS_STA	; READ 8251 STATUS BYTE
	MOV	CH,AL
	NOP
	IN	AL,PORTB	; READ SYSTEM_PORT STATUS
	MOV	CL,AL
	MOV	AH,0
	RET
	PAGE
;****************************************
;   GET	DTL				*
;					*
;	ENTRY: (AH)=2			*
;	EXIT : (AH)=RETURN CODE		*
;	       (CX)=DATA LENGTH		*
;****************************************
RS_GTDTL:
	MOV	CX,RSB_CNT[DI]	; GET DATA COUNTER
	MOV	AH,0

	RET			; RETURN TO MAIN ROUTINE
	PAGE
;****************************************************************
;   INITIALIZE THE PORT						*
;	ENTRY: (AH)=0 OR 1					*
;	       (AL)=TRANSFER RATE				*
;		  	(AL): 0 --   75 BAUD			*
;			      1 --  150				*
;			      2 --  300				*
;			      3 --  600				*
;			      4 -- 1200				*
;			      5 -- 2400				*
;			      6 -- 4800				*
;			      7 -- 9600				*
;			      >7 --- TREAT 1200 BAUD		*
;	       (CH)=8251 MODE BYTE				*
;		  BIT  7 - 6     5 - 4     3 - 2     1 - 0	*
;		       STOP BIT  PARITY    BIT/CHAR  BAUD RATE	*
; 			00: --    X0: NONE  00: 5     00: --	*
;			01: 1     01: ODD   01: 6     01: --	*
;   			10: 1.5   11: EVEN  10: 7     10: X16	*
;			11: 2               11: 8     11: X64	*
;	       (CL)=8251 COMMAND BYTE				*
;	       (ES)=BUFFER SEGMENT				*
;	       (DI)=BUFFER OFFSET				*
;	       (DX)=BUFFER SIZE					*
;	       (BH)=SEND TIME OUT (*500MS)			*
;	       (BL)=RECEIVE TIME OUT (*500MS)			*
;	EXIT : (AH)=RETURN CODE					*
;****************************************************************
RS_INIT1:
	CLC
	JMP     SHORT	RS_INIT
;
RS_INIT2:
	STC
RS_INIT:
;****************************************
;*      RS232C INTERRUPT DISABLE	*
;****************************************
	CLI			; DISABLE INTERRUPT
	PUSHF
	MOV	AH,AL		; SAVE AL (TRANSFER RATE)
	IN	AL,PORTC	; READ 8255 PORT_C
	AND	AL,0F8H		; RXR,TXE,TXR INT DISABLE
	OUT	PORTC,AL
	NOP
	NOP
	IN	AL,INTM_O1	; READ 8259 IMR
	OR	AL,10H		; RS232C INT DISABLE
	OUT	INTM_O1,AL	; WRITE 8259 OCW1
	MOV	AL,AH		; RESUME AL
	STI			; ENABLE INTERRUPT
;****************************************
;*	SET MODE AND BOUD RATE		*
;****************************************

;
;	BOUD RATE
;
	CMP	AL,08H
	JB	RS_INIT10
RS_INIT8:
	MOV	AL,04H			; DEFALT = 1200
RS_INIT10:
	CBW
	MOV	SI,OFFSET RS_CNTTBL16	; BAUD RATE
	TEST	BYTE PTR [BIOS_FLAG+1],80H
	JZ	RS_INIT10_1		; BR. IF 5MHZ SYSTEM
	MOV	SI,OFFSET RS_CNTTBL16_8
RS_INIT10_1:
	TEST	CH,01H			;  CH(01) ON --- X64
	JZ	RS_INIT15		;  CH(01) OFF -- X16
	ADD	SI,4			; SET X64 TABLE OFFSET
RS_INIT15:
	SHL	AL,1			; WORD OFFSET
	ADD	SI,AX
	CMP	WORD PTR CS:[SI],0
	JZ	RS_INIT8

	MOV	AL,RS_TIM_MOD	; SET 8253 MODE	INSTRUCTION.
	OUT	TIM_CTL,AL
	MOV	AX,CS:[SI]	; GET
	NOP
	OUT	TIMER2,AL	; OUTPUT COUNTER LSB
	MOV	AL,AH
	NOP
	OUT	TIMER2,AL	; OUTPUT COUNTER MSB
;
;	MODE INSTRUCTION AND COMMAND
;
	MOV	AL,02H		; SET DUMMY MODE
	OUT	RS_MOD,AL	
	PUSH	AX		; TIME DELAY
	POP	AX
	MOV	AL,RS_CMD_IR	; 8251 COMMAND BYTE
	OUT	RS_CMD,AL	;            [ INTERNAL RESET ]
	PUSH	AX		; TIME DELAY
	POP	AX
	MOV	AL,CH
	OUT	RS_MOD,AL	; OUTPUT 8251 MODE BYTE
	PUSH	AX		; TIME DELAY
	POP	AX
	MOV	AL,CL
	OUT	RS_CMD,AL	; OUTPUT 8251 COMMAND BYTE
;****************************************
;*	INTIALIZE MEMORY OF COMMON WORK	*
;****************************************
;--------------------------------------------NOV/13/83--------
		MOV	[RS_S_FLAG],0
		AND	CH,0CH
		CMP	CH,0CH
		JZ	RS_INIT17
		MOV	[RS_S_FLAG],80H
RS_INIT17:
;--------------------------------------------------------------
	MOV	WORD PTR[DI-2],0	; CLEAR	INTERFACE FIELD
;
	POPF
	MOV	CH,10H
	JC	RS_INIT20	; YES
	MOV	CH,00H		; NO
RS_INIT20:
	MOV	RSB_FLAG[DI],CH	; INITIALIZE FLAG AREA
	MOV	RSB_CMDS[DI],CL	; SAVE 8251 COMMAND BYTE
	CMP	BH,0		; SEND TIME OUT
	JNZ	RS_INIT25
	MOV	BH,02H		; 02H IS DEFAULT VALUE (1SEC)
RS_INIT25:
	MOV	RSB_STIM[DI],BH
	CMP	BL,0		; RECV TIME OUT
	JNZ	RS_INIT30
	MOV	BL,3CH		; 3CH IS DEFAULT VALUE (30SEC)
RS_INIT30:
	MOV	RSB_RTIM[DI],BL
;
	MOV	CX,DX
	SHR	DX,1
	SHR	DX,1
	MOV	AX,DX
	SHR	DX,1
	ADD	AX,DX
	MOV	RSB_XON[DI],DX	; SET 1/4
	MOV	RSB_XOFF[DI],AX	; SET 3/4
;
	MOV	AX,DI
	ADD	AX,RSB_OFST	;
	MOV	RSB_HEAD[DI],AX	; SET BUFFER HEAD POINTER
	ADD	CX,AX
	MOV	RSB_TAIL[DI],CX	; SET BUFFER TAIL POINTER
	MOV	RSB_CNT[DI],0	; CLEAR COUNTER
	MOV	RSB_PUTP[DI],AX	; PUT POINTER
	MOV	RSB_GETP[DI],AX	; GET POINTER
;
	MOV	AL,RSB_CMDS[DI]
	TEST	AL,RS_CMD_IR	; CMD(IR) ON ?
	JNZ	RS_INIT35	; YES
	OR	RSB_FLAG[DI],80H	; SET INIT FLAG
	TEST	AL,RS_CMD_RXE	; CMD(RXE) ON ?
	JZ	RS_INIT35	; NO
	CLI			; DISABLE INTERRUPT
	MOV	AL,RS_RXR_E	; RXRDY	INT ENABLE
	OUT	SYS_PORT,AL
	NOP
	IN	AL,INTM_O1	; READ 8259 IMR
	AND	AL,NOT 10H	; RS232C INT
	OUT	INTM_O1,AL	; WRITE 8259 OCW1
	STI			; ENABLE INTERRUPT
RS_INIT35:
	MOV	AH,0		; RETURN CODE =	0
	RET			; RETURN TO MAIN ROUTINE
	PAGE
;************************************************
;   RS232C_INT					*
;	RECEIVE INTERRUPT ENTRY			*
;						*
;************************************************
; LOCAL MEMORY INFO.
;
;****************************************************************
; RS_S_FLAG							*
;	BIT  7  6  5  4  3  2  1  0				*
;	     I        I        I				*
;	     I        I        0:CH0 -- SI STATE (SEND)		*
;	     I        I        1:CH1 -- SO STATE (SEND)		*
;	     I        I						*
;	     I	      I						*
;	     I	      0:CH0 -- SI STATE (RECEIVE)		*
;	     I	      1:CH0 -- SO STATE (RECEIVE)		*
;	     0:CH0 -- SISO OP. DISABLE				*
;	     1:CH0 -- SISO OP. ENABLE				*
;								*
; RS_D_FLAG							*
;	BIT  7  6  5  4  3  2  1  0				*
;			          I				*
;				  0:CH0 -- DEL CONV. DISABLE	*
;				  1:CH0 -- DEL CONV. ENABLE	*
; MEMORY SWITCH ( A3FE:000AH )					*
;	BIT  7  6  5  4  3  2  1  0				*
;	     I							*
;	     0: DEL NOT CONVERT					*
;	     1: DEL --> NUL(00H)				*
;****************************************************************
;--------------------------------------------------DEL NOV/16/83--
RS232C_INT:
	PUSH	DS
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
;
;	GET COMMON WORK AREA

;
	MOV	AX,SYSCOM	;-------------------------NOV/16/83---
	MOV	ES,AX		; COMMON AREA BASE SET TO ES
	LDS	DI,DWORD PTR [RS_OFST_ADR]
	ADD	DI,2
;****************************************
;*	READ DATA AND STATUS		*
;****************************************
	IN	AL,RS_DATA	; GET DATA FROM	8251
	MOV	BH,AL
	NOP
	IN	AL,PORTB	; GET STATUS FROM SYSTEMPORT (8255)
	MOV	BL,AL		; SAVE
	SHL	BL,1
	MOV	CL,6
	SHR	BL,CL
	IN	AL,RS_STA	; GET STATUS FROM USART (8251)
	AND	AL,0FCH
	OR	BL,AL
;
;	ERROR CHECK
;
	TEST	BL,38H		; FE,OE,PE ON ?
	JZ	RS_INT1		; ALL '0'
	MOV	AL,RSB_CMDS[DI]	; COMMAND BYTE
	OR	AL,10H		; ER ON	(ERROR RESET)
	OUT	RS_CMD,AL
RS_INT1:
	MOV	AX,BX
;****************************************
;*	CHECK CONTROL CHARACTER		*
;****************************************
;-----------------------------------------------DEC/13/83----
		TEST	RSB_FLAG[DI],10H
		JZ	RS_INT25
		CMP	AH,RS_XOFF	; CNTL_S
		JNZ	RS_INT21

		OR	RSB_FLAG[DI],04H	; SET XON RECEIVE
		JMP	RS_INT_EXIT
RS_INT21:
		CMP	AH,RS_XON
		JNZ	RS_INT22
		AND	RSB_FLAG[DI],NOT 04H
		JMP	RS_INT_EXIT
RS_INT22:
RS_INT25:
;---------------------------------------------DEL MAR/22/84-------------
;
;	SHIFT IN AND SHIFT OUT
;
	TEST	[RS_S_FLAG],80H	; SHIFT OP. ENABLE ?
	JZ	RS_IXEXT	; NO
	CMP	AH,RS_SO	; SO DATA
	JNZ	RS_IX10
	OR	[RS_S_FLAG],10H	; SET SO STATE
	JMP	SHORT RS_INT_EXIT
RS_IX10:
	CMP	AH,RS_SI	; SI DATA ?
	JNZ	RS_IX20
	AND	[RS_S_FLAG],NOT 10H	; SET SI STATUS
	JMP	SHORT RS_INT_EXIT
RS_IX20:
	AND	AH,7FH		; CLEAR 2**7 BIT
	CMP	AH,1FH		; CONTROL CODE ?
	JBE	RS_IXEXT	; YES, (NO CONVERSION)
	TEST	[RS_S_FLAG],10H	; SI STATE ?
	JZ	RS_IXEXT	; YES
	OR	AH,80H		; SO STATE (2**7 BIT ON)

RS_IXEXT:
;****************************************
;*	SET DATA TO RECEIVE BUFFER	*
;****************************************
	CLI
	TEST	RSB_FLAG[DI],40H	; BUFFER FULL ?
	JZ	RS_INT30
	OR	RSB_FLAG[DI],20H
	JMP	RS_INT_EXIT

RS_INT30:
	MOV	BX,RSB_PUTP[DI]	; PUT POINTER
	MOV	[BX],AX		; SET DATA AND STATUS
	ADD	BX,2
	CMP	BX,RSB_TAIL[DI]
	JB	RS_INT4
	MOV	BX,RSB_HEAD[DI]
RS_INT4:
	MOV	RSB_PUTP[DI],BX
	INC	RSB_CNT[DI]	; DATA COUNTER 1 UP
	MOV	AX,RSB_CNT[DI]
	CMP	BX,RSB_GETP[DI]	; BUFFER FULL ?
	JNE	RS_INT5
	OR	RSB_FLAG[DI],40H	; SET 'BFULL' FLAG
RS_INT5:
;****************************************
;*	X_PROTOCOL			*
;****************************************
	CMP	AX,RSB_XOFF[DI]	; COUNTER G.E 3/4BUFFER	SIZE ?
	JB	RS_INT7		; NO
	TEST	RSB_FLAG[DI],10H	;
	JZ	RS_INT7
	TEST	RSB_FLAG[DI],08H	;
	JNZ	RS_INT7
	STI
	MOV	AL,RS_XOFF		; CNTL_S
	CALL	RS_SND
	CMP	AH,0
	JNZ	RS_INT_EXIT
	OR	RSB_FLAG[DI],08H
RS_INT7:
	SUB	DI,2
	OR	RSB_FLAG[DI],80H	; SET 'INT' FLAG
RS_INT_EXIT:			; SOURCE PATCH 		   (12/25/82)
	MOV	AL,EOI
	OUT	INTM_O2,AL	; END OF INTERRUPT
	POP	ES
	POP 	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	DS
	IRET			; RETURN
;
ROM 	ENDS
	END

S

