	PAGE	60,132
	TITLE	'HDRAM'
;
;
;************************************************
;*						*
;*	MODULE NAME	'HDRAM'			*
;*						*
;*	5" HARD-DISK DRIVE ROUTINE		*
;*						*
;*		FEB. 04 1984			*
;*						*
;************************************************
;		MAR/27/84
;		APR/10/84
;		APR/26/84
;	may/16/84
;	JUN/04/84	DELETE BUG
;		IF (TRAND ADDR + DATA LENGTH ) = 64 BOUNDARY, ERROR
;	JUN/12/84	DELETE BUG AND MEMORY SIZE
;		(1) IF LENGTH 64 OVER, ABORT RUN
;		(2) IF ADDRESS IS 0:FFFF, ABORT RUN
;		(3) DELETE MEMORY SIZE (INIT_DCB,SLCT_DCB, CHECK TRACK OVER)
;	JUN/27/84	FIX BUG OF VERIFY WRITE
;	JUN/14/84	FIXED BUG (TRACK OVER CHECK)
;
	INCLUDE	B:SYSCOM.ASM
;
CODE	SEGMENT WORD PUBLIC 'CODES'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
;
;
;
;========================================
;	EXTERNAL REFERENCE
;========================================
;
	EXTRN	ENTRY:NEAR
	EXTRN	NORMAL_EXIT:NEAR
	EXTRN	ERROR_EXIT:NEAR
	EXTRN	CMDERR_EXIT:NEAR
	EXTRN	PTRSAV:DWORD
	EXTRN	DSK_BUF:NEAR

	EXTRN	HDCB0:BYTE
	EXTRN	HDCB1:BYTE
;
;========================================
;	EXTERNAL DEFINITION
;========================================
;
	PUBLIC	HD_DSK_INT
	PAGE
;************************************************
;*						*
;*	STRUCTURE DEFINITION			*
;*						*
;************************************************
;
;	PACKET TABLE
;
IODAT 	STRUC
CMDLEN	DB	?			; COMMAND LENGTH
UNIT	DB	?			; LOGICAL UNIT NO.
CMD	DB	?			; COMMAND CODE
STATUS	DW	?			; STATUS
	DB	8	DUP(?)		; DEVICE NAME
MEDIA	DB	?			; MEDIA DESCRIPTOR
TRANS	DD	?			; TRANS BUFFER ADRS
COUNT	DW	?			; TRANS SECTOR
START	DW	?			; TRANS START SECTOR
IODAT	ENDS
;
;	5"HD DEVICE CONTROL BLOCK
;
H5_DCB	STRUC
SEN	DB	?			; SENSE STATUS
BCMD	DB	?			; ROM BIOS COMMAND
DAUA	DB	?			; DA/UA
CRNT	DD	?			; CURRENT REL.SECTOR
DTL	DW	?			; DTL
DTA	DW	?			; DTA
DTS	DW	?			; DTS
STS	DB	?			; ROM BIOS RETURN STATUS
	DB	?
	DB	?
OFST	DD	?			; START REL. SECTOR
LAST	DD	?			; LAST REL. SECTOR
CAP	DB	?			; MS-DOS CAPACITY (MB)
	DB	?
BPB	DB	13 DUP(?)		; BPB SAVE AREA
	DB	?			; MEDIA DESCRIPTOR BUFFER
H5_DCB	ENDS
	PAGE
;************************************************
;*						*
;*	EQUATION BLOCK				*
;*						*
;************************************************
;
;	SENSE STATUS FLAG
;
F_ATN	EQU	08H			; ATTENTION FLAG
;
;	ROM BIOS INTERRUPT VECTOR
;
HD_ROM	EQU	1DH			; HD ROM BIOS
;
MAXUN	EQU	2			; MAXIMUM UNIT NO.
	PAGE
;
;==================================
;
;	WORK AREA
;
;==================================
;
;-----------------------------------DELETE SAVE UNIT NUMBER JUN/12/84--
;
C_RTRY	DB	0			; RETRY COUNTER
	EVEN
P_DCB	DD	0			; DCB	POINTER
;
C_SECT	DW	0			; LOGICAL SECTOR COUNTER
C_TRNS	DW	0			; TRANS SECTOR COUNTER
C_ACT_DIS	DW	0		; NUMBER OF SECTORS OUT OF VOLUME--JUN/12/84
;
DSK_BUF_ADR	LABEL	DWORD
	DD	DSK_BUF			; BUFFER FOR DMA BOUNDARY
	PAGE
;************************************************
;*						*
;*	DESPATCH TABLE FOR DEVICE		*
;*						*
;************************************************
;
;
HD_DSK_TBL	LABEL	WORD
	DW	HD_DSK_INIT		; 0 -- INITIALIZE
	DW	HD_MEDIA_CHK		; 1 -- MEDIA CHECK
	DW	HD_GET_BPB		; 2 -- BUILD BPB
	DW	CMDERR_EXIT		; 3 -- IO CTRL INPUT
	DW	HD_DSK_READ		; 4 -- DESTRUCTIVE READ
	DW	CMDERR_EXIT		; 5 -- NON-DESTRUCTIVE READ
	DW	CMDERR_EXIT		; 6 -- INPUT STATUS
	DW	CMDERR_EXIT		; 7 -- FLUSH INPUT BUFFER
	DW	HD_DSK_WRIT		; 8 -- WRITE
	DW	HD_DSK_WRTV		; 9 -- WRITE WITH VERIFY
	DW	CMDERR_EXIT		; 10-- WRITE STATUS
	DW	CMDERR_EXIT		; 11-- OUTPUT STATUS
	DW	CMDERR_EXIT		; 12-- IOCTL OUTPUT
	PAGE
;************************************************
;*						*
;*	MODULE NAME	DSK_INT			*
;*						*
;*	FUNCTION	DISK I/O CONTROL	*
;*						*
;*	INPUT/OUTPUT	NONE			*
;*						*
;************************************************
;
;
HD_DSK_INT	PROC	FAR
	PUSH	SI			; ALL REGISTER SAVE
	MOV	SI,OFFSET HD_DSK_TBL
	JMP	ENTRY
HD_DSK_INT	ENDP
	PAGE
;*****************************************
;*
;*	DISK INITIALIZE
;*
;*	COMMAND CODE (0)
;*
;*****************************************
;
HD_DSK_INIT:
	MOV	AL,0			; UN=0
DSK_INIT1:
	PUSH	AX
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	DSK_INIT2		; JUMP IF UNDEFINE
	CALL	INIT_DCB		; INITIALIZE DCB TABLE
DSK_INIT2:
	POP	AX
	INC	AL			; NEXT LOGICAL NO.
	CMP	AL,MAXUN		; END OF LOOP ?
	JNE	DSK_INIT1		; NO,
;
	MOV	AL,MAXUN		; GET DEVICE NUMBER
	MOV	DX,OFFSET BPB_ADR_TBL
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	MOV	[BX.MEDIA],AL		; SET DRIVE NUMBER
	MOV	[BX.COUNT],DX
	MOV	[BX.COUNT+2],CS
	JMP	NORMAL_EXIT
;
;===== BPB ADDRESS TABLE ======
;
BPB_ADR_TBL:
	DW	HDCB0+BPB,HDCB1+BPB	; 5"HD BPB ADDRESS
	PAGE
;****************************************
;*
;*	MEDIA CHECK
;*
;*	COMMAND CODE (1)
;*
;****************************************
;
;
HD_MEDIA_CHK:
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	MEDIA_CHK2		; BRANCH IF UNDEFINE
	MOV	AH,[SI.SEN]		; GET STATUS-----JUN/05/84-----
;
	MOV	AL,1			; SET NO-CHANGE
	TEST	AH,F_ATN		; CHANGE ?
	JZ	MEDIA_CHK1		; NO,
;-----------------------------------------------------05/23/1984----------------
	CALL	BPB_IN			; FOR NON IBM COMPATIBLE BIT OFF
	JC	MEDIA_CHK2
;-------------------------------------------------------------------------------
	MOV	AL,-1			; SET CHANGE
MEDIA_CHK1:
	LDS	BX,[PTRSAV]
	MOV	BYTE PTR [BX.TRANS],AL	; SET CHANGE/NO-CHANGE FLAG
	JMP	NORMAL_EXIT
;
MEDIA_CHK2:
	JMP	ERROR_EXIT
	PAGE
;****************************************
;*
;*	BUILD BPB
;*
;*	COMMAND CODE (2)
;*
;****************************************
;
;
HD_GET_BPB:
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	GET_BPB1		; JUMP IF UNDEFINE
	CALL	BPB_IN			; BPB INPUT
	JC	GET_BPB1		; JUMP IF ERROR
;----------------------------------------------------------------05/23/1984----
	INC	BYTE PTR [SI.BPB+13]	; MEDIA-DESCRIPTOR BUFFER
	MOV	CL,[SI.BPB+13]
	MOV	[SI.BPB+10],CL

;	MOV	CL,[SI.BPB+10]		; GET MEDIA DESCRIPTOR
;------------------------------------------------------------------------------
	LEA	AX,[SI.BPB]		; GET BPB OFFSET
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	MOV	[BX.MEDIA],CL		; SET MEDIA DESCRIPTOR
	MOV	[BX.COUNT],AX		; SAVE BPB ADRS
	MOV	[BX.COUNT+2],CS
	JMP	NORMAL_EXIT
;
GET_BPB1:
	JMP	ERROR_EXIT
	PAGE
;*****************************************
;*
;*	DISK READ
;*
;*	COMMAND CODE (4)
;*
;*****************************************
;
;
HD_DSK_READ:
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	DSK_RD4			; JUMP IF UNDEFINE
	CALL	SET_UP			; SET UP PARAMETER
;---------------------------------------------DELETE JUN/12/84---------
DSK_RD1:
	CMP	[C_SECT],0		; END OF COUNT ?
	JE	DSK_RD2			; NO,---------CHG JUN/12/84----
;----------------------------------------------DELETE JUN/12/84--------
	CALL	SET_LENGTH		; SET TRANS LENGTH
	CALL	SCT_RD			; READ ONE LOGICAL SECTOR
	JC	DSK_RD3			; JUMP IF READ ERROR
	CALL	SCT_UP			; SECTOR COUNT UP
	JMP	DSK_RD1			; LOOP ---------CHG JUN/12/84-
;--------------------------------------------INSERT JUN/12/84----------
DSK_RD2:
	MOV	AL,8
	CMP	[C_ACT_DIS],0		; TRACK OVER NONE ?
	JNE	DSK_RD3			; NO. (GO TO TRACK OVER ERROR)
	JMP	NORMAL_EXIT
;----------------------------------------------------------------------
DSK_RD3:
	MOV	CX,[C_SECT]		; GET REMAIN COUNT
	ADD	CX,[C_ACT_DIS]		; -----------APPEND JUN/12/84--
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANS COUNT
	JMP	ERROR_EXIT
DSK_RD4:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANS COUNT
	JMP	ERROR_EXIT
	PAGE
;*****************************************
;*
;*	DISK WRITE
;*
;*	COMMAND CODE (8)
;*
;*****************************************
;
;
HD_DSK_WRIT:
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	DSK_WR5			; JUMP IF UNDEFINE
	CALL	SET_UP			; SET UP PARAMETER
;--------------------------------------------------DELETE JUN/12/84----
DSK_WR2:
	CMP	[C_SECT],0		; END OF COUNT ?
	JE	DSK_WR3			; NO,--------CHG JUN/12/84-----
	CALL	SET_LENGTH		; SET TRANS LENGTH
	CALL	SCT_WR			; WRITE ONE LOGICAL SECTOR
	JC	DSK_WR4			; JUMP IF ERROR
	CALL	SCT_UP			; SECTOR COUNT UP
	JMP	DSK_WR2			; LOOP ----------CHG JUN/12/84-
;--------------------------------------------------INSERT JUN/12/84----
DSK_WR3:
	MOV	AL,8
	CMP	[C_ACT_DIS],0		; TRACK OVER NONE ?
	JNZ	DSK_WR4			; NO. (GO TO TRACK OVER ERROR)
	JMP	NORMAL_EXIT
;----------------------------------------------------------------------
DSK_WR4:
	MOV	CX,[C_SECT]		; GET REMAIN COUNT
	ADD	CX,[C_ACT_DIS]		;-------------APPEND JUN/12/84-
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANS COUNT
	JMP	ERROR_EXIT
;
DSK_WR5:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANS COUNT
	JMP	ERROR_EXIT
	PAGE
;****************************************
;*
;*	DISK WRITE WITH VERIFY
;*
;*	COMMAND CODE (9)
;*
;****************************************
;
;
HD_DSK_WRTV:
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	DSK_WRV6		; JUMP IF UNDEFINE
	CALL	SET_UP			; SET UP PARAMETER
;-------------------------------------------DELETE JUN/12/84-----------
DSK_WRV2:
	CMP	[C_SECT],0		; END OF COUNT ?
	JE	DSK_WRV3		; NO,----------CHG JUN/12/84---
;-----------------------------------------------DELETE JUN/12/84-------
;---------------------------------------------INSERT JUN/27/84--------
	CALL	SET_LENGTH		; SET TRANS LENGTH
;---------------------------------------------------------------------
	CALL	SCT_WR			; WRITE ONE LOGICAL SECTOR
	JC	DSK_WRV5		; JUMP IF ERROR
	CALL	VRFY			; VERIFY
	JC	DSK_WRV5
	CALL	SCT_UP			; SECTOR UP
	JMP	DSK_WRV2		; LOOP ---------CHG JUN/12/84--
;-----------------------------------------------INSERT JUN/12/84-------
DSK_WRV3:
	MOV	AL,8
	CMP	[C_ACT_DIS],0		; TRACK OVER NONE ?
	JNZ	DSK_WRV5		; NO. (GO TO TRACK OVER ERROR)
	JMP	NORMAL_EXIT
;----------------------------------------------------------------------
DSK_WRV5:
	MOV	CX,[C_SECT]		; GET REMAIN SECTOR
	ADD	CX,[C_ACT_DIS]		;-------------APPEND JUN/12/84-
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANSFAR SECTOR
	JMP	ERROR_EXIT
;
DSK_WRV6:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANSFAR SECTOR
	JMP	ERROR_EXIT
	PAGE
;****************************************************************
;*								*
;*		SUBROUTINES					*
;*								*
;*	BASIC INPUT/OUTPUT SEQUENCE				*
;*		INPUT	[DS:SI]	: DCB TABLE ADRS		*
;*		OUTPUT	[CF]=0	: NORMAL RETURN			*
;*			[CF]=1	: ERROR RETURN			*
;*			[AL]	; MS-DOS ERROR CODE		*
;*								*
;****************************************************************
;
;
;================================================
;	SELECT DEVICE CONTROL BLOCK
;	INPUT	[AL] UNIT NO.
;		[AH] DEVICE NO.
;	OUTPUT	[DS:SI] DCB TABLE ADDRESS
;================================================
;
SLCT_DCB:
	PUSH	CS			; [DS] <== [CS]
	POP	DS
;----------------------------------DELETE SAVE UNIT NUMBER--JUN/12/84--
	CMP	AL,MAXUN		; UNIT NO. OVER ?
	JAE	SLCT_DCB1		; YES,
;-----------------------------------------------CHANGE JUN/11/84-------
	MOV	SI,OFFSET HDCB0
	CMP	AL,0
	JZ	SLCT_DCT0
	MOV	SI,OFFSET HDCB1
SLCT_DCT0:
;----------------------------------------------------------------------
	MOV	WORD PTR P_DCB,SI	; SAVE DCB POINTER
	MOV	WORD PTR P_DCB+2,DS
	CMP	[SI.SEN],-1		; DEVICE UNDEFINE ?
	JE	SLCT_DCB1		; YES,
	CLC				; [CF]=0
	RET
;
SLCT_DCB1:
	MOV	AL,01			; SET UNDEFINE DISK
	STC				; [CF]=1
	RET
;------------------------------------DELETE DCB ADDRESS TABLE-JUN/12/84
	PAGE
;
;=========================================
;
;	INITIALIZE DCB TABLE
;
;=========================================
;
INIT_DCB:
;-------------------------------------------------CHANGE JUN/12/84-----
	ASSUME	ES:SYSCOM
	MOV	BX,SYSCOM
	MOV	ES,BX
;
	MOV	CL,AL
	MOV	BX,0100H
	SHL	BX,CL
	AND	BX,ES:[DISK_EQUIP]	; HD CONNECT ?
	JNZ	INIT_DCB1		; YES,
;----------------------------------------------------------------------
	ASSUME	ES:CODE
	MOV	[SI.SEN],-1		; SET UNDEFINE
	RET
;
INIT_DCB1:
	CALL	SENS			; SENSE COMMAND
	OR	AH,F_ATN		; MULTIPLEX ATTENTION FLAG
	MOV	[SI.SEN],AH		; SET SENSE STATUS
	CLC
	RET
;------------------------------------DELETE EQUIP FLAG TABLE JUN/12/84-
;---------------------------------------DELETE module M_CHK JUN/04/84--
;
;**********************************************
;
;	BPB INPUT FROM DISK
;
;**********************************************
;
BPB_IN:
	MOV	WORD PTR [SI.CRNT],1	; (CRNT):=1
	MOV	WORD PTR [SI.CRNT+2],0
	MOV	[SI.DTL],512		; (DTL):=512
	LES	DI,[DSK_BUF_ADR]
	MOV	[SI.DTA],DI		; (DTA):=DSK_BUF
	MOV	[SI.DTS],ES
BPB_IN1:
	CALL	READ			; READ COMMAND
	JNC	BPB_IN4			; JUMP IF NO ERROR
	CMP	AH,60H			; CANNOT RETRY ?
	JAE	BPB_IN2			; NO,
	JMP	ERROR
;
BPB_IN2:
	ADD	WORD PTR [SI.CRNT],17	; (CRNT)+=17
	CMP	WORD PTR [SI.CRNT],18	; (CRNT)=18 ?
	JZ	BPB_IN1			; NO,
BPB_IN3:
	MOV	AL,12			; SET DISK ERROR
	STC				; [CF]=1
	RET
;
BPB_IN4:
;-----------------------------------------------CHANGE APR/10/84-------
	LES	BX,[DSK_BUF_ADR]	; ES:BX=VOLUME TABLE
	CMP	WORD PTR ES:[BX+510],055AAH	; INVALID ?
	JNZ	BPB_IN9			; Y
;--------------------------------------------------CHANGE APR/26/84----
	MOV	CH,0
	MOV	CL,ES:[BX]		; CX=MAX NUMBER OF VOLUME 
BPB_IN5:
	JCXZ	BPB_IN9			; VOLUME NONE ?
	DEC	CX
	ADD	BX,20H			; CHANGE VOLUME CONFIG. TBL.
	MOV	AX,ES:[BX]		; AL=ACTIVE FLAG,AH=SYSTEM NAME
	CMP	AL,01H			; ACTIVE ?
	JNZ	BPB_IN5			; N
	CMP	AH,01H			; MS-DOS SYSTEM ?
	JZ	BPB_IN6			; Y
	CMP	AH,0F1H			; ALL SYSTEM ?
	JNZ	BPB_IN5
BPB_IN6:
;---------------------------------------------------------------------
	MOV	AX,ES:[BX+4]		; SET IPL SECTOR LOW
	MOV	WORD PTR [SI.CRNT+0],AX
	MOV	AX,ES:[BX+6]		; SET IPL SECTOR HIGH
	MOV	WORD PTR [SI.CRNT+2],AX
	MOV	AX,ES:[BX+8]		; SET START SECTOR LOW
	MOV	WORD PTR [SI.OFST+0],AX
	MOV	AX,ES:[BX+10]		; SET START SECTOR HIGH
	MOV	WORD PTR [SI.OFST+2],AX
	MOV	AX,ES:[BX+12]		; SET END SECTOR LOW
	MOV	WORD PTR [SI.LAST+0],AX
	MOV	AX,ES:[BX+14]		; SET END SECTOR HIGH
	MOV	WORD PTR [SI.LAST+2],AX
;
	CALL	READ			; READ IPL AND GET BPB
	JNC	BPB_IN7			; ERROR ?
	JMP	ERROR
BPB_IN7:
	LEA	DI,[SI.BPB]		; ES:DI=BPB ADDRESS IN DCB
	PUSH	CS
	POP	ES
	LDS	SI,[DSK_BUF_ADR]	; DS:SI=BPB ADDRESS IN IPL SECTOR
	ADD	SI,3+8			;
	MOV	CX,13
	REP	MOVSB			; SET BPB
	CMP	WORD PTR [SI.510-8-3-13],055AAH
	LDS	SI,CS:[P_DCB]		; RESTORE DCB POINTER
	JNZ	BPB_IN9			; INVALID ?
	AND	[SI.SEN],NOT F_ATN	; RESET ATTENTION FLAG
	CLC				; [CF]=0
	RET
;
BPB_IN9:
	MOV	AL,2			; INVALID ERROR--change may/16/84
	STC				; [CF]=1
	RET
;----------------------------------------------------------------------
	PAGE
;*********************************************
;*
;*	SET UP PARAMETER
;*
;*********************************************
;
SET_UP:
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	LES	DI,[BX.TRANS]		; GET TRANS BUFFER ADRS
	MOV	CX,[BX.COUNT]		; GET TRANS COUNT
	MOV	AX,[BX.START]		; GET START ADRS
	LDS	SI,CS:P_DCB		; SET DCB ADRS6
	MOV	[SI.DTA],DI		; SAVE TRANS BUFF ADRS
	MOV	[SI.DTS],ES
;-----------------------------------------------------DELETE JUN/11/84-
	MOV	DX,0			; (SECT)+(OFST) --> (CRNT) APR/10/84
;-----------------------------------------------------DELETE APR/10/84--
	ADD	AX,WORD PTR [SI.OFST]
	ADC	DX,WORD PTR [SI.OFST+2]
	MOV	WORD PTR [SI.CRNT],AX
	MOV	WORD PTR [SI.CRNT+2],DX
;---------------------------------------------------CHANGE JUN/14/84---
	MOV	BX,0			; BX = ACTIVE SECTOR NUMBER
	MOV	AX,WORD PTR [SI.LAST+0]
	MOV	DX,WORD PTR [SI.LAST+2]
	SUB	AX,WORD PTR [SI.CRNT+0]	; TRACK OVER ?
	SBB	DX,WORD PTR [SI.CRNT+2]
	JB	CVT_SCT1		; YES, (ACTIVE SECTOR NONE)
	INC	AX
	MOV	BX,CX			;
	CMP	AX,CX			; TRACK OVER ?
	JAE	CVT_SCT1		; NO, (ACTIVE SECTORS = SECTOR COUNT)
	MOV	BX,AX			;     (ACTIVE SECTORS = REMAIN SECTOS)
CVT_SCT1:
	MOV	[C_SECT],BX		; SET ACTIVE SECTORS
	SUB	CX,BX
	MOV	[C_ACT_DIS],CX		; SET NONE ACTIVE SECTORS
;----------------------------------------------------------------------
	RET
	PAGE
;
;*******************************************
;
;	SET TRANS LENGTH
;
;*******************************************
;
SET_LENGTH:
;----------------------------------------------CHANGE JUN/12/84--------
;============ GET REMAIN BYTE TO 64KB BOUNDARY (BY SECTOR BOUNDARY)==
	MOV	AX,[SI.DTS]		; AX=(DTS)*16+(DTA)
	MOV	CL,4
	SHL	AX,CL
	ADD	AX,[SI.DTA]
	NEG	AX			; AX=64KB - AX (REMAIN TO 64KB)
	JNZ	SET_LENGTH1		; DECREMENT IF JUST 64KB
	DEC	AX			; AX=65535
SET_LENGTH1:
	MOV	DX,0
	DIV	WORD PTR [SI.BPB]	; DEVIDE SECTOR SIZE
;===============SELECT SMALL VALUE======
	MOV	CX,[C_SECT]		; CX=REMAIN SECTORS
	CMP	AX,CX			; REMAIN =< ENABLE ?
	JBE	SET_LENGTH2		; YES.
	MOV	AX,CX
SET_LENGTH2:
	MOV	[C_TRNS],AX		; SET SECTOR NUMBER
	MUL	WORD PTR [SI.BPB]
	MOV	[SI.DTL],AX		; SET DATA LENGTH
;----------------------------------------------------------------------
	RET
	PAGE
;**************************************************
;	SECTOR UPDATE
;		UPDATE TRANS BUFF ADRS
;		DECRIMENT LOGICAL SECTOR
;		INCRIMENT PHYSICAL SECTOR
;**************************************************
;
SCT_UP:
;----------------------------------------------CHANGE JUN/12/84--------
	MOV	AX,[C_TRNS]		;
	ADD	WORD PTR [SI.CRNT+0],AX	; ADD CURRENT SECTOR ADDRESS
	ADC	WORD PTR [SI.CRNT+2],0	;
	SUB	[C_SECT],AX		; DECREMENT REMAIN SECTOR NUMBER
	MOV	AX,[SI.DTL]		;
	ADD	[SI.DTA],AX		; ADD TRANSFER ADDRESS (OFFSET)
	JNC	SET_UP1
	ADD	[SI.DTS],1000H		; ADD SEGMENT IF OFFSET OVER
SET_UP1:
;----------------------------------------------------------------------
	RET
	PAGE
;
;**********************************************
;
;	READ ONE LOGICAL SECTOR
;
;**********************************************
;
SCT_RD:
;----------------------------------------------------CHANGE JUN/12/84--
	CMP	[C_TRNS],0		; 64KB BOUNDARY
	JZ	SCT_RD1
;----------------------------------------------------------------------
	CALL	READ			; READ COMMAND
	JC	SCT_RD2
	RET
;
SCT_RD1:
;---------------------------------------------------CHANGE JUN/12/84---
	INC	[C_TRNS]		; READ ONE SECTOR
	MOV	CX,WORD PTR [SI.BPB]
	MOV	[SI.DTL],CX

	MOV	DI,[SI.DTA]		; ES:DI = CURRENT TRANS ADDRESS
	AND	DI,000FH		;  DI=(SI.DTA) and 000Fh
	MOV	AX,[SI.DTA]		;  ES=(SI.DTA)/16+(SI.DTS)
	MOV	CL,4
	SHR	AX,CL
	ADD	AX,[SI.DTS]
	MOV	ES,AX
;---------------------------------------------------------------------
	PUSH	ES			; SAVE CURRENT TRANS ADDRESS
	PUSH	DI
	LES	DI,CS:[DSK_BUF_ADR]	; EXCHANGE TRANS ADDR. TO PROGRAM BUFFER
	MOV	[SI.DTA],DI
	MOV	[SI.DTS],ES
	CALL	READ			; READ COMMAND
	POP	DI			; RESTORE TRANS ADDRESS
	POP	ES
	MOV	[SI.DTA],DI
	MOV	[SI.DTS],ES
	JC	SCT_RD2			; ERROR ?
					; MOVE DATA TO TRANS ADDRESS
	MOV	CX,[SI.DTL]		;  SET DATA LENGTH
	LDS	SI,CS:[DSK_BUF_ADR]	;  SET SOURCE ADRS
	CLD
	REP	MOVSB
	LDS	SI,CS:[P_DCB]		; RESTORE DCB POINTER
	CLC				; [CF]=0
	RET
;
SCT_RD2:
	JMP	ERROR
	PAGE
;
;********************************************
;
;	WRITE ONE LOGICAL SECTOR
;
;********************************************
;
SCT_WR:
;---------------------------------------------------CHANGE JUN/12/84---
	CMP	[C_TRNS],0		; 64KB BOUNDARY ?
	JZ	SCT_WR1			; YES
;----------------------------------------------------------------------
	CALL	WRIT			; WRITE COMMAND
	JC	SCT_WR2
	RET
;
SCT_WR1:
;-------------------------------------------------CHANGE JUN/12/84-----
	INC	[C_TRNS]		; WRITE ONE SECTOR
	MOV	CX,WORD PTR [SI.BPB]
	MOV	[SI.DTL],CX

	MOV	AX,[SI.DTA]		; DS:SI=TRAND ADDRESS
	MOV	CL,4			;  DS=(SI.DTA)/16+(SI.DTS)
	SHR	AX,CL
	ADD	AX,[SI.DTS]
	MOV	CX,[SI.DTL]		; CX=DATA LENGTH
	MOV	SI,[SI.DTA]		;  SI=(SI.DTA) and 000Fh
	AND	SI,000FH
	MOV	DS,AX
;----------------------------------------------------------------------
					; MOVE DATA TO PROGRAM BUFFER
	LES	DI,CS:[DSK_BUF_ADR]	;  ES:DI=PROGRA BUFFER ADDRESS
	CLD
	REP	MOVSB
	LDS	SI,CS:[P_DCB]		; RESTORE DCB POINTER
	LES	DI,DWORD PTR [SI.DTA]	; SAVE TRAND ADDRES
	PUSH	ES
	PUSH	DI
	LES	DI,CS:[DSK_BUF_ADR]	; EXCHANGE TRANS ADDRESS TO USER BUFFER
	MOV	[SI.DTA],DI
	MOV	[SI.DTS],ES
	CALL	WRIT			; WRITE COMMAND
	POP	DI			; RESTORE TRANS ADDRESS
	POP	ES
	MOV	[SI.DTA],DI
	MOV	[SI.DTS],ES
	JC	SCT_WR2			; ERROR ?
	RET
;
SCT_WR2:
	JMP	ERROR
;------------------------------------DELETE module "DBCHK" JUN/12/84---
	PAGE
;***************************************************
;	CONVERT TO MS-DOS ERROR
;		INPUT	[AH] : ROM BIOS ERROR CODE
;		OUTPUT[AL] : MS-DOS ERROR CODE
;***************************************************
;
ERROR:
	MOV	AL,AH
	MOV	CL,4
	SHR	AL,CL
	MOV	BX,OFFSET ERR_TBL	; SET ERROR TABLE
	XLAT	BYTE PTR CS:[BX]	; GET MS-DOS ERROR CODE
	STC				; [CF]=1
	RET
;
ERR_TBL:
	DB	12,12,12,12,02,00,12,12,12,12,04,04,06,08,08,08
	PAGE
;
;*******************************************
;
;	DISK I/O COMMAND
;
;*******************************************
;
;
READ:
	MOV	AH,26H			; SET READ COMMAND
	JMP	SHORT RTRY
WRIT:
	MOV	AH,25H			; SET WRIT COMMAND
	JMP	SHORT RTRY
VRFY:
	MOV	AH,21H			; SET VERIFY COMMAND
;
RTRY:
	MOV	[SI.BCMD],AH		; SAVE COMMAND CODE
	MOV	AL,[SI.DAUA]		; SET DA/UA
	MOV	CX,WORD PTR [SI.CRNT]	; SET (CRNT)
	MOV	DX,WORD PTR [SI.CRNT+2]
	MOV	BX,[SI.DTL]		; SET (DTL)
	LES	BP,DWORD PTR [SI.DTA]	; SET (DTA)
;
	MOV	C_RTRY,8		; SET RETRY COUNT
RTRY1:
	MOV	AH,[SI.BCMD]		; SET COMMAND
	INT	HD_ROM
	MOV	[SI.STS],AH		; SAVE RETURN STATUS
	JNC	RTRY3			; JUMP IF NOT ERROR
	CMP	AH,60H			; CANNOT RETRY ?
	JB	RTRY2			; YES,
	DEC	C_RTRY			; END OF RETRY ?
	JZ	RTRY2			; YES,
	MOV	AH,27H			; RECALIBRATE
	INT	HD_ROM
	MOV	[SI.STS],AH		; SAVE RETURN STATUS
	JNC	RTRY1			; LOOP IF NOT ERROR
RTRY2:
	STC				; [CF]=1
RTRY3:
	RET
;
SENS:
	MOV	AH,24H			; SET SENSE COMMAND
	MOV	[SI.BCMD],AH		; SAVE COMMAND
	MOV	AL,[SI.DAUA]
	INT	HD_ROM
	MOV	[SI.STS],AH		;SAVE RETURN STATUS
	RET
;
CODE	ENDS
	END
;

