/* -*-c,save-*- */
/*
 * cardpak.c - card package
 * Robert Heller. Created: Sun Mar 9, 1986 17:08:04.73
 * Last Mod: 
 * 
 * (c) Copyright 1986 by Robert Heller
 *     All Rights Reserved
 * 
 * 
 */

#include <stdio.h>

#define LOCAL static

/* #define DEBUG /* debugging */

#ifdef DEBUG
#define LOCAL /* static */
#endif

LOCAL char FULL_DECK[261],RANDOM_DECK[261],ALL_VALS[14],JUST_VALS[261],
	   JUST_SUITS[261];
LOCAL char ENCVALS[14];

int decktype = 0;

card_ini()
{
    register char *p,c;
    register int i;

    if (decktype == 0) {	/* standard deck */
	for (p=FULL_DECK,c='a';c<='z';p++,c++) *p = c;
	for (c='A';c<='Z';c++,p++) *p = c;
	}
    else if (decktype = 1) { /* blackjack - five decks */
	for (p=FULL_DECK,i=0;i<5;i++) {
	    for (c='a';c<='z';p++,c++) *p = c;
	    for (c='A';c<='Z';c++,p++) *p = c;
	    }
	}
    else if (decktype = 2) { /* pinocle */
	p = FULL_DECK;
	for (c='a';c<='x';c++,p++) *p = c; 
	for (c='A';c<='X';c++,p++) *p = c; 
	}
    else {
	fprintf(stderr,"cardpak: bad deck type %d\n",decktype);
	abort(decktype);
	}
    *p = '\0';
    if (decktype == 0 || decktype == 1)
	for (p=ALL_VALS,c='A';c<='M';p++,c++) *p = c;
    else for (p=ALL_VALS,c='A';c<='F';p++,c++) *p = c;
    *p = '\0';
    if (decktype == 0) dupl(ALL_VALS,4,JUST_VALS);
    else if (decktype == 1) dupl(ALL_VALS,20,JUST_VALS);
    else dupl(ALL_VALS,8,JUST_VALS);
    if (decktype == 0 || decktype == 1) strcpy(ENCVALS,"234567890JQKA");
    else strcpy(ENCVALS,"9JQK0A");
    p = JUST_SUITS;
    if (decktype == 0 || decktype == 1) {
	dupl("C",13,p);
	p += 13;
	dupl("D",13,p);
	p += 13;
	dupl("H",13,p);
	p += 13;
	dupl("S",13,p);
	p += 13;
	if (decktype == 1) {
	    for (i=0;i<4;i++) {
		strncpy(p,JUST_SUITS,52);
		p += 52;
		}
	    *p = '\0';
	    }
	}
    else {
	for (i=0;i<2;i++) {
	    dupl("C",6,p);
	    p += 6;
	    dupl("D",6,p);
	    p += 6;
	    dupl("H",6,p);
	    p += 6;
	    dupl("S",6,p);
	    p += 6;
	    }
	}
    RANDOM_DECK[0] = '\0';
    }
rhand(k,buff,flag)
register int k,flag;
register char *buff;
{
    if (flag) rpermutate(FULL_DECK,RANDOM_DECK);
    if (strlen(RANDOM_DECK) < k) return(FALSE);
    strncpy(buff,RANDOM_DECK,k);
    buff[k] = '\0';
    strcpy(RANDOM_DECK,&RANDOM_DECK[k]);
    return(TRUE);
    }
suits(h,out)
register char *h,*out;
{
    replace(h,FULL_DECK,JUST_SUITS,out);
    }
vals(h,out)
register char *h,*out;
{
    replace(h,FULL_DECK,JUST_VALS,out);
    }
display(h,out)
register char *h,*out;
{
    char VALS[54],SUITS[54];
    register char *v,*s,*o;

    vals(h,VALS);
/*			   abcdefghijklm
			   nopqrstuvwxyz
			   ABCDEFGHIJKLM
			   NOPQRSTUVWXYZ  */
    if (decktype == 0 || decktype == 1)
	replace(VALS,ALL_VALS,"23456789TJQKA",VALS);
    else
	replace(VALS,ALL_VALS,"9JQKTA",VALS);
    suits(h,SUITS);
    for (v=VALS,s=SUITS,o=out;*v != '\0';v++,s++) {
	if (*v == 'T') {
	    *o++ = '1'; *o++ = '0';
	    }
	else *o++ = *v;
	*o++ = *s;
	*o++ = ' ';
	}
    *o = '\0';
    }
enchand(h,ench)
register char *h;
char *ench;
{
    register char v,s,*sbase,*vbase;
    char *strchr();

    while (*h != '\0') {
#ifdef DEBUG
	printf("***In enchand(): h=%s\n",h);
#endif
	if (*h == '1') h++;
	v = *h++; s = *h++;
#ifdef DEBUG
	printf("***              v=%c, s=%c\n",v,s);
#endif
	sbase = strchr(JUST_SUITS,s);
	vbase = strchr(ENCVALS,v);
	if (vbase == 0L || sbase == 0L) return(0);
	*ench++ = FULL_DECK[(sbase-JUST_SUITS) + (vbase - ENCVALS)];
#ifdef DEBUG
	printf("***             card=%c\n",*(ench-1));
#endif
	while (*h <= ' ' && *h > '\0') h++;
	}
    *ench = '\0';
    return(1);
    }


                                                                                                          