;============================ P-SURF.LSP ================================
;
;  Patch surface routine for use with AutoCAD Version 2.6
;
;  Written by John Lynch   November, 1986
;
;
(defun C:P-SURF()
  (setq fl (entget (car (entsel "\nEnter the the first line: "))))
  (setq sl (entget (car (entsel "\nEnter the the second line: "))))

  (setq nrow (getint "\nEnter number of faces ALONG lines: "))
  (setq ncol (getint "\nEnter number of faces BETWEEN lines: "))
  (setvar "cmdecho" 0)
  (setvar "blipmode" 0)

;
;Initilize the beginning points and determine the vecors along the lines.
;
  (setq bp1 (cdr (assoc 10 fl))
        ep1 (cdr (assoc 11 fl))
        bp2 (cdr (assoc 10 sl))
        ep2 (cdr (assoc 11 sl))
        vl1 (vector ep1 bp1 nrow)
        vl2 (vector ep2 bp2 nrow)
        vpl1 (vector bp2 bp1 ncol)
   )
;
;
;
  (setq m 1)
  (while (<= m nrow)
;
     (setq
        pl1 (vectadd bp1 vl1)
        pl2 (vectadd bp2 vl2)
        vpl2 (vector pl2 pl1 ncol)
     )
;
;---- Initialize the face points
;
     (setq lpp1 bp1
           lpp2 pl1
           n 1
     )
;
;
    (while (<= n ncol)
      (setq upp1 (vectadd lpp1 vpl1)
            upp2 (vectadd lpp2 vpl2)
      )
      (command "3dface" lpp1 lpp2 upp2 upp1 "")
      (setq lpp1 upp1
            lpp2 upp2
            n (1+ n)
      )
    )

  (setq bp1 pl1
        bp2 pl2
        vpl1 vpl2
        m (1+ m)
   )
  )
  (setvar "cmdecho" 1)
  (setvar "blipmode" 1)
)


;---------------------- VECTOR() -----------------------------
; Function to determine a vector between two point and divided by m.
;
(defun vector (ep bp m / x1 x2 y1 y2 z1 z2 dx dy dz)
;
; bp : The beginnning point of the line.
; ep : The end point of the line.
; m  : The number of divisions in the line.
;
;
;
  (setq x1 (car bp)
        y1 (cadr bp)
        z1 (caddr bp)
  )
  (setq x2 (car ep)
        y2 (cadr ep)
        z2 (caddr ep)
  )
;
  (setq dx (/ (- x2 x1) m)
        dy (/ (- y2 y1) m)
        dz (/ (- z2 z1) m)
  )
  (list dx dy dz)
;
)

;-----------------------------VECTADD() ------------------------------
;  Function to add a vector to a point.
;
(defun vectadd(bp vec / x1 x2 y1 y2 z1 z2 dx dy dz)
;
; bp  : Beginning point assumed to be a list of three reals.
; vec : Vector to add to the point assumed to be the same.
  (setq x1 (car bp)
        y1 (cadr bp)
        z1 (caddr bp)
  )
  (setq x2 (car vec)
        y2 (cadr vec)
        z2 (caddr vec)
  )
;
  (setq dx (+ x1 x2)
        dy (+ y1 y2)
        dz (+ z1 z2)
  )
  (list dx dy dz)
)





