1000 REM
1010 REM         General Attribute Report Program
1020 REM
1030 REM   Designed and implemented by Kelvin Throop on Labour Day, 1984
1040 REM
1050 REM
1060 REM This program scans a "DXF" format attribute extract file (.DXX), and
1070 REM lacking prior knowledge of the attribute definitions, produces a
1080 REM reasonable report of the attributes used in the program.  It makes
1090 REM two scans of the .DXX file.  On the first, it builds a list of all
1100 REM attribute tags used and the maximum length of any value for each
1110 REM tag.  Between passes, it sorts the attribute tags into alphabetical
1120 REM order.  On the second pass, the actual report is printed, with the
1130 REM tags as column headings, and the attributes for blocks edited one
1140 REM per line.  Attributes not used by a block will appear as blank.
1150 REM
1160 REM A sample "DXF" format file can be extracted via the ACAD "ATTEXT"
1170 REM command fromt the sample drawing "COUNTER.DWG".  Be sure to specify
1180 REM DXF format output when requested.
1190 REM
1200 MXTAGS%=20
1210 DIM MTAG$(MXTAGS%),MLEN%(MXTAGS%),MVAL$(MXTAGS%)
1220 MTAGS%=0
1230 MINUS$="-"
1240 FOR I%=1 TO 7
1250 MINUS$=MINUS$+MINUS$
1260 NEXT I%
1270 LINE INPUT "Enter extract file name: "; F$
1280 F$=F$+".dxx"
1290 OPEN "i",1,F$
1300 REM
1310 REM Scan the extract file and build a list of attribute
1320 REM tag names and maximum value lengths.
1330 REM
1340 IF EOF(1) THEN 1560
1350 INPUT #1,FT%
1360 IF FT%<>0 THEN LINE INPUT #1,A$ : GOTO 1340
1370 LINE INPUT #1,FA$
1380 IF FA$<>"ATTRIB" THEN 1340
1390 GTAG%=0
1400 GVAL%=0
1410 IF GTAG%>0 AND GVAL%>0 THEN 1470
1420 INPUT #1,FT%
1430 LINE INPUT #1,A$
1440 IF FT%=1 THEN GVAL%=1 : AVAL$=A$ : GOTO 1410
1450 IF FT%=2 THEN GTAG%=1 : ATAG$=A$ : GOTO 1410
1460 GOTO 1410
1470 FOR I%=1 TO MTAGS%
1480  IF MTAG$(I%)=ATAG$ THEN 1530
1490 NEXT I%
1500 MTAGS%=MTAGS%+1
1510 MTAG$(MTAGS%)=ATAG$
1520 I%=MTAGS%
1530 IF LEN(AVAL$)>MLEN%(I%) THEN MLEN%(I%)=LEN(AVAL$)
1540 IF LEN(ATAG$)>MLEN%(I%) THEN MLEN%(I%)=LEN(ATAG$)
1550 GOTO 1340
1560 REM End pass 1 scan
1570 CLOSE 1
1580 REM
1590 REM Sort the attribute tags alphabetically
1600 REM
1610 FOR I%=1 TO MTAGS%
1620  FOR J%=I%+1 TO MTAGS%
1630   IF MTAG$(I%)>MTAG$(J%) THEN A$=MTAG$(I%) : MTAG$(I%)=MTAG$(J%) : MTAG$(J%)=A$ : Q%=MLEN%(I%) : MLEN%(I%)=MLEN%(J%) : MLEN%(J%)=Q%
1640  NEXT J%
1650 NEXT I%
1660 REM 
1670 REM Build actual output report
1680 REM
1690 OPEN "i",1,F$
1700 GDAT%=0
1710 K%=0
1720 FOR I%=1 TO MTAGS%
1730  K%=K%+MLEN%(I%)+1
1740  MLEN%(I%)=K%+1
1750 NEXT I%
1760 CLS
1770 FOR I%=1 TO MTAGS%
1780  PRINT MTAG$(I%);TAB(MLEN%(I%));
1790 NEXT I%
1800 PRINT
1810 K%=1
1820 FOR I%=1 TO MTAGS%
1830 L%=MLEN%(I%)-K% : K%=MLEN%(I%)
1840  PRINT LEFT$(MINUS$,L%-1);TAB(MLEN%(I%));
1850 NEXT I%
1860 PRINT
1870 PRINT
1880 IF EOF(1) THEN 2110
1890 INPUT #1,FT%
1900 IF FT%<>0 THEN LINE INPUT #1,A$ : GOTO 1880
1910 LINE INPUT #1,FA$
1920 IF FA$<>"INSERT" THEN 1970
1930 GOSUB 2150
1940 FOR I%=1 TO MTAGS%
1950  MVAL$(I%)=""
1960 NEXT I%
1970 IF FA$<>"ATTRIB" THEN 1880
1980 GTAG%=0
1990 GVAL%=0
2000 IF GTAG%>0 AND GVAL%>0 THEN 2060
2010 INPUT #1,FT%
2020 LINE INPUT #1,A$
2030 IF FT%=1 THEN GVAL%=1 : AVAL$=A$ : GOTO 2000
2040 IF FT%=2 THEN GTAG%=1 : ATAG$=A$ : GOTO 2000
2050 GOTO 2000
2060 FOR I%=1 TO MTAGS%
2070  IF MTAG$(I%)=ATAG$ THEN MVAL$(I%)=AVAL$
2080 NEXT I%
2090 GDAT%=1
2100 GOTO 1880
2110 GOSUB 2150
2120 CLOSE 1
2130 PRINT : PRINT
2140 END
2150 REM
2160 REM Print line of report
2170 REM
2180 IF GDAT%=0 THEN RETURN
2190 CPOS%=0
2200 FOR I%=1 TO MTAGS%
2210  PRINT MVAL$(I%);TAB(MLEN%(I%));
2220 NEXT I%
2230 PRINT
2240 RETURN
