
;
;                            PRNTYPE
;
;
;    Detect if active parallel ports and identify those ports 
;    which support extended mode
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc

cseg    segment para public
        assume  cs:cseg, ds:cseg

        org     100h               ; Assemble into a COM file.


start:
        jmp     begin

msg1    db      CR, LF, CR, LF, TAB, TAB
        db      '   PRNTYPE - Parallel Port Analysis'
        db      CR, LF, CR, LF, TAB, TAB
        db      'Parallel Port    Active?    Extended Mode?'
        db      CR, LF, TAB, TAB
        db      '        '
        db      CR, LF, '$'

msg2    db      TAB, TAB, '#'
msgnum  db       '1       '
msghigh dw      '  '  
msglow  dw      '  '      
        db                   '      '
msgon   db                         'No            '
msgExt  db                                       'No '
        db      CR, LF, '$'

msg3    db      TAB, TAB
msg3num db      '#4  Likely Extended BIOS data area segment'
        db      CR, LF, '$'


prntype proc   near

begin:
        push    cs
        pop     ds
        OUTMSG  msg1               ; display initial message

        mov     ax, 40h
        mov     es, ax             ; ES used for BIOS segment

        mov     cl, '1'            ; printer number to check
        mov     si, 0              ; index for printer address

prnex_loop:
        mov     msgnum, cl         ; insert printer number
        mov     msghigh, '  '
        mov     msglow, '  '       ; blank port number
        MSGNO   msgon              ; assume not active
        MSGNO   msgExt             ; assume no extended support

        mov     dx, es:[si+8]      ; get parallel port address
        cmp     dx, 0              ; is parallel port active ?
        je      prnex_output       ; jump if not
        cmp     cl, '4'            ; last port ?
        jne     prnex_ok           ; jump if not
        cmp     dx, 1000h          ; port num too high ?
        ja      prnex_bios         ; if so, extended BIOS data 
prnex_ok:
        MSGYES  msgon              ; parallel port active

        mov     bx, offset msghigh ; insert port number in line
        mov     al, dh             
        call    hex                ; convert to ASCII
        mov     bx, offset msglow
        mov     al, dl
        call    hex                ; convert to ASCII

                                   ; now check extended support
        add     dx, 2              ; set to control port
        in      al, dx
        IODELAY
        mov     ah, al             ; save value to restore later
        or      al, 20h            
        out     dx, al             ; set extended read bit 5 on

        sub     dx, 2              ; dx = read/write port #
        mov     al, 55h
        out     dx, al             ; send value 55h 
        IODELAY
        in      al, dx
        cmp     al, 55h            ; read matches prior write ?
        jne     prnex_extended     ; jump if not

        mov     al, 0AAh
        out     dx, al             ; send value AAh 
        IODELAY
        in      al, dx
        cmp     al, 0AAh           ; read matches prior write ?
        je      prnex_restore      ; if so, no extended mode

prnex_extended:
        MSGYES  msgExt             ; port supports extended mode

prnex_restore:
        add     dx, 2
        mov     al, ah
        out     dx, al             ; restore to original state
        jmp     prnex_output

prnex_bios:
        OUTMSG  msg3               ; Extended BIOS data area
        jmp     exit               ; done!

prnex_output:
        OUTMSG  msg2               ; display port line
        add     si, 2              ; next index 
        inc     cl
        cmp     cl, '4'            ; are we done yet!
        ja      exit               ; jump if so
        jmp     prnex_loop         ; go for next port

exit:
        mov     ah, 4Ch
        int     21h                ; exit
prntype endp


;
;    HEX
;       convert the hex number in al into two ascii characters
;       at ptr in bx
;
;       Called with:    al = input hex number
;                       bx = ptr where to put ascii
;
;       Regs Used:      al,bx

hex     proc    near
        push    bx
        mov     bl, al
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bh, al

        mov     al, bl             ; upper nibble
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bl, al
        mov     ax, bx
        pop     bx
        mov     [bx], ax           ; output ascii bytes
        ret
hex     endp

cseg    ends
        end     start

