
;
;                            KEYBIOS
;
;
;    See if the interrupt 16h system BIOS supports the extended
;    keyboard and related functions (functions 5, 9, 10h, 11h,
;    and 12h).  Two subroutines KEYTYPE and KEY9 are used to
;    make these determinations.
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:stackx

keybios         proc near

message1 db     'No BIOS support for extended keyboard.'
         db     CR, LF, '$'

message2 db     CR, LF
         db     'Keyboard BIOS, interrupt 16h, supports'
         db     ' extended functions 5, 10h, 11h, and 12h.'
         db     CR, LF, '$'

message3 db     'Keyboard BIOS, interrupt 16h, also'
         db     ' supports extended function 9.'
         db     CR, LF, '$'



start:
        push    cs
        pop     ds
        call    keytype            ; ah = 0 if ok
                                   ; ah = 1 if failed
        cmp     ah, 0
        jne     key_bad
        OUTMSG  message2           ; display ok message
        call    key9               ; function 9 supported?
        cmp     ah, 0
        jne     key_exit           ; jump if not
        OUTMSG  message3
        jmp     key_exit

key_bad:
        OUTMSG  message1           ; display bad message
key_exit:
        mov     ah, 4Ch
        int     21h                ; exit
keybios endp


;
;    KEYTYPE
;       Find out if keyboard BIOS supports extended functions
;       interrupt 16h, functions 5, 10h, 11h, and 12h.  To do
;       this, the keyboard buffer is flushed, and any prior
;       keys are discarded.  The routine then tries to stuff
;       the key value FFFF into the buffer and read it using
;       the keyboard BIOS extended key functions.
;
;       Returns:        if ah=0, extended functions supported
;                       if ah=1, extended function not supported
;
;       Regs Used:      ax

keytype proc    near
        push    cx
key_loop1:
        mov     ah, 1           ; function 1, get status
        int     16h
        jz      key_try5        ; jump if no keys in buffer
        mov     ah, 0           ; function 0, get key
        int     16h             ; discard key
        jmp     key_loop1       ; loop until buffer empty

key_try5:
        mov     ah, 5           ; try function 5
        mov     cx, 0FFFFh      ; put in bogus key value
        int     16h
        cmp     al, 0           ; al = 0 ok, 1 failed
        ja      key_no_ext

        mov     cx, 16          ; try up to 16 times
key_loop2:
        mov     ah, 11h         ; function 11h, get status
        int     16h
        jz      key_no_ext      ; jump if no key in buffer
        mov     ah, 10h         ; function 10h, get key
        int     16h
        cmp     ax, 0FFFFh      ; did key appear ?
        je      key_ok          ; jump if so, success!
        loop    key_loop2       ; try next key

; extended BIOS functions not supported

key_no_ext:
        mov     ah, 1
        jmp     key_ret

; the keyboard BIOS does support extended functions

key_ok:
        xor     ah, ah
key_ret:
        pop     cx
        ret
keytype endp


;
;    KEY9
;       Find out if keyboard BIOS supports extended functions
;       interrupt 16h, function 9.  This determination is
;       made after it is determined that other extended
;       functions are supported.  In addition, it uses int 15h
;       function C0h to make this determination.
;
;       Returns:        if ah=0, extended function 9 supported
;                       if ah=1, extended function 9 not
;                                supported
;
;       Regs Used:      ax

key9    proc    near
        push    bx
        push    es
        mov     ah, 0C0h        ; get ptr es:bx to the
        int     15h             ;  ROM configuration
        jc      key9_not        ; jump if not supported
        test    byte ptr es:[bx+6], 40h  ; check for support
        jz      key9_not        ; jump if not supported

; interrupt 16h, function 9 is supported

        mov     ah, 0
        jmp     key9_exit

key9_not:
        mov     ah, 1
key9_exit:
        pop     es
        pop     bx
        ret
key9 endp


cseg    ends

;================================================== stack ======

stackx   segment para stack

        db      192 dup (0)

stackx   ends


        end     start

