
;
;                            CPURDTSC
;
;    The Pentium processor uses a new instruction RDTSC to read
;    the Time Stamp Counter.  This routine displays the values
;    from the Time Stamp Counter until Ctrl-Break pressed.
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:stacka

; DATA AREA 

;  general data

        db      'CPURDTSC v1.00 '
        db      '(c) 1994 Frank van Gilluwe',0

cpuhead db      CR, LF, CR, LF
        db      'READ TIME STAMP COUNTER         '
        db      '                        v1.00 (c) 1994 FVG'
        db      CR, LF
        db      ''
        db      ''
        db      CR, LF, CR, LF, '$'



below586  db    'No checks made.'
          db    '  CPU must be a Pentium for this test.'
          db    CR, LF, '$'

aborted   db    CR, LF, CR, LF
          db    'Test aborted due to Ctrl-Break.'
          db    CR, LF, '$'

failed    db    CR, LF, CR, LF
          db    'Instruction not implemented.'
          db    CR, LF, '$'

cpurdtsc1 db    'This routine shows the current contents '
          db    'of the Time Stamp Counter ', CR, LF
          db    '(opcode 0Fh, 31h).  Use Ctrl-Break to '
          db    'stop test.'
          db    CR, LF, CR, LF
          db    'EDX:EAX value returned:', LF, '$'

tscval2   db    CR
tscvalue  db    '00000000:00000000h$'


cpu_val  db     0                  ; CPU value from CPUVALUE
                                   ;   0 = 8088/8086 or V20/V30
                                   ;   1 = 80186/80188
                                   ;   2 = 80286
                                   ;   3 = 80386
                                   ;   4 = 80486
                                   ;   5 = Pentium

cpu_info db     0                  ; flags from CPUVALUE
                                   ;   bit 0 = 1 if CPUID ok
                                   ;       1 = 1 if V20/V30 CPU

cmd_line db     0

old_int6_seg dw 0                  ; temp storage for old int 6
old_int6_off dw 0                  ;  vector (bad opcode)
old_intD_seg dw 0                  ; temp storage for old int D
old_intD_off dw 0                  ;  vector (protection fault)

badoff       dw 0                  ; temp return offset if bad
                                   ;  opcode interrupt 6 called

int_mask     db 0                  ; save area for interrupt mask


; CODE START 

.286

cpurdtsc proc    far

start:
        cmp     byte ptr ds:[80h], 1  ; any option ?
        jbe     cf_skp0            ; jump if none
        mov     bl, ds:[82h]       ; get option on cmd line
        mov     cs:[cmd_line], bl  ; save option
cf_skp0:
        mov     ax, cs
        mov     ds, ax
        mov     es, ax
        OUTMSG  cpuhead            ; output header message

; get cpu type and cpumode, and save results

        call    cpuvalue           ; get CPU type 0 to 5 in al
        mov     [cpu_val], al      ; save
        mov     [cpu_info], ah     ; save flags

        cmp     [cpu_val], 5       ; Pentium or later ?
        jae     cf_skp1
        jmp     cf_exit1           ; exit if below Pentium

; set up control-break, since this routine can take awhile

cf_skp1:
        push    ds
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset cf_cntrl_break
        mov     ax, 2523h          ; set interrupt 23h
        int     21h
        pop     ds

        mov     ax, 3301h          ; set ctrl-break checking on
        mov     dl, 1
        int     21h

; set up bad-opcode intercept and general protection fault

        mov     ax, offset cf_bad       ; goto ct_bad if int occurs
        mov     [badoff], ax
        call    hook_int6
        call    hook_intD

; On a Pentium or later, test the Read Time Stamp Register RDTSC

.386
        OUTMSG  cpurdtsc1

cf_skp3:
        call    ct_testit          ; go test the instruction &
                                   ;   display result
        jmp     cf_skp3            ; infinite loop (until ctrl-break)

; comes here if instruction invalid

cf_bad:
        OUTMSG  failed             ; not implemented
        call     restore_int6
        call     restore_intD
        jmp      cf_exit

; comes here if cntrl-break pressed

cf_cntrl_break:
        call     restore_int6
        call     restore_intD
        OUTMSG  aborted
        jmp     cf_exit            ; done!

cf_exit1:
        OUTMSG  below586           ; no test for CPU

cf_exit:
        mov     ah,4Ch
        int     21h                ; exit with al return code
cpurdtsc endp


;
;    Test RDTSC and display result
;
;       Called with:    nothing
;
;       Returns:        Updates display

ct_testit proc  near
        push    di

; The instruction to test

        RDTSC                      ; get time stamp register

; only get here if instruction was not a bad opcode!
; insert EDX:EAX value into output line

        push    eax
        mov     eax, edx
        mov     di, offset tscvalue
        mov     cx, 4              ; four bytes to convert
ct_loop1:
        rol     eax, 8             ; get byte
        call    hex2ascii
        mov     [di], bx
        add     di, 2
        loop    ct_loop1

        inc     di                 ; skip over colon
        pop     eax
        mov     cx, 4              ; four bytes to convert
ct_loop2:
        rol     eax, 8             ; get byte
        call    hex2ascii
        mov     [di], bx
        add     di, 2
        loop    ct_loop2
        OUTMSG  tscval2
ct_skp3:
        pop     di
        ret
ct_testit endp


;
;    HOOK INTERRUPT 6
;       Save the old interrupt 6 vector and replace it with
;       a new vector to the bad_op_handler.  Vectors are handled
;       directly without using DOS.
;
;       Called with:    nothing
;
;       Returns:        vector hooked
;                       old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;
;       Regs used:      none

hook_int6 proc    near
        push    ax
        push    cx
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     ax, es:[6*4]       ; get offset of int 6
        mov     cx, es:[6*4+2]     ; get segment
        mov     word ptr es:[6*4], offset bad_op_handler
        mov     word ptr es:[6*4+2], seg bad_op_handler
        sti                        ; enable interrupts
        mov     [old_int6_seg], cx ; save original vector
        mov     [old_int6_off], ax
        pop     es
        pop     cx
        pop     ax
        ret
hook_int6 endp


;
;    RESTORE INTERRUPT 6
;       Restore the previously saved old interrupt 6 vector.
;       Vectors handled directly without using DOS.
;
;       Called with:    old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;
;       Returns:        vector restored
;
;       Regs used:      none

restore_int6 proc    near
        push    ax
        push    cx
        push    dx
        mov     cx, [old_int6_seg] ; get original vector
        mov     dx, [old_int6_off]
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     es:[6*4], dx       ; restore original int 6
        mov     es:[6*4+2], cx
        sti                        ; enable interrupts
        pop     es
        pop     dx
        pop     cx
        pop     ax
        ret
restore_int6 endp


;
;    BAD OFFSET INTERRUPT HANDLER
;       If a bad opcode occurs (80286 or later) will come here.
;       The saved BADOFF offset is used to goto the routine
;       previously stored in BADOFF.
;
;       In a few cases, it is also used for double faults. A few
;       instructions (RDTSC & WRMSR) can issue a double fault if
;       not supported, so may come here as well.
;
;       Called with:    cs:[badoff] previously set
;
;       Returns:        returns to address stored in badoff


bad_op_handler proc far
        push    ax
        push    bp
        mov     ax, cs:[badoff]
        mov     bp, sp
        mov     ss:[bp+4], ax      ; insert new return offset
        pop     bp
        pop     ax
        iret
bad_op_handler endp


;
;    HOOK INTERRUPT D
;       Save the current interrupt mask state, and mask off
;       interrupt D (General Protection Fault).  Also save
;       the old interrupt D vector and replace it with  a new
;       vector to bad_op_handler.  Vectors are handled
;       directly without using DOS.
;
;       NOTE: This is only effective if in Real Mode.  If in
;       V86 mode, the memory manager will not pass the fault
;       into this routine.
;
;       Called with:    nothing
;
;       Returns:        vector hooked
;                       old vector stored at
;                         ds:[old_intD_seg]
;                         ds:[old_intD_off]
;                       interrupt mask stored at
;                         ds:[int_mask]
;
;       Regs used:      none

hook_intD proc    near
        push    ax
        push    cx
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts

        in      al, 21h            ; get current interrupt mask
        mov     [int_mask], al     ; save
        IODELAY
        or      al, 20h            ; set bit to disable hardware
        out     21h, al            ;  IRQ 5 (interrupt D)
                                   ; Now change the vector
        mov     ax, es:[0Dh*4]     ; get offset of int D
        mov     cx, es:[0Dh*4+2]   ; get segment
        mov     word ptr es:[0Dh*4], offset bad_op_handler
        mov     word ptr es:[0Dh*4+2], seg bad_op_handler
        sti                        ; enable interrupts
        mov     [old_intD_seg], cx ; save original vector
        mov     [old_intD_off], ax
        pop     es
        pop     cx
        pop     ax
        ret
hook_intD endp


;
;    RESTORE INTERRUPT D
;       Restore the previously saved old interrupt D vector
;       and restore the interrupt mask to it's prior state
;       Vectors handled directly without using DOS.
;
;       Called with:    old vector stored at
;                         ds:[old_intD_seg]
;                         ds:[old_intD_off]
;                       interrupt mask stored at
;                         ds:[int_mask]
;
;       Returns:        vector restored
;
;       Regs used:      none

restore_intD proc    near
        push    ax
        push    cx
        push    dx
        mov     cx, [old_intD_seg] ; get original vector
        mov     dx, [old_intD_off]
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     es:[0Dh*4], dx     ; restore original int D
        mov     es:[0Dh*4+2], cx
                                   ; Now restore IRQ 5 mask
        in      al, 21h            ; get current interrupt mask
        mov     ah, [int_mask]     ; get previous mask
        IODELAY
        or      ah, 0DFh           ; set all but IRQ 5 bit
        and     al, ah             ; insert old IRQ 5 state
        out     21h, al            ;  IRQ 5 (interrupt D)

        sti                        ; enable interrupts
        pop     es
        pop     dx
        pop     cx
        pop     ax
        ret
restore_intD endp


;
;    CPU IDENTIFICATION SUBROUTINE
;       Identify the CPU, from 8088 to the P7.  Routine works
;       even if the 386 or later CPU is in V86 mode.  Note that
;       interrupts are enabled at exit, even if they were
;       disabled on entry.  If it is necessary to run this
;       routine with interrupts disabled, just remove all CLI
;       and STI instructions, so long as interrupts are
;       always disabled before running.
;
;       The "CPU class" is the class of CPU as specified by
;       the vendor.  It is a rough indicator of performance.
;
;       The "CPU standard instruction set" identifies the
;       highest level of Intel compatible instruction set
;       that can be used for the CPU.  For example, the
;       NexGen 5x86 has 586 level performance, but only
;       supports instructions defined for the Intel 80386.
;
;       Called with:    nothing
;
;       Returns:        al = CPU family
;                             0 if 8088/8086 or V20/V30
;                             1 if 80186/80188
;                             2 if 80286
;                             3 if 80386
;                             4 if 80486
;                             5 if Pentium/586
;                             6 if Pentium Pro/686
;                             7 if 786 (future)
;                             8 if 886 (future)
;                       ah =  bit 0 = 0 if CPUID unavailable
;                                     1 if CPUID ok
;                             bit 1 = 0 if not V20/V30
;                                     1 if NEC V20/V30
;                             bit 2 = 0 if no 486+ Alignment Check
;                                     1 supports Alignment Check
;                       bl = CPU standard instruction set
;                             0 if 8088/8086
;                             1 if 80186/80188
;                             2 if 80286
;                             3 if 80386
;                             4 if 80486
;                             5 if Pentium
;                             6 if Pentium Pro or better
;
;       Regs used:      ax, bx
;                       eax, ebx (386 or later)
;
;       Subs called:    hook_int6, restore_int6, bad_op_handler

.8086   ; all instructions 8088/8086 unless overridden later

cpuvalue proc    far
        push    cx
        push    dx
        push    ds
        push    es

; 8088/8086 test - Use rotate quirk - All later CPUs mask the CL
;   register with 0Fh, when shifting a byte by cl bits.  This
;   test loads CL with a large value (20h) and shifts the AX
;   register right.  With the 8088, any bits in AX are shifted
;   out, and becomes 0.  On all higher level processors, the
;   CL value of 20h is anded with 0Fh, before the shift.  This
;   means the effective number of shifts is 0, so AX is
;   unaffected.

        mov     cl, 20h            ; load high CL value
        mov     ax, 1              ; load a non-zero value in AX
        shr     ax, cl             ; do the shift
        cmp     ax, 0              ; if zero, then 8088/86
        jne     up186              ; jump if not 8088/86

; V20/V30 test - It is now either a V20/V30 or a 8088.  I'll use
;   another undocumented trick to find out which.  On the 8088,
;   0Fh performs a POP CS.  On the V20/V30, it is the start of
;   a number of multi-byte instructions.  With the byte string
;   0Fh, 14h, C3h the CPU will perform the following:
;               8088/8086               V20/V30
;             pop     cs              set1   bl, cl
;             adc     al, 0C3h

        xor     al, al             ; clear al and carry flag
        push    cs
        db      0Fh, 14h, 0C3h     ; instructions (see above)
        cmp     al, 0C3h           ; if al is C3h then 8088/8086
        jne     upV20
        mov     ax, 0              ; set 8088/8086 flag
        jmp     uP_Exit

upV20:
        pop     ax                 ; correct for lack of pop cs
        mov     ax, 200h           ; set V20/V30 flag
        jmp     uP_Exit

; 80186/80188 test - Check what is pushed onto the stack with a
;   PUSH SP instruction.  The 80186 updates the stack pointer
;   before the value of SP is pushed onto the stack.  With all
;   higher level processors, the current value of SP is pushed
;   onto the stack, and then the stack pointer is updated.

up186:
        mov     bx, sp             ; save the current stack ptr
        push    sp                 ; do test
        pop     ax                 ; get the pushed value
        cmp     ax, bx             ; did SP change ?
        je      up286              ; if not, it's a 286+
        mov     ax, 1              ; set 80186 flag
        jmp     uP_Exit

; 80286 test A - We'll look at the top four bits of the EFLAGS
;   register.  On a 286, these bits are always zero.  Later
;   CPUs allow these bits to be changed.  During this test,
;   We'll disable interrupts to ensure interrupts do not change
;   the flags.

up286:
        cli                        ; disable interrupts
        pushf                      ; save the current flags

        pushf                      ; push flags onto stack
        pop     ax                 ; now pop flags from stack
        or      ax, 0F000h         ; try and set bits 12-15 hi
        push    ax
        popf                       ; set new flags
        pushf
        pop     ax                 ; see if upper bits are 0

        popf                       ; restore flags to original
        sti                        ; enable interrupts
        test    ax, 0F000h         ; were any upper bits 1 ?
        jnz     up386plus          ; if so, not a 286

; 80286 test B - If the system was in V86 mode, (386 or higher)
;   the POPF instruction causes a protection fault, and the
;   protected mode software must emulate the action of POPF. If
;   the protected mode software screws up, as occurs with a
;   rarely encountered bug in Windows 3.1 enhanced mode, the
;   prior test may look like a 286, but it's really a higher
;   level processor. We'll check if the protected mode bit is
;   on.  If not, it's guaranteed to be a 286.

.286P                              ; allow a 286 instruction
        smsw    ax                 ; get machine status word
        test    ax, 1              ; in protected mode ?
        jz      is286              ; jump if not (must be 286)

; 80286 test C - It's very likely a 386 or greater, but it is
;   not guaranteed yet.  There is a small possibility the system
;   could be in 286 protected mode so we'll do one last test. We
;   will try out a 386 unique instruction, after vectoring the
;   bad-opcode interrupt vector (int 6) to ourselves.

        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op3  ; where to go if bad
.386
        xchg    eax, eax           ; 32 bit nop (bad on 286)

        call    restore_int6       ; restore vector
        jmp     up386plus          ; only gets here if 386
                                   ;  or greater!

; Interrupt vector 6 (bad opcode) comes here if system is a
;   80286 (assuming the 286 protected mode interrupt 6 handler
;   will execute the bad-opcode interrupt).

upbad_op3:
        call    restore_int6
is286:
        mov     ax, 2              ; set 80286 flag
        jmp     uP_Exit

; CPUID test - If bit 21 is changeable, it indicates the CPU
;   supports the CPUID instruction.  During this test, we'll
;   disable interrupts to ensure no interrupt will change any
;   flags.

.586                               ; allow 486 instructions

up386plus:
        cli                        ; disable interrupts
        mov     cx, sp             ; save the current stack ptr
        and     sp, NOT 3          ; align stack, avoids AC fault
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 200000h       ; toggle bit 21
        push    eax
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        mov     sp, cx             ; restore stack ptr
        sti                        ; enable interrupts
        xor     dl, dl             ; DL = temp flag, 0=no CPUID
        xor     eax, ebx           ; check if bit changed
        jz      up386              ; jump if no change, no CPUID
        inc     dl                 ; set flag that CPUID is ok

; 80386 test - Bit 18 in EFLAGS is not settable on a 386, but is
;   changeable on the 486 and later CPUs.  Bit 18 is used to
;   flag alignment faults. During this test, we'll disable
;   interrupts to ensure no interrupt will change any flags.


up386:
        cli                        ; disable interrupts
        mov     cx, sp             ; save the current stack ptr
        and     sp, NOT 3          ; align stack, avoids AC fault
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 40000h        ; toggle bit 18, AC flag
        push    eax
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        mov     sp, cx             ; restore stack ptr
        sti                        ; enable interrupts
        xor     eax, ebx           ; check if bit changed
        jz      upNoAC             ; no Alignment Check
        or      dl, 4              ; DL = temp flag, bit 2=1 AC ok
        jmp     up486              ; changed, so 486 or later

        ; looks like a 386 - check for NexGen Nx586

upNoAC:
        push    dx                 ; save temp flags (CPUID & AC)
        mov     ax, 5555h          ; init AX with non-zero
        xor     dx, dx             ; set zero flag to 1
        mov     cx, 2
        div     cx                 ; Nx586 processor does not
        pop     dx                 ;   modify zero flag on DIV
        mov     ax, 3              ; assume 386 family
        jnz     upCPUID            ; not Nx586 if zero flag 0
        mov     ax, 5              ; set 586 family
        jmp     upCPUID

up486:
        mov     ax, 4              ; set 486 family
        test    dl, 1
        jnz     upCPUID            ; If CPUID valid, use it

        ; Check for Cyrix, which may look like a 486 so far.
        ; For some dumb reason they provide a option to turn
        ; off the CPUID instruction in many versions, and
        ; the BIOS initializes the CPUID to off!  This
        ; makes the Cyrix 5x86 & 6x86 look like a 486 on
        ; less robust CPU identification programs.

        ; To check for Cyrix, a divide instruction on
        ; non-Cyrix CPUs will change the state of some
        ; flags (undefined).  Cyrix will leave the flags
        ; cleared (except bit 1 is always 1 on all 286+ CPUs).

        xor     ah, ah
        sahf                       ; clear flags
        mov     ax, 10             ; actual values for the
        mov     cl, 4              ;  divide not important
        div     cl                 ; perform a divide
        lahf                       ; get the flags
        and     ah, 0FDh           ; ignore bit 1
        cmp     ah, 0              ; are flags zero?
        je      is_Cyrix           ; if so, it is Cyrix
        mov     ax, 4
        jmp     upInSet            ; must be 486 non-Cyrix

        ; We now know that it is a Cyrix 486 or better part,
        ; without CPUID operating. Now we find out which
        ; type of part by using the Cyrix unique system
        ; registers port 22h and port 23h.

is_Cyrix:
        mov     al, 0FEh
        call    read_cyrix_reg     ; get device ID reg 0 (FEh)
        mov     bl, al             ; save Cryix CPU type value
        mov     ax, 4              ; assume 486 type
        and     bl, 0F0h           ; ignore lower nibble
        cmp     bl, 060h           ; undefined ?
        jae     upInSet            ; must be old Cyrix 486
        cmp     bl, 10h            ; defined as 486 part ?
        jbe     upInSet            ; jump if so
        mov     al, bl             ; convert to 5 or 6
        shr     al, 4
        add     al, 3
        jmp     upInSet            ; AX=5 5x86, AX=6 6x86

; If allowed, use the CPUID instruction to get the CPU class.
;   The CPUID returns a family number 0 or higher for the
;   processor type.  As of 1996, recent Intel 486s, and many
;   later processors (Pentium, Pentium Pro) support the CPUID
;   instruction.  Other vendors may also include support in
;   new CPU releases.

upCPUID:
        test    dl, 1              ; CPUID instruction missing?
        jz      upInSet            ; jump if no CPUID

        push    ecx                ; CPUID changes eax to edx
        push    edx                ;
        mov     eax, 1             ; get family info function
        CPUID                      ; macro for CPUID instruction
        and     eax, 0F00h         ; find family info
        shr     eax, 8             ; move to al
        mov     ah, 1              ; set flag that CPUID ok
        pop     edx
        pop     ecx


; AL has the CPU family (386 or higher) so we now need to test
; for the validity of the instruction set.  We will try a
; 486, Pentium, and Pentium Pro unique instructions, after
; vectoring the bad-opcode interrupt vector (int 6) to
; ourselves.

upInSet:
        mov     ah, dl             ; CPUID & AC flags for exit
        cmp     al, 3              ; if below 386, we are done!
        jb      up_Exit

        push    ax
        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op4  ; where to go if bad
.486
        xadd    al, ah             ; exchange & add (486+)
        bswap   eax                ; byte swap (486+)

        call    restore_int6       ; restore vector
        pop     ax                 ; 486 instruction is ok

        ; now try Pentium instruction

        cmp     al, 4              ; if a 486, we are done!
        jbe     up_Exit

        push    ax
        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op5  ; where to go if bad
.586
        mov     eax, cs:[0]        ; use any address
        not     eax                ; ensure compare fails
                                   ;   to avoid changing cs:[0]
        cmpxchg8b qword ptr cs:[0] ; compare & exchange (Pentium+)

        call    restore_int6       ; restore vector
        pop     ax                 ; Pentium instruction is ok

        ; now try Pentium Pro instruction

        cmp     al, 5              ; if a Pentium, we are done!
        jbe     up_Exit

        push    ax
        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op6  ; where to go if bad

;        cmovne   ax, bx           ; conditional move, not-equal
                                   ;   (Pentium Pro)
        db      0Fh, 45h, 0C3h     ; byte encoding of CMOVNE since
                                   ;  most assembers can't encode it
        call    restore_int6       ; restore vector
        pop     ax                 ; Pentium Pro instruction is ok
        jmp     up_Exit

; Interrupt vector 6 (bad opcode) comes here if CPU does not
;   support 486 instruction set

upbad_op4:
        call    restore_int6
        pop     ax
        mov     bl, 3              ; instruction set 386
        jmp     uP_Exit2

; Interrupt vector 6 (bad opcode) comes here if CPU does not
;   support Pentium instruction set

upbad_op5:
        call    restore_int6
        pop     ax
        mov     bl, 4              ; instruction set 486
        jmp     uP_Exit2

; Interrupt vector 6 (bad opcode) comes here if CPU does not
;   support Pentium Pro instruction set

upbad_op6:
        call    restore_int6
        pop     ax
        mov     bl, 5              ; instruction set Pentium
        jmp     uP_Exit2

up_Exit:
        mov     bl, al             ; set the instruction set
up_Exit2:
        pop     es
        pop     ds
        pop     dx
        pop     cx
        ret
cpuvalue endp
.8086                              ; return to 8086 instructions

;
;    READ CYRIX REGISTER
;       Read the specified Cyrix configuration register
;        (Only call on valid Cyrix part)
;
;       Call with:      ah = register to read
;
;       Returns:        al = register value
;
;       Regs used:      none

read_cyrix_reg proc    near
        out    22h, al            ; set register to read
        IODELAY
        in     al, 23h            ; get register
        ret
read_cyrix_reg endp


;
;    WRITE CYRIX REGISTER
;       Write the specified Cyrix configuration register
;        (Only call on valid Cyrix part)
;
;       Call with:      ah = register to read
;                       al = register value
;
;       Regs used:      none

write_cyrix_reg proc    near
        out     22h, al            ; set register to read
        IODELAY
        out     23h, al            ; set register value
        ret
write_cyrix_reg endp

;
;   HEX2ASCII
;       Convert the hex number in al into two ascii characters
;
;       Called with:    al = input hex number
;
;       Returns         bx = converted digits in ascii
;
;       Regs Used:      al, bx

hex2ascii       proc    near
        mov     bl, al
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bh, al

        mov     al, bl             ; upper nibble
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bl, al             ; bx has two ascii bytes
        ret
hex2ascii       endp



cseg    ends

;================================================== stack ======

stacka  segment para stack

        db      192 dup (0)

stacka  ends

        end     start



