100 '******************************************************************'
110 '*                             D I V B                            *'
120 '*----------------------------------------------------------------*'
130 '*  Task           : Demonstrates direct access to video RAM      *'
150 '*  Author         : MICHAEL TISCHER                              *'
160 '*  Developed on   : 10/01/1988                                   *'
170 '*  Last update    : 06/21/1989                                   *'
180 '******************************************************************'
190 '
200 CLS : KEY OFF
210 GOSUB 50000                  'Determine segment address of video RAM
220 COLUMN%=22 : CLINE%=0 : COL% = 15
230 T$ = "DIVB - (c) 1988 by MICHAEL TISCHER" : GOSUB 51000
240 FCOL% = 0 : T$ = ""            'Define string and starting color
250 A$ = INKEY$ : IF A$<>"" THEN 400    'Repeat until user presses a key
260 FCOL% = FCOL% + 1                          'Increment starting color
270 IF FCOL% > 15 THEN FCOL% = 1             'When FCOL%=16 make FCOL%=1
280 COL% = FCOL%                             'Set color for first square
290 FOR COLUMN%=0 TO 76 STEP 4                  'Execute for each column
300   FOR Z%=1 TO 24 STEP 2                       'Execute for each line
310     CLINE% = Z% : GOSUB 51000          'Display first line of square
320     CLINE% = Z%+1 : GOSUB 51000                 'Display second line
330     COL% = COL% + 1 AND 15                           'Set next color
340   NEXT
350 NEXT
360 GOTO 250
370 '
400 CLS                                                    'Clear screen
410 END
460 '
50000 '****************************************************************'
50010 '* Determine segment address of video RAM                       *'
50020 '*--------------------------------------------------------------*'
50030 '* Input  : none                                                *'
50040 '* Output : VR is the segment address of video RAM              *'
50050 '****************************************************************'
50060 '
50070 DEF SEG = &H40             'Segment address of BIOS variable range
50080 VR = PEEK(&H63) + PEEK(&H64) * 256                  'Get CRTC port
50090 IF VR = &H3B4 THEN VR = &HB000 ELSE VR = &HB800
50100 RETURN                                             'Back to caller
50120 '
51000 '****************************************************************'
51010 '* Write string direct into video RAM                           *'
51020 '*--------------------------------------------------------------*'
51030 '* Input  : - COLUMN% = the output column                       *'
51040 '*          - CLINE%  = the output line                         *'
51050 '*          - COL%    = string color                            *'
51060 '*          - T$      = the string to be displayed              *'
51070 '* Output : none                                                *'
51080 '****************************************************************'
51090 '
51100 DEF SEG = &H40             'Segment address of BIOS variable range
51110 OF% = PEEK(&H4E) + PEEK(&H4F) * 256      'Starting address of page
51120 OF% = OF% + COLUMN% * 2 + CLINE% * 160  'Offset of first character
51130 DEF SEG = VR                     'Set segment address of video RAM
51140 FOR I%=1 TO LEN(T$)                                'Execute string
51150   POKE OF%, ASC(MID$(T$,I%,1))            'ASCII code in video RAM
51160   POKE OF%+1, COL%                             'Color in video RAM
51170   OF% = OF% + 2                      'Set offset to next character
51180 NEXT
51190 RETURN                                             'Back to caller
51200 '
