/********************************************************************/
/*                                D U M P C                         */
/*------------------------------------------------------------------*/
/*    Task           : a Filter which reads in characters from the  */
/*                     Standard input and outputs them as           */
/*                     Hex and ASCII-Dump on                        */
/*                     the Standard output device                   */
/*------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                              */
/*    developed on   : 08/14/87                                     */
/*    last Update    : 04/08/89                                     */
/*------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                 */
/*    Creation       : MSC DUMPC;                                   */
/*                     LINK DUMPC;                                  */
/*    Call           : DUMPC [<Input] [>Output]                     */
/*------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                             */
/*    Creation       : tcc dumpc                                    */
/*    Call           : DUMPC [<Input] [>Output]                     */
/********************************************************************/

#include <stdio.h>                          /* include Header-files */
#include <dos.h>

#define byte unsigned char

#define NUL     0                         /* Code of NUL-character  */
#define BEL     7                         /* Code of Bell           */
#define BS      8                         /* Code of Backspace-key  */
#define TAB     9                         /* Code of Tab-key        */
#define LF      10                        /* Code of Linefeed       */
#define CR      13                        /* Code of Return-key     */
#define ESC     27                        /* Code of Escape-key     */

#define tohex(c) ( ((c)<10) ? ((c) | 48) : ((c) + 'A' - 10) )

/********************************************************************/
/* GETSTDIN: reads a certain number of characters from the Standard */
/*           input device into a Buffer                             */
/* Input   : see below                                              */
/* Output  : Number of characters read                              */
/********************************************************************/

unsigned int GetStdIn(Buffer, MaxChar)
char *Buffer;    /* Pointer in Character-Vector, which accepts data */
unsigned int MaxChar;        /* maximum of characters to be read in */

{
 union REGS Register;       /* Register-Variable for Interrupt-Call */
 struct SREGS Segment;              /* accepts the Segment register */

 segread(&Segment);             /* read content of Segment register */
 Register.h.ah = 0x3F;                       /* Function number for */
 Register.x.bx = 0;        /* the Standard input device is handle 0 */
 Register.x.cx = MaxChar;             /* Number of Bytes to be read */
 Register.x.dx = (unsigned int) Buffer; /* Offset address of Buffer */
 intdosx(&Register, &Register, &Segment);  /* Call Interrupt 21(h) */
 return(Register.x.ax);          /* Number of Bytes read to caller  */
}

/********************************************************************/
/* STRAP  : Attach character to string                              */
/* Input  : see below                                               */
/* Output : Pointer behind the last added character                 */
/********************************************************************/

char *Strap(String, Textpointer)
char *String,                                  /* the source string */
     *Textpointer;            /* Pointer to the text to be attached */

{
 while (*Textpointer)                 /* repeat until '\0' detected */
  *String++ = *Textpointer++;                 /* transmit character */
 return(String);               /* Pass Pointer to calling function  */
}

/********************************************************************/
/* DODUMP : reads the characters in and outputs them as Dump        */
/* Input  : none                                                    */
/* Output : none                                                    */
/********************************************************************/

void DoDump()

{
 char NewByte[9],                    /*Accepts the characters read  */
      DumpBuf[80],                        /* accepts a line of DUMP */
      *NextAscii;   /* points to next ASCII-character in the buffer */
 byte i,                                            /* Loop counter */
      Readbytes;                         /* Number of bytes read in */

 DumpBuf[30] = 219;          /* Set separator between Hex and ASCII */
 while((Readbytes = GetStdIn(NewByte, 9)) != 0)
                             /* as long as characters are available */
  {
   for (i = 0; i < 30; DumpBuf[i++] = ' ');
                                         /* Fill buffer with spaces */
   NextAscii = &DumpBuf[31];         /* ASCII-characters start here */
   for (i = 0; i < Readbytes; i++)
                                  /* process all characters read in */
    {
     DumpBuf[i*3] = tohex((byte) NewByte[i] >> 4);
                                             /* convert Code in Hex */
     DumpBuf[i*3+1] = tohex((byte) NewByte[i] & 15);
     switch (NewByte[i])                     /* evaluate ASCII-Code */
      {
       case NUL : NextAscii = Strap(NextAscii, "<NUL>");
                  break;
       case BEL : NextAscii = Strap(NextAscii, "<BEL>");
                  break;
       case BS  : NextAscii = Strap(NextAscii, "<BS>");
                  break;
       case TAB : NextAscii = Strap(NextAscii, "<TAB>");
                  break;
       case LF  : NextAscii = Strap(NextAscii, "<LF>");
                  break;
       case CR  : NextAscii = Strap(NextAscii, "<CR>");
                  break;
       case ESC : NextAscii = Strap(NextAscii, "<ESC>");
                  break;
       case EOF : NextAscii = Strap(NextAscii, "<EOF>");
                  break;
       default  : *NextAscii++ = NewByte[i];
      }
    }
   *NextAscii = 219;      /* End character for ASCII representation */
   *(NextAscii+1) = '\r';       /* Carriage-Return to End of buffer */
   *(NextAscii+2) = '\0';          /* NUL converted to LF on output */
   puts(DumpBuf);         /* Write String on Standard output device */
  }
}

/********************************************************************/
/**                         MAIN PROGRAM                           **/
/********************************************************************/

void main()

{
 DoDump();                                /* Character input/output */
}
