;**********************************************************************;
;*                           P R O C C A                              *;
;*--------------------------------------------------------------------*;
;*    Task           : Make a function available to a C program which *;
;*                     examines the type of processor installed in a  *;
;*                     PC and informs the calling program of this     *;
;*                     information.                                   *;
;*--------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                                *;
;*    Developed on   : 08/15/1988                                     *;
;*    Last update    : 05/24/1989                                     *;
;*--------------------------------------------------------------------*;
;*    assembly       : MASM PROCCA;                                   *;
;*                     ... link to a C program                        *;
;**********************************************************************;
                                                                        
IGROUP group _text                ;Include program segment
DGROUP group const,_bss,  _data   ;Include data segment
       assume CS:IGROUP, DS:DGROUP, ES:DGROUP, SS:DGROUP
                                                                        
CONST  segment word public 'CONST';This segment includes all read-only
CONST  ends                       ;constants 
                                                                        
_BSS   segment word public 'BSS'  ;This segment includes al un-initial-
_BSS   ends                       ;ized static variables 
                                                                        
_DATA  segment word public 'DATA' ;This segment includes all initialized
                                  ;gobal and static variables
                                                                        
_DATA  ends
                                                                        
;== Constants ==========================================================
                                                                        
p_80386   equ   7                 ;Codes for different processor tpyes
p_80286   equ   6
p_80186   equ   5
p_80188   equ   4
p_v30     equ   3
p_v20     equ   2
p_8086    equ   1
p_8088    equ   0
                                                                        
;== Program ============================================================
                                                                        
_TEXT  segment byte public 'CODE' ;Program segment
                                                                        
public   _getproc                 ;Function made available for other
                                  ;programs
                                                                        
;-- GETPROC: Determines the type of processor in the current PC --------
;-- Call from C : int getproc( void );
;-- Output      : The processor type's number (see constants above)
                                                                        
_getproc  proc near
                                                                        
          pushf                   ;Secure flag register contents
                                                                        
          ;-- Test for 80386/80286 -------------------------------------
                                                                        
          xor  ax,ax              ;Set AX to 0
          push ax                 ;and push onto stack
          popf                    ;Pop flag register off of stack
          pushf                   ;Push back onto stack
          pop  ax                 ;and pop off of AX
          and  ax,0f000h          ;Do not clear the upper 4 bits
          cmp  ax,0f000h          ;Are bits 12-15 al equal to 1?
          je   not_a_386          ;YES --> Not an 80386 or 80286
                                                                        
          ;-- Test for handling as an 80386 or 80286 -------------------
                                                                        
          mov  dl,p_80286         ;In any case, this routine checks for
          mov  ax,07000h          ;one of the two processors
          push ax                 ;Push 07000h onto stack 
          popf                    ;Pop flag register off
          pushf                   ;and push back onto the stack
          pop  ax                 ;Pop into AX register
          and  ax,07000h          ;Bits 12-14 not included
          je   pende              ;Are bits 12-14 all equal to 0?
                                  ;YES--> Handle it as an 80286
                                                                        
          inc  dl                 ;NO --> Handle it as an 80386
          jmp  pende              ;End test
                                                                        
          ;-- Test for 80186 or 80188 ----------------------------------
                                                                        
not_a_386 label near
                                                                        
          mov  dl,p_80188         ;Load code for 80188
          mov  al,0ffh            ;Set all bits in AL register to 1
          mov  cl,021h            ;Move number of shift operations to CL
          shr  al,cl              ;AL CL shift to the right
          jne  t88_86             ;If AL <> 0, handle is as an
                                  ;80188 or 80186
                                                                        
          ;-- Test for NEC V20 or V30 ----------------------------------
                                                                        
          mov  dl,p_v20           ;Load code for NEC V20
          sti                     ;Enable interrupts
          push si                 ;Mark contents of SI register
          mov  si,0               ;Starting with first byte in ES, read 
          mov  cx,0ffffh          ;a complete segment
          rep  lods byte ptr es:[si]  ;REP with a segment override
                                      ;(works ony with NEC V20, V30)
          pop  si                 ;Pop SI off of stack
          or   cx,cx              ;Has entire segment been read?
          je   t88_86             ;YES--> V20 or V30
                                                                        
          mov  dl,p_8088          ;NO --> Must be 8088 or 8086
                                                                        
          ;-- Test for 88/86 or V20/V30 --------------------------------
                                                                        
t88_86    label near
                                                                        
          push cs                 ;Push CS onto stack
          pop  es                 ;and pop ES off 
          std                     ;Increment on string instructions 
          mov  di,offset q_end    ;
          mov  al,0fbh            ;Instruction code for "STI"
          mov  cx,3               ;Execute string instruction 3 times 
          cli                     ;Suppress interrupts
          rep  stosb
          cld                     ;Increment on string instructions
          nop                     ;Fill queue with dummy instructions
          nop
          nop
                                                                        
          inc  dx                 ;Increment processor code
          nop
q_end:    sti                     ;Re-enable interrupts
                                                                        
          ;-------------------------------------------------------------
                                                                        
pende     label near              ;End testing
                                                                        
          popf                    ;Pop flag register off of stack
          xor  dh,dh              ;Set high byte of proc. code to 0
          mov  ax,dx              ;Processor code=return value of funct.
          ret                     ;Back to caller
                                                                        
_getproc  endp                    ;End of procedure
                                                                        
;== End ================================================================
                                                                        
_text    ends                     ;End of program segment
         end                      ;End of assembler source
