;***********************************************************************
;*  This routine offers the capability of                              *
;*  calling any interrupt from BASICA or                               *
;*  GWBASIC                                                            *
;*                                                                     *
;**-------------------------------------------------------------------**
;*  Call:                                                              *
;* CALL ADR(INTNR%,AH%,AL%,BH%,BL%,CH%,CL%,DH%,DL%,DI%,SI%,ES%,FLAGS%) *
;**-------------------------------------------------------------------**
;*  On passing control to the machine language program BASIC           *
;*  deposits the variables on the following positions of the stack     *
;*  INTNR% = SP+30  AH%    = SP+28   AL%    = SP+26   BH%    = SP+24   *
;*  BL%    = SP+22  CH%    = SP+20   CL%    = SP+18   DH%    = SP+16   *
;*  DL%    = SP+14  DI%    = SP+12   SI%    = SP+10   ES%    = SP+8    *
;*  FLAGS% = SP+6                                                      *
;**-------------------------------------------------------------------**
;*  for ES the value -1 is passed, then ES is set to DS                *
;***********************************************************************

code      segment

          assume cs:code,ds:code,es:code,ss:code

;-- the Routine for Interrupt call -----------------------------------

basint    proc far                ;GW expected during CALL far procedure

          push bp                 ;GW base pointer saved 
          mov  bp,sp              ;Send SP to BP
          push ds                 ;GW dta segment stored 
          push es                 ;GW extra segment saved 

          mov  si,[bp+30]         ;Get address of variable INTNR
          mov  ax,[si]            ;Move content of this variable to AX
          call set_intnr          ;Store interrupt number 

ad_1      label near              ;Address for SET_INTNR

          mov  si,[bp+12]         ;Get address of DI% variable
          mov  di,[si]            ;Move contents of variable to DI
          mov  si,[bp+8]          ;Get address of variable ES%
          mov  ax,[si]            ;Move content of variable to AX
          cmp  ax,-1              ;was -1 passed?
          jne  setes              ;No --> set ES 

          mov  ax,ds              ;Set AX to DS and thereby ES = DS

setes:    mov  es,ax              ;transfer AX to ES
          mov  si,[bp+28]         ;Get address of variable AH%
          mov  ah,[si]            ;Move content of variable to AH
          mov  si,[bp+26]         ;Get address of variable AL%
          mov  al,[si]            ;Move content of variable to AL
          mov  si,[bp+24]         ;Get address of variable BH%
          mov  bh,[si]            ;Move content of variable to BH
          mov  si,[bp+22]         ;Get address of variable BL%
          mov  bl,[si]            ;Move content of variable to BL
          mov  si,[bp+20]         ;Get address of variable CH%
          mov  ch,[si]            ;Move content of variable to CH
          mov  si,[bp+18]         ;Get address of variable CL%
          mov  cl,[si]            ;Move content of variable to CL
          mov  si,[bp+16]         ;Get address of variable DH%
          mov  dh,[si]            ;Move content of variable to DH
          mov  si,[bp+14]         ;Get address of variable DL%
          mov  dl,[si]            ;Move content of variable to DL

          mov  si,[bp+10]         ;Get address of variable SI%
          mov  si,[si]            ;Move content of variable to SI
          push bp                 ;Store base pointer

ad_2      label near              ;Address for SET_INTNR

          int  21h                ;Call interrupt

          pop  bp                 ;Replace base pointer
          push si                 ;Store SI 
          pushf                   ;Store flag register

          mov  si,[bp+12]         ;Get address of variable DI%
          mov  [si],di            ;Move content of variable to DI
          mov  si,[bp+28]         ;Get address of variable AH%
          mov  [si],ah            ;Store AH in this variable 
          mov  si,[bp+26]         ;Get address of variable AL%
          mov  [si],al            ;Store AL in this variable 
          mov  si,[bp+24]         ;Get address of variable BH%
          mov  [si],bh            ;Store BH in this variable 
          mov  si,[bp+22]         ;Get address of variable BL%
          mov  [si],bl            ;Store BL in this variable 
          mov  si,[bp+20]         ;Get address of variable CH%
          mov  [si],ch            ;Store CH in this variable 
          mov  si,[bp+18]         ;Get address of variable CL%
          mov  [si],cl            ;Store CL in this variable 
          mov  si,[bp+16]         ;Get address of variable DH%
          mov  [si],dh            ;Store DH in this variable
          mov  si,[bp+14]         ;Get address of variable DL%
          mov  [si],dl            ;Store DL in this variable
          mov  si,[bp+8]          ;Get address of variable ES%
          mov  ax,es              ;transfer ES to AX
          mov  [si],ax            ;Store ES (AX) in this variable 
          pop  ax                 ;Move flag register from stack to AX 
          mov  si,[bp+6]          ;Get address of variable FLAGS%
          mov  [si],ax            ;Store FLAGs in this variable 
          pop  ax                 ;Move DI register from stack to AX 
          mov  si,[bp+10]         ;Get address of variable SI% 
          mov  [si],ax            ;Store SI (AX) in this variable

          pop  es                 ;Get GW extra segment back 
          pop  ds                 ;Get GW data segment back 
          pop  bp                 ;Return GW base pointer 

          ret  26                 ;Addresses of variables on the stack
                                  ;are no longer needed 

basint    endp

;----------------------------------------------------------------------

set_intnr proc near               ;stores the interrupt number

          pop  bx
          mov  cs:[bx+ad_2-ad_1+1],al
          jmp  ad_1

set_intnr endp

;----------------------------------------------------------------------

code      ends
          end

