
PROGRAM PWM_8253;
{ Generate Pulse Width Modulation signals from Intel's 8253 Interval Timer IC }
USES CRT, PRINTER, My_Tpu;
TYPE  Ctrl_Wd_Type = ARRAY[0..2] OF BYTE;

CONST    A0 = 1; { D0, Bit 1, = Strbe at Base-Address + 2        }
         A1 = 2; { D1, Bit 2, = Auto-Feed at Base-Address + 2    }
         WR = 4; { D2, Bit 3, = Initialize at Base-Address + 2   }
         CS = 8; { D3, Bit 4, = Select-Input at Base-Address + 2 }

VAR Data, Counter_Number, Control_Lines : BYTE;
                        Lptx, Data_Word : WORD;
                   Initial_Word, Num, E : INTEGER;
                                               Ch : CHAR;
                                     Control_Word : Ctrl_Wd_Type;

PROCEDURE Set_Control_Words( VAR Control_Word : Ctrl_Wd_Type );
{ computer Control Word Values to set Counter 0  for square wave output,
  Counter 1 for pulse generator, and Counter 2 as a software triggered
  one-shot pulse generator.
}
BEGIN
{ -=[ COUNTER 0 Control Word  ]=- }
      { Set Control-Word for Counter 0 to Mode 3, "Square Wave Rate Gen."
           Mode 3 allows the counter to output a continuous square wave.
        For example if the counter is programmed with a 10, the
        output will be low for five clock counts, and high for five clock
        counts.  The gate is used to start ( logic 1 ) and stop ( logic 0 )
        the count.                                                          }
      {                                                                     }
      { Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0       }
      { 8253's pin labels   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD       }
      {          select counter       0   0                                 }
      {       Load LSB then MSB               1   1                         }
      {           Select Mode 3                         0   1   1           }
      { No Binary Coded Decimal                                     0       }
      {                           -----------------------------------       }
Control_Word[0] := $36;         {     0   0   1   1     0   1   1   0       }

{ -=[ COUNTER 1 Control Word ]=- }
    { Set Control Word for counter 1, to Mode 2, "Rate Generator"
        Mode 2 allows the counter to generate a series of continuous
      pulses that are one clock pulse in width.  The separation between
      pulses is determined by the count.  For example,  if the count is a
      10, the output will be a logic 1 for nine clock pulses and low
      ( logic 0 ) for one.  This cycle is repeated until the counter is
      reprogrammed with a new count.  The gate input is used to start
      ( logic 1 ) and stop ( Logic 0 ) the count.                         }
    {                                                                     }
    { Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0       }
    {                                                                     }
    { 8253's pin lables   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD       }
    {          select counter       0   1                                 }
    {       Load LSB then MSB               1   1                         }
    {           Select Mode 2                         0   1   0           }
    { No Binary Coded Decimal                                     0       }
    {                           -----------------------------------       }
Control_Word[1] := $74;     {       0   1   1   1     0   1   0   0       }

{ -=[ COUNTER 2 Control Word ]=- }
    { Set Counter 2 to Mode 5, "Hardware Triggered Strobe"
        Mode 5 allows the counter to generate a single pulse after it is
      triggered by a gate input.   For example, if a count of 5 is
      programmed, the output will remain high until five clock  counts
      after the gate trigger pulse ( logic 1 ) and then go low for an
      additional clock count.  The output is a, one shot, pulse.                           }
    {                                                                     }
    { Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0       }
    { 8253's pin labels   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD       }
    {          select counter       1   0                                 }
    {       Load LSB then MSB               1   1                         }
    {           Select Mode 5                         1   0   1           }
    { No Binary Coded Decimal                                     0       }
    {                           -----------------------------------       }
Control_Word[2] := $BA; {           1   0   1   1     1   0   1   0       }
END; { set control words }


PROCEDURE Send_Control(Counter_Num : BYTE);
  BEGIN
  PORT[Lptx] := Control_Word[Counter_Num];
                                    {   INTEL 8253 PINS:  CS   WR   A1   A0  }
                                    {                     __        __   __  }
                                    { PRINTER PORT PINS:  D3   D2   D1   D0  }
  PORT[Lptx + 2] := $4; { Set ALL  control lines HIGH;     0    1    0    0  }
  PORT[Lptx + 2] := $C; { set CS line to active LOW        1    1    0    0  }
  PORT[Lptx + 2] := $8; { set WR line to active LOW        1    0    0    0  }
  PORT[Lptx + 2] := $C; { set WR line to inactive HIGH     1    1    0    0  }
  PORT[Lptx + 2] := $4; { set CS line to inactive HIGH     0    1    0    0  }
  END; { send control word }

PROCEDURE Send_Data(Counter_Num, Data : BYTE);
  { The procedure demonstrates how to send data to an 8253 counter.           }
  { YES, I know this code can be compressed, BUT then it would loose          }
  { it's clarity.                                                             }
BEGIN  { send data }
PORT[Lptx] := Data;     { load the data onto the data lines                   }
CASE Counter_Num OF
  0 :
  BEGIN                 {                INTEL 8253 PINS:  CS   WR   A1   A0  }
                        {                                  __        __   __  }
                        {              PRINTER PORT PINS:  D3   D2   D1   D0  }
  PORT[Lptx + 2] := $4; { turn ALL lines to inactive HIGHs  0    1    0    0  }
  PORT[Lptx + 2] := $7; { Set A0 and A1 to binary zero      0    1    1    1  }
  PORT[Lptx + 2] := $F; { set CS line to active LOW         1    1    1    1  }
  PORT[Lptx + 2] := $B; { set WR line to active LOW         1    0    1    1  }
  PORT[Lptx + 2] := $F; { set WR line to inactive HIGH      1    1    1    1  }
  PORT[Lptx + 2] := $7; { set CS line to inactive HIGH      0    1    1    1  }
  writeln('case = ', Counter_num);
  END; { counter # 0 }

   1 :
  BEGIN                 {                INTEL 8253 PINS:  CS   WR   A1   A0  }
                        {                                  __        __   __  }
                        {              PRINTER PORT PINS:  D3   D2   D1   D0  }
  PORT[Lptx + 2] := $4; { turn ALL lines to inactive HIGHs  0    1    0    0  }
  PORT[Lptx + 2] := $7; { Set A0 and A1 to binary one       0    1    1    0  }
  PORT[Lptx + 2] := $F; { set CS line to active LOW         1    1    1    0  }
  PORT[Lptx + 2] := $B; { set WR line to active LOW         1    0    1    0  }
  PORT[Lptx + 2] := $F; { set WR line to inactive HIGH      1    1    1    0  }
  PORT[Lptx + 2] := $7; { set CS line to inactive HIGH      0    1    1    0  }
  writeln('case = ', Counter_num);
  END; { counter # 1 }

2 :
  BEGIN                 {                INTEL 8253 PINS:  CS   WR   A1   A0  }
                        {                                  __        __   __  }
                        {              PRINTER PORT PINS:  D3   D2   D1   D0  }
  PORT[Lptx + 2] := $4; { turn ALL lines to inactive HIGHs  0    1    0    0  }
  PORT[Lptx + 2] := $7; { Set A0 and A1 to binary two       0    1    0    1  }
  PORT[Lptx + 2] := $F; { set CS line to active LOW         1    1    0    1  }
  PORT[Lptx + 2] := $B; { set WR line to active LOW         1    0    0    1  }
  PORT[Lptx + 2] := $F; { set WR line to inactive HIGH      1    1    0    1  }
  PORT[Lptx + 2] := $7; { set CS line to inactive HIGH      0    1    0    1  }
  writeln('case = ', Counter_num);
  END; { counter # 2}
 END { case }
END; { send data }



PROCEDURE Adjust_Frequency(Counter_Number : BYTE; Initial_Word : WORD);
BEGIN { adj freq }
IF Counter_Number IN [0,1] THEN CASE Counter_Number OF
0 : BEGIN { case # 1 }  { set up counter 1 as a square wave generator }
    WRITELN('Setting up COUNTER 1 as a square wave generator ');
    REPEAT
      REPEAT
        REPEAT UNTIL KEYPRESSED;
      Ch := ReadKey;
      UNTIL ORD(CH) IN [ 73, 81, 27 ];
    CASE ORD(CH) OF
      73 : IF Data_Word < $E000 THEN Data_Word := Data_Word + $0FFF;
      81 : IF Data_Word > $100F THEN Data_Word := Data_Word - $0FFF;
      27 : EXIT;      { pressing ESC key exits program }
      END;  { case, ord(ch) }
     WRITELN(' DATA WORD = ',Data_Word);
     Counter_Number := 0;
     Send_Control(Counter_Number);
     Send_Data(Counter_Number, Lo(Data_Word));
     Send_Data(Counter_Number, Hi(Data_Word));
     UNTIL ORD(Ch) = 27; { pressing ESC key exits program }
    END; { case # 0}

1 : BEGIN { case # 1 }
    WRITELN('Set up counters 1 and 2 for Pulse Width Modulation ');
{ set Counter 1 as a software triggered, pulse generator                     }
    Counter_Number := 1;
    Send_Control(Counter_Number);
    Data_Word := $FFFF;            { set to longest time period possible     }
    Send_Data(Counter_Number, Lo(Data_Word));
    Send_Data(Counter_Number, Hi(Data_Word));
    REPEAT
      REPEAT
        REPEAT UNTIL KEYPRESSED;
      Ch := ReadKey;
      UNTIL ORD(CH) IN [ 73, 81, 27 ];
      IF ORD(CH) IN [ 73, 81, 27 ] THEN CASE ORD(CH) OF
        73 : IF Data_Word < $E000 THEN Data_Word := Data_Word + $0FFF;
        81 : IF Data_Word > $100F THEN Data_Word := Data_Word - $0FFF;
        27 : EXIT;      { pressing ESC key exits program }
        END;  { case, ord(ch) }
{ set counter 2 as a hardware triggered, one shot, pulse generator           }
     Counter_Number := 2;
     Send_Control(Counter_Number);
     Send_Data(Counter_Number, Lo(Data_Word));
     Send_Data(Counter_Number, Hi(Data_Word));
     UNTIL ORD(Ch) = 27; { pressing ESC key exits program }
    END; { case # 1}
 END; { case }
END;  { adjust frequency }

BEGIN { main }
ClrScr; Num := 2;       { use 1 to find LPT1, and 3 to find LPT3             }
Lptx := Find_LPTx(Num);
Set_Control_Words(Control_Word);
Port[Lptx + 2] := $04;  { = 0000 0100 Binary,   Initialize the control lines  }
 { start counter 0, as a square wave generator }
Initial_Word := $7FFF; { set initial frequency a about the middle of range   }
{         -=[ SET UP COUNTER 0 AS A SQUARE WAVE GENERATOR ]=-                }
Counter_Number := 0;
Send_Control(Counter_Number);
Send_Data(Counter_Number, Lo(Initial_Word));
Send_Data(Counter_Number, Hi(Initial_Word));
Adjust_Frequency(Counter_Number, Initial_Word);
{         -=[ SET UP COUNTERS 1 and 2 AS A PULSE WIDTH GENERATOR             }
Counter_Number := 1;
Send_Control(Counter_Number);
Send_Data(Counter_Number, Lo(Initial_Word));
Send_Data(Counter_Number, Hi(Initial_Word));
Adjust_Frequency(Counter_Number, Initial_Word);

END. { main }
