PROGRAM OPTO_OUT;
{
 output 8-bit data and four control bits via the parallel printer port

 written in Turbo Pascal 6.0
}
USES CRT;
CONST                     t = 20;
               Base_Address = 888; { CGA card's printer port base address  }
                                   { 956 = MGA card's printer port address }
                                   { 3rd printer port base address         }
VAR         e, Power_Of_Two : BYTE;
                         Ch : CHAR;
                  CTRL_Bits : BYTE;
    Low_Nibble, High_Nibble : BYTE;
BEGIN
 { send contorl bits }
  REPEAT
  CTRL_Bits := 1;
    { send data bits }
    REPEAT
    FOR e := 0 TO 255 DO
      BEGIN
      Low_Nibble := e AND  $0F;        { 00001111 }
      Low_Nibble := Low_Nibble XOR 11; { reinvert inverted (base + 1) bits }
      High_Nibble := e AND $F0;        { 11110000 }
      PORT[Base_Address +2] := Low_Nibble;
      PORT[Base_Address] := High_Nibble OR CTRL_Bits;
      IF KEYPRESSED THEN EXIT;
      DELAY(t);
      END; { for e }
    CTRL_Bits := CTRL_Bits * 2;
    UNTIL  CTRL_Bits > 8;
  UNTIL KEYPRESSED;
END.
