{ FILE:  LOGICAL.PAS }

PROGRAM Logical; { demonstrates logical operators AND, OR, and XOR           }

PROCEDURE AND_Operator;  { demonstrate logical AND operation                 }

{ Logically "compares" the outcome of "ANDing" bits.  The AND operator       }
{ reports the "truth" of bitwise comparing two, byte long variables. IF      }
{ both bits are high, then the resultant outcome bit's value high            }

{    Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
                      Ŀ
    Byte_1 =  77  =    0  1  0  0  1  1  0  1 
                      
    AND                AND AND AND AND AND AND AND AND
                      Ŀ
    Byte_2  = 62  =    0  0  1  1  1  1  1  0 
                      
    YIELDS                                   
                      Ŀ
    Byte_3  = 12  =    0  0  0  0  1  1  0  0 
                      

        IN DECIMAL;  77 AND 62 = 12
}
VAR Byte_1, Byte_2, Byte_3 : BYTE;
BEGIN { and }
Byte_1 := 77;
Byte_2 := 62;
Byte_3 := Byte_1 AND Byte_2;
WRITELN ('Byte_1 AND Byte_2 = ',Byte_3);
END; { and }

PROCEDURE OR_Operator; {    demonstrate logical OR operation                 }

{ Logically "compares" the outcome of "ORing" bits.  The OR operator reports }
{ the "truth" of bitwise comparing two, byte long variables. IF either bit   }
{ is high, then the resultant outcome bit's value high.                      }

{    Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
                      Ŀ
     Byte_1  = 77  =   0  1  0  0  1  1  0  1 
                      
     OR                OR  OR  OR  OR  OR  OR  OR  OR
                      Ŀ
     Byte_2  = 62  =   0  0  1  1  1  1  1  0 
                      
     YIELDS                                  
                      Ŀ
     Byte_3  = 127 =   0  1  1  1  1  1  1  1 
                      
}
VAR Byte_1, Byte_2, Byte_3 : BYTE;
BEGIN { OR }
Byte_1 := 77;
Byte_2 := 62;
Byte_3 := Byte_1 OR Byte_2;
WRITELN ('Byte_1 OR Byte_2 = ',Byte_3);
END; { OR }

PROCEDURE XOR_Operator; {  demonstrate logical XOR operation                 }

{ Logically "compares" the outcome of "XORing" bits.  The XOR operator       }
{ reports the "truth" of bitwise comparing two, byte long variables. IF      }
{ either bit, but not both bits, is high, then the resultant outcome bit's   }
{ value high                                                                 }

{    Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
                      Ŀ
     Byte_1 = 77 =     0  1  0  0  1  1  0  1 
                      
     XOR               XOR XOR XOR XOR XOR XOR XOR XOR
                      Ŀ
     Byte_2 = 62 =     0  0  1  1  1  1  1  0 
                      
     YIELDS                                  
                      Ŀ
     Byte_3 = 115 =    0  1  1  1  0  0  1  1 
                      
}
VAR Byte_1, Byte_2, Byte_3 : BYTE;
BEGIN { XOR }
Byte_1 := 77;
Byte_2 := 62;
Byte_3 := Byte_1 XOR Byte_2;
WRITELN ('Byte_1 XOR Byte_2 = ',Byte_3);
END; { XOR }

BEGIN
AND_Operator; WRITELN;
OR_Operator; WRITELN;
XOR_Operator; WRITELN;
READLN;
END.

FILE: Logical.PAS
















