  /*                  PROGRAM Sw_Input
	       Code conversion by Eugene Klein
  Input BUSY, ACK, PAPER END, INPUT, STROBE, AUTO FEED, ERROR,
  and SELECT INPUT signals, by Paul Bergsman, 4/14/1992
  Display each bit of the data byte.
  Written in Turbo Pascal for an IBM type machine. A similar program could
  be written for any computer which supports Centronics Parallel Printer Port.
  */


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"


const int      Busy = 128;
const int      Ack = 64;
const int      Paper_End = 32;
const int      Select = 16;
const int      Select_Input = 8;
const int      Initialize = 4;
const int      Auto_Feed = 2;
const int      Strobe = 1;
const int      D0=1,D1=2,D2=4,D3=8,D4=16,D5=32,D6=64,D7=128;

int LPT1, Base_Address;
unsigned char Data_Byte, High_Nibble, Low_Nibble;

unsigned char Read_ADC0804(void)
{
 unsigned char High_Nibble, Low_Nibble;
// set all open collector output pins HIGH so you can read from base + 2
 outport(Base_Address + 2,inport(Base_Address + 2) || 15);
 delay(50);
 Low_Nibble =  inport(Base_Address + 2);
 High_Nibble = inport(Base_Address + 1);
 Low_Nibble = Low_Nibble & 0x0F;       //0x0F = 00001111
 High_Nibble = High_Nibble & 0xF0;     //0xF0 = 11110000
 Data_Byte = High_Nibble | Low_Nibble;
 return(Data_Byte);
}

void Display_Data(unsigned char Data_Byte)
{
 gotoxy(1,3); printf("LPT1 = %i   Data Byte = %i\n",LPT1,Data_Byte);
 if((Data_Byte & Busy)== D7)
  printf("BUSY HIGH" );
 else
  printf("BUSY LOW \n");
 if((Data_Byte & Ack)== D6)
  printf("ACK  HIGH\n");
 else
  printf("ACK LOW \n");
 if((Data_Byte & Paper_End) == D5)
  printf("PAPER HIGH\n");
 else
  printf("PAPER LOW\n");
 if((Data_Byte & Select)== D4)
  printf("SELECT HIGH\n");
 else
  printf("SELECT LOW \n");
 if((Data_Byte & Select_Input) == D3)
  printf("SELECT_INPUT HIGH\n");
 else
  printf("SELECT_INPUT LOW \n");
 if((Data_Byte & Initialize) == D2)
  printf("Initialize HIGH\n");
 else
  printf("Initialize LOW \n");
 if((Data_Byte & Auto_Feed) == D1)
  printf("Auto_Feed HIGH\n");
 else
  printf("AUTO_FEED LOW \n");
 if((Data_Byte & Strobe) == D0)
  printf("STROBE HIGH\n");
 else
  printf("STROBE LOW \n");
}

void main()
{
 clrscr();
 Base_Address = 1024; LPT1 = peek(0, Base_Address + 8); // find base address
 do
 {
  Data_Byte=Read_ADC0804();
  Display_Data(Data_Byte);
 }while(!kbhit());
}