 /*           PROGRAM PIA_8255; { Intel 8255 Parallel Interface Adaptor }
		      Code conversion by Eugene Klein

  Demonstrate 8255's operation form a parallel printer port.  Program outputs
  data to 8255 Ports 1 and  2, while reading data form Port 3.  This IC
  expands a parallel printer port into a three byte I/O port.
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const unsigned char ESC = 0x1B;

const unsigned char    A0 = 1; // Bit 1 = D0, STROBE at Base-Address + 2
const unsigned char    A1 = 2; // Bit 2 = D1, AUTO-FEED at Base-Address + 2
const unsigned char    RD = 4; // Bit 3 = D2, *INITIALIZE at Base-Address + 2
const unsigned char    WR = 8; // Bit 4 = D3, *SELECT-INPUT at Base-Address + 2
		 // NOTE: an asterisk, (*),  denotes inactive high logic
unsigned char    T = 5, Port_Number;

unsigned char A, E, x, Control_Byte, Data_Byte, Control_Lines;
unsigned char Base_Addr_LO_Nibble, Base_Addr_HI_Nibble, Lpt_Num;
unsigned int LPTx, Data_Word;
int Num;
unsigned char Inverted_Logic[16];
char Ch;

void Generate_Data(void)
{
 // makes "look-up" table for Base + 2's inverted signals on D0, D1, and D3
 // faster than doing repetitive logic conversions for all new data
 int Count, Temp, D0, D1, D2, D3;
 Count = 0;
 for(D3=1;D3>=0;D3--)            // D3 of Base + 2 is inverted
 {
  for(D2=0;D2<=1;D2++)           // D2 of Base + 2 is NOT inverted
  {
   for(D1=1;D1>=0;D1--)          // D1 of Base + 2 is inverted
   {
    for(D0=1;D0>=0;D0--)         // D0 of Base + 2 is inverted
    {
     Temp = (8 * D3) + ( 4 * D2) + ( 2 * D1 ) + D0;
     Inverted_Logic[Count] = Temp;
     Count = Count + 1;
    }
   }
  }
 }
}

void Send_Control_Word(unsigned char Control_Byte)
{
 // issues control byte to the 8255.  Tells the 8255 the Mode, which ports
 // are inputs, and which parts are outputs.
 unsigned char Temp;

 Base_Addr_LO_Nibble = 0x0F;               // Initialize Control Lines, 0000 1111
 outport(LPTx, Base_Addr_LO_Nibble);
 Base_Addr_HI_Nibble = Control_Byte & 0xF0;       // HI nibble of control byte
 outport(LPTx,Base_Addr_HI_Nibble | Base_Addr_LO_Nibble);
 Temp = Control_Byte & 0x0F;                      // LO nibble of control byte
 Temp = Inverted_Logic[Temp];
 outport(LPTx + 2,Temp);
 outport(LPTx,inport(LPTx) & 0xF7);
 // 1111 0111 set Write Line to active LOW
 delay(T);
 // the LM311 RC network forces the use of a prolonged WR signal
 outport(LPTx,inport(LPTx) | 0x08);
 //  0000 1000 set Write Line to inactive HIGH
}


void Send_Data(unsigned char Data_Byte, unsigned char Port_Number)
{
 // Send Data_Byte to Port [ LPTx ]
 unsigned char Temp;

 Base_Addr_LO_Nibble = 0x0C | Port_Number; // Initialize Control Lines, 00001100
 outport(LPTx,Base_Addr_LO_Nibble);
 outport(LPTx,( Data_Byte & 0xF0 ) | Base_Addr_LO_Nibble);
 Temp = Data_Byte & 0x0F;
 Temp = Inverted_Logic[Temp];
 outport(LPTx + 2,Temp);
 outport(LPTx,inport(LPTx & 0xF7)); // 1111 0111, set Write Line to active LOW
 delay(T);     // the LM311 RC network forces the use of a prolonged WR signal
 outport(LPTx,inport(LPTx | 0x08));  // 0000 1000, set Write Line to inactive HIGH
}

void Output_Data(void)
{
 // Generate data to set each pin of Port 1, and Port 2, HIGH in sequence
 unsigned char Ct;

 for(A=0;A<=1;A++)
 {
  Ct = 1;
  for(E=1;E<=8;E++)
  {
   Send_Data(Ct, A); Ct = Ct + Ct;
   if(kbhit())
    exit(0);
  }
  Ct = 0; Send_Data(Ct, A);
 }
 for(A=1;A>0;A--)
 {
  Ct = 128;
  for(E=1;E<=8;E++)
  {
   Send_Data(Ct, A); Ct = Ct / 2;
   if(kbhit())
    exit(0);
  }
  Ct = 0; Send_Data(Ct, A);
 }
}

unsigned char Input_Data( unsigned char Port_Number)
{
 // Read data from selected port invert inverted data on lines D0 and D1 and D3
 // Return via Data_Byte a correct reading byte of data

 unsigned char Temp, TempB;

 Base_Addr_LO_Nibble = 0x0C; // Initialize Control Lines,             0000 1100
 Base_Addr_LO_Nibble = 0x0C | Port_Number; // select port for input
 outport(LPTx,Base_Addr_LO_Nibble);                              //  0000 1101
 outport(LPTx,inport(LPTx) & 0x0B);                // Rd line = LOW;  0000 1001
 outport(LPTx + 2,0x04);             // set all lines high for read;  0000 0100
 Data_Byte = ( inport(LPTx + 2) & 0x0F );
 Data_Byte = Data_Byte | ( inport(LPTx + 1) & 0xF0);
 outport(LPTx,Base_Addr_LO_Nibble);              // Rd line = HIGH;  0000 11xx
 // invert inverted BASE + 2 data lines: D0, D1, and D3;
 Temp = Data_Byte & 0x0F;
 Temp = Inverted_Logic[Temp];
 return((Data_Byte & 0xF0 ) | Temp);
}

void Process_Speed_Request(void)
{
 /*
  Check for PAGE-UP, PAGE-DOWN, or ESC key pressing.
  Process PAGE-UP, and PAGE-DOWN  as request for faster or slower display
 */

 char Ch1, Ch2;

 Ch1 = getch();
 if(kbhit())
  Ch2 = getch();
 if(Ch1=='9'|| Ch1=='3'|| Ch1==ESC)
  Ch = Ch1;
 else
 {
  if(Ch2=='I'|| Ch2=='Q')
   Ch = Ch2;
 }
 switch(Ch)
 {
  case '9':
   if(T > 4)
    T = T - 3;
   break;
  case 'I':    // Go Faster
   if(T > 4)
    T = T - 3;
   break;
  case '3':
   if(T < 200)
    T = T + 3;
   break;
  case 'Q':    // Go Slower
   if(T < 200)
    T = T + 3;
   break;
  case '\27':
   exit(0);
 }
}

void main()
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 clrscr();
 Generate_Data();
 Send_Control_Word(0x89); // PORT 1 & 2 Output, PORT 3 Input,         1000 1001
 X = 0;
 do
 {
  //Output_Data();
  Port_Number = 2;
  Data_Byte = Input_Data(Port_Number);
  if(X != Data_Byte)   // only print data if it differs from old data, x
  {
   printf("Data = %i\n",Data_Byte);
   X = Data_Byte;
  }
  if(kbhit())
   Process_Speed_Request();
 }while(Ch != ESC);                          // exit if ESC key was pressed
}
