 /*                    PROGRAM Universal_Adaptor
		      Code conversion by Eugene Klein

   Test program for Universal Adaptor which converts a standard IBM parallel
   printer port into a true I/O  device with 8 bidirectional data bits and 4
   control lines.
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"


const int T = 130, ESC = 0x1B;   // ESC is escape character
int Num, E;
unsigned char A, Lpt_Num;
unsigned int LPTx;
char  Ch;

void Send_Data(unsigned char E)
{
 const int  Write_Bit = 0x00;         // D3, the Read / Write bit, is set LOW
 unsigned char Lo_Nibble, Hi_Nibble;

 outport(LPTx,Write_Bit);       //Write_Bit on 74LS241 is set HIGH
 Lo_Nibble = E & 0x0F;          //Low nibble of byte  goes to BASE + 2 address
 Lo_Nibble ^= 0x0B;             //Invert inverted pins, 0000 1011 = 0x0B hex
 /* Hi_Nibble := (E & 0xF0); */ //High nibble of byte goes to BASE address       }
 Hi_Nibble = (E & 0x0F) * 16;   //Just to watch  display in hex
 outport(LPTx, Hi_Nibble | Write_Bit); //Put high nibble on data lines          }
				       //Keep write bit active                  }
 outport(LPTx + 2,Lo_Nibble);   //Put lo-nibble data on D4 to D7 data lines    }
 delay(T);                      //Slow process down so I can observe LEDs      }
}

void Input_Data(void)
{
 unsigned char Lo_Nibble, Hi_Nibble, Temp, Data_Byte;

 Ch = ' ';
 do
 {
  outport(LPTx,0x08);             // Set R/W line for READ
  outport(LPTx + 2,0x04);         // 0000 0100,   init all pull-up resistors
//-=[ input data byte ]=-
  Lo_Nibble =inport(LPTx + 2);    // Read low nibble
  Temp = inport(LPTx+ 1);         // Read high nibble
//-=[ process HI nibble ]=-
  Hi_Nibble = Temp & 0x80;        // Extract D7
  Temp &= 0x38;                   // Extract remaining three bits
  Temp *= 2;                      // Shift these bits to left one place
  Hi_Nibble |= Temp;              // Recombine bits of nibble
  Hi_Nibble ^= 0x70;              // Invert inverted logic bits
//process LO nibble
  Lo_Nibble &= 0x0F;              // Extract data bits
  Lo_Nibble ^= 0x04;              // Invert inverted printer port logic
//display data
  gotoxy(10,8);
  printf("Hi_Nibble = %3i Lo Nibble = %3i;",Hi_Nibble,Lo_Nibble);
  Data_Byte = Hi_Nibble | Lo_Nibble;   // combined hi and lo nibbles
  gotoxy(10,15); printf("Input byte = %3i",Data_Byte);
  if(kbhit())
   Ch = getch(); // press any key to exit
 }while(Ch != ESC);
}

void main()
{
 unsigned char Lpt_Num;

 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 Ch = ' ';
 do
 {
  // set eight data bits high in binary order
  for(E = 0;E<= 32;E++)
    Send_Data(E);
  //set control bits high in binary sequence, ten times
  for(A=1;A<=10;A++)
  {
   E = 1;
   do
   {
    outport(LPTx,E & 0x0F);
    delay(T) ;
    E++;
   }while(E<=8);
  }
  if(kbhit())
   Ch = getch();
 }while(Ch != ESC);
 Input_Data();
}
