  /*                     PROGRAM Adc_0804
		  Code conversion by Eugene Klein
    Uses the parallel printer port to input analog data converted to
    8 bit binary by an ADC-0804 Analog / Digital, ( A/D ), converter IC.
  */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int Wr = 0x01;               // D0, at Base Address = Write line.
unsigned char  Lpt_Num, Lo_Nibble, Hi_Nibble;
unsigned int LPTx;
int  RD, New_Value, Old_Value;
float  Volts;

void Read_Data(void)
{
 // Pull-up all Base + 2, open collector output pins, BEFORE read instruction.
 outport(LPTx + 2,0x04); // 00000100 since D1, 2, & 3 are inverted.
 Lo_Nibble = inport(LPTx + 2);
 Hi_Nibble = inport(LPTx + 1);
}


void Start_Conversion(void)
 // ADC-0804 will start new conversion each time  WR line is strobed.
{
 outport(LPTx,Wr); // While software digest the current data.
 outport(LPTx,0);  // Strobe 0804 WR line to start new conversion.
 outport(LPTx,Wr); // While software digests the current data.
}

void Digest_Data(void)
{
 Lo_Nibble = Lo_Nibble & 0x0F;
 Hi_Nibble = Hi_Nibble & 0xF0;
 RD = Hi_Nibble | Lo_Nibble;
 New_Value = RD;
}

void Print_Results(void)
// Display the hi nibble, lo nibble, raw data and scaled voltage value.
{
 gotoxy(1,10); // Go to first position of the tenth line.                      }
 printf("High Nibble = %3i;       Low Nibble = %3i\n",Hi_Nibble,Lo_Nibble);
 Volts = ((float)RD * 5) / 255;
 printf("\nRaw Value = %3i;          Volts = %5.2f",RD,Volts);
 Old_Value = New_Value;
}

void  main()
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 New_Value = 0;
 Old_Value = 1;
 Start_Conversion();
   clrscr();
 do
 {
  Read_Data();
  Start_Conversion();
  Digest_Data();
    // Only waist time going to the screen if reading has changed.
  if(New_Value != Old_Value)
   Print_Results();
 }while(!kbhit());
}

